/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 400L;

    public JoinNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        super(id, leftInput, rightInput);
    }

    public JoinNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaConstraints binder) {
        super(id, leftInput, rightInput, binder);
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!workingMemory.isSequential()) {
            memory.getTupleMemory().add(leftTuple);
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
            }
            entry = (FactEntry)it.next();
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        if (workingMemory.isSequential()) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.sink.propagateAssertTuple(tuple, handle, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.sink.propagateRetractTuple(tuple, handle, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ReteTuple tuple = memory.getTupleMemory().remove(leftTuple);
        if (tuple == null) {
            return;
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            }
            entry = (FactEntry)it.next();
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getTupleMemory().iterator();
        ReteTuple tuple = (ReteTuple)tupleIter.next();
        while (tuple != null) {
            Iterator objectIter = memory.getFactHandleMemory().iterator(tuple);
            this.constraints.updateFromTuple(workingMemory, tuple);
            FactEntry entry = (FactEntry)objectIter.next();
            while (entry != null) {
                InternalFactHandle handle = entry.getFactHandle();
                if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                    sink.assertTuple(new ReteTuple(tuple, handle), context, workingMemory);
                }
                entry = (FactEntry)objectIter.next();
            }
            tuple = (ReteTuple)tupleIter.next();
        }
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.objectSource;
        }
        return "[JoinNode - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

