/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.BetaConstraints;
import org.drools.common.TupleStartEqualsConstraint;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.GroupElement;
import org.drools.rule.RuleConditionElement;

public class GroupElementBuilder
implements ReteooComponentBuilder {
    private final Map geBuilders = new HashMap();

    public GroupElementBuilder() {
        this.geBuilders.put(GroupElement.AND, new AndBuilder());
        this.geBuilders.put(GroupElement.OR, new OrBuilder());
        this.geBuilders.put(GroupElement.NOT, new NotBuilder());
        this.geBuilders.put(GroupElement.EXISTS, new ExistsBuilder());
    }

    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = (ReteooComponentBuilder)this.geBuilders.get(ge.getType());
        builder.build(context, utils, rce);
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = (ReteooComponentBuilder)this.geBuilders.get(ge.getType());
        return builder.requiresLeftActivation(utils, rce);
    }

    private static class ExistsBuilder
    implements ReteooComponentBuilder {
        private ExistsBuilder() {
        }

        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement exists = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            TupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = (RuleConditionElement)exists.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new RightInputAdapterNode(context.getNextId(), context.getTupleSource())));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<TupleStartEqualsConstraint> predicates = new ArrayList<TupleStartEqualsConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
            }
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            context.setTupleSource((TupleSource)utils.attachNode(context, new ExistsNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints)));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    private static class NotBuilder
    implements ReteooComponentBuilder {
        private NotBuilder() {
        }

        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement not = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            TupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = (RuleConditionElement)not.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new RightInputAdapterNode(context.getNextId(), context.getTupleSource())));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<TupleStartEqualsConstraint> predicates = new ArrayList<TupleStartEqualsConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
            }
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            context.setTupleSource((TupleSource)utils.attachNode(context, new NotNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints)));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    private static class OrBuilder
    implements ReteooComponentBuilder {
        private OrBuilder() {
        }

        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeDroolsException("BUG: Can't build a rete network with an inner OR group element");
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeDroolsException("BUG: Can't build a rete network with an inner OR group element");
        }
    }

    private static class AndBuilder
    implements ReteooComponentBuilder {
        private AndBuilder() {
        }

        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement ge = (GroupElement)rce;
            Iterator it = ge.getChildren().iterator();
            while (it.hasNext()) {
                RuleConditionElement child = (RuleConditionElement)it.next();
                ReteooComponentBuilder builder = utils.getBuilderFor(child);
                builder.build(context, utils, child);
                if (context.getObjectSource() != null && context.getTupleSource() == null) {
                    context.setTupleSource((TupleSource)utils.attachNode(context, new LeftInputAdapterNode(context.getNextId(), context.getObjectSource())));
                    context.setObjectSource(null);
                }
                if (context.getObjectSource() == null || context.getTupleSource() == null) continue;
                BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
                context.setTupleSource((TupleSource)utils.attachNode(context, new JoinNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints)));
                context.setBetaconstraints(null);
                context.setObjectSource(null);
            }
        }

        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            GroupElement and = (GroupElement)rce;
            if (and.getChildren().isEmpty()) {
                return true;
            }
            RuleConditionElement child = (RuleConditionElement)and.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            return builder.requiresLeftActivation(utils, child);
        }
    }
}

