/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.instance.impl;

import java.util.Iterator;
import java.util.List;
import org.drools.common.RuleFlowGroupNode;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.Constraint;
import org.drools.ruleflow.core.Split;
import org.drools.ruleflow.instance.RuleFlowNodeInstance;
import org.drools.ruleflow.instance.impl.RuleFlowNodeInstanceImpl;
import org.drools.spi.Activation;
import org.drools.spi.RuleFlowGroup;

public class RuleFlowSplitInstanceImpl
extends RuleFlowNodeInstanceImpl
implements RuleFlowNodeInstance {
    protected Split getSplitNode() {
        return (Split)this.getNode();
    }

    public void trigger(RuleFlowNodeInstance from) {
        Split split = this.getSplitNode();
        switch (split.getType()) {
            case 1: {
                List outgoing = split.getOutgoingConnections();
                Iterator iterator = outgoing.iterator();
                while (iterator.hasNext()) {
                    Connection connection = (Connection)iterator.next();
                    this.getProcessInstance().getNodeInstance(connection.getTo()).trigger(this);
                }
                break;
            }
            case 2: {
                List outgoing = split.getOutgoingConnections();
                int priority = Integer.MAX_VALUE;
                Connection selected = null;
                RuleFlowGroup systemRuleFlowGroup = this.getProcessInstance().getAgenda().getRuleFlowGroup("DROOLS_SYSTEM");
                Iterator iterator = outgoing.iterator();
                block6: while (iterator.hasNext()) {
                    Connection connection = (Connection)iterator.next();
                    Constraint constraint = split.getConstraint(connection);
                    if (constraint == null || constraint.getPriority() >= priority) continue;
                    String rule = "RuleFlow-" + this.getProcessInstance().getProcess().getId() + "-" + this.getNode().getId() + "-" + connection.getTo().getId();
                    Iterator activations = systemRuleFlowGroup.iterator();
                    while (activations.hasNext()) {
                        Activation activation = ((RuleFlowGroupNode)activations.next()).getActivation();
                        if (!rule.equals(activation.getRule().getName())) continue;
                        selected = connection;
                        priority = constraint.getPriority();
                        continue block6;
                    }
                }
                if (selected == null) {
                    throw new IllegalArgumentException("XOR split could not find at least one valid outgoing connection for split " + this.getSplitNode().getName());
                }
                this.getProcessInstance().getNodeInstance(selected.getTo()).trigger(this);
                break;
            }
            case 3: {
                List outgoing = split.getOutgoingConnections();
                boolean found = false;
                RuleFlowGroup systemRuleFlowGroup = this.getProcessInstance().getAgenda().getRuleFlowGroup("DROOLS_SYSTEM");
                Iterator iterator = outgoing.iterator();
                while (iterator.hasNext()) {
                    Connection connection = (Connection)iterator.next();
                    Constraint constraint = split.getConstraint(connection);
                    if (constraint != null) {
                        String rule = "RuleFlow-" + this.getProcessInstance().getProcess().getId() + "-" + this.getNode().getId() + "-" + connection.getTo().getId();
                        Iterator activations = systemRuleFlowGroup.iterator();
                        while (activations.hasNext()) {
                            Activation activation = ((RuleFlowGroupNode)activations.next()).getActivation();
                            if (!rule.equals(activation.getRule().getName())) continue;
                            this.getProcessInstance().getNodeInstance(connection.getTo()).trigger(this);
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("OR split could not find at least one valid outgoing connection for split " + this.getSplitNode().getName());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal split type " + split.getType());
            }
        }
    }
}

