/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.ArrayAgendaGroupFactory;
import org.drools.common.PriorityQueueAgendaGroupFactory;
import org.drools.concurrent.ExecutorService;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ConsequenceExceptionHandler;
import org.drools.util.ChainedProperties;

public class RuleBaseConfiguration
implements Serializable {
    private static final long serialVersionUID = 400L;
    private ChainedProperties chainedProperties;
    private boolean immutable;
    private boolean sequential;
    private SequentialAgenda sequentialAgenda;
    private boolean maintainTms;
    private boolean removeIdentities;
    private boolean shareAlphaNodes;
    private boolean shareBetaNodes;
    private boolean alphaMemory;
    private int alphaNodeHashingThreshold;
    private int compositeKeyDepth;
    private boolean indexLeftBetaMemory;
    private boolean indexRightBetaMemory;
    private AssertBehaviour assertBehaviour;
    private LogicalOverride logicalOverride;
    private ExecutorService executorService;
    private ConsequenceExceptionHandler consequenceExceptionHandler;
    private String ruleBaseUpdateHandler;
    private ConflictResolver conflictResolver;
    private boolean shadowProxy;
    private Map shadowProxyExcludes;
    private static final String STAR = "*";
    private transient ClassLoader classLoader;

    public RuleBaseConfiguration(Properties properties) {
        this.init(null, properties);
    }

    public RuleBaseConfiguration() {
        this.init(null, null);
    }

    public RuleBaseConfiguration(ClassLoader classLoader) {
        this.init(classLoader, null);
    }

    public RuleBaseConfiguration(ClassLoader classLoder, Properties properties) {
        this.init(this.classLoader, properties);
    }

    private void init(ClassLoader classLoader, Properties properties) {
        this.immutable = false;
        this.classLoader = classLoader != null ? classLoader : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader());
        this.chainedProperties = new ChainedProperties("rulebase.conf");
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(this.chainedProperties.getProperty("drools.sequential.agenda", "sequential")));
        this.setSequential(Boolean.valueOf(this.chainedProperties.getProperty("drools.sequential", "false")));
        this.setMaintainTms(Boolean.valueOf(this.chainedProperties.getProperty("drools.maintainTms", "true")));
        this.setRemoveIdentities(Boolean.valueOf(this.chainedProperties.getProperty("drools.removeIdentities", "false")));
        this.setAlphaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.alphaMemory", "false")));
        this.setShareAlphaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareAlphaNodes", "true")));
        this.setShareBetaNodes(Boolean.valueOf(this.chainedProperties.getProperty("drools.shareBetaNodes", "true")));
        this.setAlphaNodeHashingThreshold(Integer.parseInt(this.chainedProperties.getProperty("drools.alphaNodeHashingThreshold", "3")));
        this.setCompositeKeyDepth(Integer.parseInt(this.chainedProperties.getProperty("drools.compositeKeyDepth", "3")));
        this.setIndexLeftBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexLeftBetaMemory", "true")));
        this.setIndexRightBetaMemory(Boolean.valueOf(this.chainedProperties.getProperty("drools.indexRightBetaMemory", "true")));
        this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(this.chainedProperties.getProperty("drools.assertBehaviour", "identity")));
        this.setLogicalOverride(LogicalOverride.determineLogicalOverride(this.chainedProperties.getProperty("drools.logicalOverride", "discard")));
        this.setExecutorService(RuleBaseConfiguration.determineExecutorService(this.chainedProperties.getProperty("drools.executorService", "org.drools.concurrent.DefaultExecutorService")));
        this.setConsequenceExceptionHandler(RuleBaseConfiguration.determineConsequenceExceptionHandler(this.chainedProperties.getProperty("drools.consequenceExceptionHandler", "org.drools.base.DefaultConsequenceExceptionHandler")));
        this.setRuleBaseUpdateHandler(this.chainedProperties.getProperty("drools.ruleBaseUpdateHandler", "org.drools.base.FireAllRulesRuleBaseUpdateListener"));
        this.setConflictResolver(RuleBaseConfiguration.determineConflictResolver(this.chainedProperties.getProperty("drools.conflictResolver", "org.drools.conflict.DepthConflictResolver")));
        this.setShadowProxy(this.determineShadowProxy(this.chainedProperties.getProperty("drools.shadowproxy", "true")));
        this.setShadowProxyExcludes(this.chainedProperties.getProperty("drools.shadowProxyExcludes", ""));
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean isMaintainTms() {
        return this.maintainTms;
    }

    public void setMaintainTms(boolean maintainTms) {
        this.checkCanChange();
        this.maintainTms = maintainTms;
    }

    public boolean isRemoveIdentities() {
        return this.removeIdentities;
    }

    public void setRemoveIdentities(boolean removeIdentities) {
        this.checkCanChange();
        this.removeIdentities = removeIdentities;
    }

    public boolean isAlphaMemory() {
        return this.alphaMemory;
    }

    public void setAlphaMemory(boolean alphaMemory) {
        this.checkCanChange();
        this.alphaMemory = alphaMemory;
    }

    public boolean isShareAlphaNodes() {
        return this.shareAlphaNodes;
    }

    public void setShareAlphaNodes(boolean shareAlphaNodes) {
        this.checkCanChange();
        this.shareAlphaNodes = shareAlphaNodes;
    }

    public boolean isShareBetaNodes() {
        return this.shareBetaNodes;
    }

    public void setShareBetaNodes(boolean shareBetaNodes) {
        this.checkCanChange();
        this.shareBetaNodes = shareBetaNodes;
    }

    public int getAlphaNodeHashingThreshold() {
        return this.alphaNodeHashingThreshold;
    }

    public void setAlphaNodeHashingThreshold(int alphaNodeHashingThreshold) {
        this.checkCanChange();
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public AssertBehaviour getAssertBehaviour() {
        return this.assertBehaviour;
    }

    public void setAssertBehaviour(AssertBehaviour assertBehaviour) {
        this.checkCanChange();
        this.assertBehaviour = assertBehaviour;
    }

    public int getCompositeKeyDepth() {
        return this.compositeKeyDepth;
    }

    public void setCompositeKeyDepth(int compositeKeyDepth) {
        if (!this.immutable) {
            if (compositeKeyDepth > 3) {
                throw new UnsupportedOperationException("compositeKeyDepth cannot be greater than 3");
            }
        } else {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
        this.compositeKeyDepth = compositeKeyDepth;
    }

    public boolean isIndexLeftBetaMemory() {
        return this.indexLeftBetaMemory;
    }

    public void setIndexLeftBetaMemory(boolean indexLeftBetaMemory) {
        this.checkCanChange();
        this.indexLeftBetaMemory = indexLeftBetaMemory;
    }

    public boolean isIndexRightBetaMemory() {
        return this.indexRightBetaMemory;
    }

    public void setIndexRightBetaMemory(boolean indexRightBetaMemory) {
        this.checkCanChange();
        this.indexRightBetaMemory = indexRightBetaMemory;
    }

    public LogicalOverride getLogicalOverride() {
        return this.logicalOverride;
    }

    public void setLogicalOverride(LogicalOverride logicalOverride) {
        this.checkCanChange();
        this.logicalOverride = logicalOverride;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.checkCanChange();
        this.executorService = executorService;
    }

    public ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.consequenceExceptionHandler;
    }

    public void setConsequenceExceptionHandler(ConsequenceExceptionHandler consequenceExceptionHandler) {
        this.checkCanChange();
        this.consequenceExceptionHandler = consequenceExceptionHandler;
    }

    public String getRuleBaseUpdateHandler() {
        return this.ruleBaseUpdateHandler;
    }

    public void setRuleBaseUpdateHandler(String ruleBaseUpdateHandler) {
        this.checkCanChange();
        this.ruleBaseUpdateHandler = ruleBaseUpdateHandler;
    }

    public AgendaGroupFactory getAgendaGroupFactory() {
        if (this.isSequential()) {
            if (this.sequentialAgenda == SequentialAgenda.SEQUENTIAL) {
                return ArrayAgendaGroupFactory.getInstance();
            }
            return PriorityQueueAgendaGroupFactory.getInstance();
        }
        return PriorityQueueAgendaGroupFactory.getInstance();
    }

    public SequentialAgenda getSequentialAgenda() {
        return this.sequentialAgenda;
    }

    public void setSequentialAgenda(SequentialAgenda sequentialAgenda) {
        this.checkCanChange();
        this.sequentialAgenda = sequentialAgenda;
    }

    private boolean determineShadowProxy(String userValue) {
        if (this.isSequential()) {
            return false;
        }
        if (userValue != null) {
            return Boolean.valueOf(userValue);
        }
        return true;
    }

    private static ConflictResolver determineConflictResolver(String className) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                return (ConflictResolver)clazz.getMethod("getInstance", null).invoke(null, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to Conflict Resolver '" + className + "'");
            }
        }
        throw new IllegalArgumentException("conflict Resolver '" + className + "' not found");
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.checkCanChange();
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public void setShadowProxy(boolean shadowProxy) {
        this.checkCanChange();
        this.shadowProxy = shadowProxy;
    }

    public boolean isShadowProxy() {
        return this.shadowProxy;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setShadowProxyExcludes(String excludes) {
        this.checkCanChange();
        if (excludes == null || "".equals(excludes.trim())) {
            return;
        }
        if (this.shadowProxyExcludes == null) {
            this.shadowProxyExcludes = new HashMap();
        }
        String[] items = excludes.split(" ");
        for (int i = 0; i < items.length; ++i) {
            ArrayList<String> list;
            String qualifiedNamespace = items[i].substring(0, items[i].lastIndexOf(46)).trim();
            String name = items[i].substring(items[i].lastIndexOf(46) + 1).trim();
            Object object = this.shadowProxyExcludes.get(qualifiedNamespace);
            if (object == null) {
                if (STAR.equals(name)) {
                    this.shadowProxyExcludes.put(qualifiedNamespace, STAR);
                    continue;
                }
                list = new ArrayList<String>();
                list.add(name);
                this.shadowProxyExcludes.put(qualifiedNamespace, list);
                continue;
            }
            if (name.equals(STAR)) {
                this.shadowProxyExcludes.put(qualifiedNamespace, STAR);
                continue;
            }
            list = (ArrayList<String>)object;
            if (list.contains(object)) continue;
            list.add(name);
        }
    }

    public boolean isShadowed(String className) {
        if (this.shadowProxyExcludes == null) {
            return true;
        }
        String qualifiedNamespace = className.substring(0, className.lastIndexOf(46)).trim();
        String name = className.substring(className.lastIndexOf(46) + 1).trim();
        Object object = this.shadowProxyExcludes.get(qualifiedNamespace);
        if (object == null) {
            return true;
        }
        if (STAR.equals(object)) {
            return false;
        }
        List list = (List)object;
        return !list.contains(name);
    }

    private static ExecutorService determineExecutorService(String className) {
        return (ExecutorService)RuleBaseConfiguration.instantiateClass("ExecutorService", className);
    }

    private static ConsequenceExceptionHandler determineConsequenceExceptionHandler(String className) {
        return (ConsequenceExceptionHandler)RuleBaseConfiguration.instantiateClass("ConsequenceExceptionHandler", className);
    }

    private static Object instantiateClass(String type, String className) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate " + type + " '" + className + "'");
            }
        }
        throw new IllegalArgumentException(type + " '" + className + "' not found");
    }

    public static class SequentialAgenda
    implements Serializable {
        private static final long serialVersionUID = 400L;
        public static final SequentialAgenda SEQUENTIAL = new SequentialAgenda(0);
        public static final SequentialAgenda DYNAMIC = new SequentialAgenda(1);
        private int value;

        private SequentialAgenda(int value) {
            this.value = value;
        }

        public static SequentialAgenda determineSequentialAgenda(String value) {
            if ("sequential".equalsIgnoreCase(value)) {
                return SEQUENTIAL;
            }
            if ("dynamic".equalsIgnoreCase(value)) {
                return DYNAMIC;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for SequentialAgenda");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return SEQUENTIAL;
                }
                case 1: {
                    return DYNAMIC;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for SequentialAgenda");
        }

        public String toString() {
            return "SequentialAgenda : " + (this.value == 0 ? "sequential" : "dynamic");
        }
    }

    public static class LogicalOverride
    implements Serializable {
        private static final long serialVersionUID = 400L;
        public static final LogicalOverride PRESERVE = new LogicalOverride(0);
        public static final LogicalOverride DISCARD = new LogicalOverride(1);
        private int value;

        private LogicalOverride(int value) {
            this.value = value;
        }

        public static LogicalOverride determineLogicalOverride(String value) {
            if ("PRESERVE".equalsIgnoreCase(value)) {
                return PRESERVE;
            }
            if ("DISCARD".equalsIgnoreCase(value)) {
                return DISCARD;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for LogicalOverride");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return PRESERVE;
                }
                case 1: {
                    return DISCARD;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for LogicalOverride");
        }

        public String toString() {
            return "LogicalOverride : " + (this.value == 0 ? "preserve" : "discard");
        }
    }

    public static class AssertBehaviour
    implements Serializable {
        private static final long serialVersionUID = 400L;
        public static final AssertBehaviour IDENTITY = new AssertBehaviour(0);
        public static final AssertBehaviour EQUALITY = new AssertBehaviour(1);
        private int value;

        private AssertBehaviour(int value) {
            this.value = value;
        }

        public static AssertBehaviour determineAssertBehaviour(String value) {
            if ("IDENTITY".equalsIgnoreCase(value)) {
                return IDENTITY;
            }
            if ("EQUALITY".equalsIgnoreCase(value)) {
                return EQUALITY;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for AssertBehaviour");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return IDENTITY;
                }
                case 1: {
                    return EQUALITY;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for AssertBehaviour");
        }

        public String toString() {
            return "AssertBehaviour : " + (this.value == 0 ? "identity" : "equality");
        }
    }
}

