/*
 * Decompiled with CFR 0.152.
 */
package org.drools.facttemplates;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplate;
import org.drools.spi.FieldExtractor;
import org.drools.util.ClassUtils;

public class FactTemplateFieldExtractor
implements FieldExtractor {
    private static final long serialVersionUID = 400L;
    private FactTemplate factTemplate;
    private int fieldIndex;

    public FactTemplateFieldExtractor(FactTemplate factTemplate, int fieldIndex) {
        this.factTemplate = factTemplate;
        this.fieldIndex = fieldIndex;
    }

    public ValueType getValueType() {
        return this.factTemplate.getFieldTemplate(this.fieldIndex).getValueType();
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex);
    }

    public int getIndex() {
        return this.fieldIndex;
    }

    public Class getExtractToClass() {
        return Fact.class;
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName(Fact.class);
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return (Boolean)((Fact)object).getFieldValue(this.fieldIndex);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).byteValue();
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Character)((Fact)object).getFieldValue(this.fieldIndex)).charValue();
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).doubleValue();
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).floatValue();
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).intValue();
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).longValue();
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).shortValue();
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.getValue(workingMemory, object).hashCode();
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex) == null;
    }
}

