/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.Sink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.FactHashTable;
import org.drools.util.Iterator;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
Serializable,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final ObjectType objectType;
    private final Rete rete = (Rete)this.objectSource;
    private boolean skipOnModify = false;
    private boolean objectMemoryEnabled;

    public ObjectTypeNode(int id, ObjectType objectType, BuildContext context) {
        super(id, context.getRuleBase().getRete(), context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.objectType = objectType;
        this.setObjectMemoryEnabled(context.isObjectTypeNodeMemoryEnabled());
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public boolean matches(Object object) {
        return this.objectType.matches(object);
    }

    public boolean isAssignableFrom(Object object) {
        return this.objectType.isAssignableFrom(object);
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (context.getType() == 2 && this.skipOnModify && context.getDormantActivations() == 0) {
            return;
        }
        if (this.objectMemoryEnabled) {
            FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
            memory.add(handle, false);
        }
        this.sink.propagateAssertObject(handle, context, workingMemory);
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (context.getType() == 2 && this.skipOnModify && context.getDormantActivations() == 0) {
            return;
        }
        FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
        memory.remove(handle);
        this.sink.propagateRetractObject(handle, context, workingMemory, true);
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            sink.assertObject(entry.getFactHandle(), context, workingMemory);
            entry = (FactEntry)it.next();
        }
    }

    public void attach() {
        this.rete.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.rete.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
            this.rete.removeObjectSink(this);
        }
    }

    public void addShare() {
        super.addShare();
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new FactHashTable();
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    public String toString() {
        return "[ObjectTypeNode(" + this.id + ") objectType=" + this.objectType + "]";
    }

    public int hashCode() {
        return this.objectType.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectTypeNode)) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.objectType.equals(other.objectType);
    }

    protected void addObjectSink(ObjectSink objectSink) {
        super.addObjectSink(objectSink);
        this.skipOnModify = this.canSkipOnModify(this.sink.getSinks());
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        super.removeObjectSink(objectSink);
        this.skipOnModify = this.canSkipOnModify(this.sink.getSinks());
    }

    private boolean canSkipOnModify(Sink[] sinks) {
        boolean hasConstraints = false;
        for (int i = 0; i < sinks.length && !hasConstraints; ++i) {
            if (sinks[i] instanceof AlphaNode) {
                hasConstraints = this.usesDeclaration(((AlphaNode)sinks[i]).getConstraint());
            } else if (sinks[i] instanceof BetaNode && ((BetaNode)sinks[i]).getConstraints().length > 0) {
                hasConstraints = this.usesDeclaration(((BetaNode)sinks[i]).getConstraints());
            }
            if (!hasConstraints && sinks[i] instanceof ObjectSource) {
                hasConstraints = this.canSkipOnModify(((ObjectSource)((Object)sinks[i])).getSinkPropagator().getSinks());
                continue;
            }
            if (!(sinks[i] instanceof TupleSource)) continue;
            hasConstraints = this.canSkipOnModify(((TupleSource)((Object)sinks[i])).getSinkPropagator().getSinks());
        }
        return !hasConstraints;
    }

    private boolean usesDeclaration(Constraint[] constraints) {
        boolean usesDecl = false;
        for (int i = 0; !usesDecl && i < constraints.length; ++i) {
            usesDecl = this.usesDeclaration(constraints[i]);
        }
        return usesDecl;
    }

    private boolean usesDeclaration(Constraint constraint) {
        boolean usesDecl = false;
        Declaration[] declarations = constraint.getRequiredDeclarations();
        for (int j = 0; !usesDecl && j < declarations.length; ++j) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
        }
        return usesDecl;
    }
}

