/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;

public class PrimitiveLongStack
implements Serializable {
    private static final long serialVersionUID = 400L;
    private final int tableSize;
    private int currentPageId;
    private Page currentPage;

    public PrimitiveLongStack() {
        this(256);
    }

    public PrimitiveLongStack(int tableSize) {
        this.tableSize = tableSize;
        this.currentPageId = 0;
        this.currentPage = new Page(null, this.currentPageId, this.tableSize);
    }

    public void push(long value) {
        if (this.currentPage.getPosition() == this.tableSize - 1) {
            Page node;
            this.currentPage = node = new Page(this.currentPage, ++this.currentPageId, this.tableSize);
        }
        this.currentPage.push(value);
    }

    public long pop() {
        if (this.currentPage.getPosition() == -1) {
            if (this.currentPageId == 0) {
                throw new RuntimeException("Unable to pop");
            }
            Page node = this.currentPage;
            this.currentPage = node.getPreviousSibling();
            --this.currentPageId;
            node.remove();
        }
        return this.currentPage.pop();
    }

    public boolean isEmpty() {
        return this.currentPageId == 0 && this.currentPage.getPosition() == -1;
    }

    private static final class Page
    implements Serializable {
        private static final long serialVersionUID = 400L;
        private final int pageId;
        private Page nextSibling;
        private Page previousSibling;
        private long[] table;
        private int lastKey;

        Page(Page previousSibling, int nodeId, int tableSize) {
            this.previousSibling = previousSibling;
            if (this.previousSibling != null) {
                this.previousSibling.setNextSibling(this);
            }
            this.pageId = nodeId;
            this.lastKey = -1;
            this.table = new long[tableSize];
        }

        public int getNodeId() {
            return this.pageId;
        }

        void setNextSibling(Page nextSibling) {
            this.nextSibling = nextSibling;
        }

        public Page getNextSibling() {
            return this.nextSibling;
        }

        public Page getPreviousSibling() {
            return this.previousSibling;
        }

        public long pop() {
            return this.table[this.lastKey--];
        }

        public void push(long value) {
            this.table[++this.lastKey] = value;
        }

        public int getPosition() {
            return this.lastKey;
        }

        void remove() {
            this.previousSibling.setNextSibling(null);
            this.previousSibling = null;
            this.table = null;
        }
    }
}

