/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.Package;

public class DroolsObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private InternalRuleBase ruleBase;
    private InternalWorkingMemory workingMemory;
    private Package pkg;
    private ClassFieldExtractorCache extractorFactory;
    private static final HashMap primClasses = new HashMap(8, 1.0f);

    public DroolsObjectInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public DroolsObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
        this.extractorFactory = ClassFieldExtractorCache.getInstance();
        this.enableResolveObject(true);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.classLoader == null) {
            return super.resolveClass(desc);
        }
        String name = desc.getName();
        Class<?> clazz = (Class<?>)primClasses.get(name);
        if (clazz == null) {
            try {
                clazz = this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnf) {
                clazz = super.resolveClass(desc);
            }
        }
        return clazz;
    }

    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    public ClassFieldExtractorCache getExtractorFactory() {
        return this.extractorFactory;
    }

    public void setExtractorFactory(ClassFieldExtractorCache extractorFactory) {
        this.extractorFactory = extractorFactory;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

