/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.InitialFact;
import org.drools.WorkingMemoryEntryPoint;
import org.drools.common.ActivationIterator;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.EqualityKey;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LeftTupleIterator;
import org.drools.common.LogicalDependency;
import org.drools.common.Memory;
import org.drools.common.NamedEntryPoint;
import org.drools.common.NodeMemories;
import org.drools.common.ObjectStore;
import org.drools.common.QueryElementFactHandle;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.ObjectHashMap;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyStore;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProcessMarshaller;
import org.drools.marshalling.impl.ProcessMarshallerFactory;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.QueryElementNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.RuleFlowGroup;
import org.drools.time.JobContext;
import org.drools.time.SelfRemovalJobContext;
import org.drools.time.Trigger;
import org.drools.time.impl.CronTrigger;
import org.drools.time.impl.IntervalTrigger;
import org.drools.time.impl.PointInTimeTrigger;
import org.drools.time.impl.PseudoClockScheduler;
import org.drools.time.impl.TimerJobInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtobufOutputMarshaller {
    private static ProcessMarshaller processMarshaller = ProtobufOutputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void writeSession(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.KnowledgeSession _session = ProtobufOutputMarshaller.serializeSession(context);
        PersisterHelper.writeToStreamWithHeader(context, (Message)_session);
    }

    private static ProtobufMessages.KnowledgeSession serializeSession(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.Timers _timers;
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        wm.getAgenda().unstageActivations();
        ProtobufMessages.RuleData.Builder _ruleData = ProtobufMessages.RuleData.newBuilder();
        boolean multithread = wm.isPartitionManagersActive();
        if (multithread) {
            wm.stopPartitionManagers();
        }
        long time = 0L;
        if (context.wm.getTimerService() instanceof PseudoClockScheduler) {
            time = context.clockTime;
        }
        _ruleData.setLastId(wm.getFactHandleFactory().getId());
        _ruleData.setLastRecency(wm.getFactHandleFactory().getRecency());
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        ProtobufMessages.FactHandle _ifh = ProtobufMessages.FactHandle.newBuilder().setType(ProtobufMessages.FactHandle.HandleType.INITIAL_FACT).setId(handle.getId()).setRecency(handle.getRecency()).build();
        _ruleData.setInitialFact(_ifh);
        ProtobufOutputMarshaller.writeAgenda(context, _ruleData);
        ProtobufOutputMarshaller.writeNodeMemories(context, _ruleData);
        for (WorkingMemoryEntryPoint wmep : wm.getEntryPoints().values()) {
            ProtobufMessages.EntryPoint.Builder _epb = ProtobufMessages.EntryPoint.newBuilder();
            _epb.setEntryPointId(wmep.getEntryPointId());
            ProtobufOutputMarshaller.writeFactHandles(context, _epb, ((NamedEntryPoint)wmep).getObjectStore());
            _ruleData.addEntryPoint(_epb.build());
        }
        ProtobufOutputMarshaller.writeActionQueue(context, _ruleData);
        ProtobufOutputMarshaller.writeTruthMaintenanceSystem(context, _ruleData);
        ProtobufMessages.KnowledgeSession.Builder _session = ProtobufMessages.KnowledgeSession.newBuilder().setMultithread(multithread).setTime(time).setRuleData(_ruleData.build());
        if (processMarshaller != null) {
            ProtobufMessages.ProcessData.Builder _pdata = ProtobufMessages.ProcessData.newBuilder();
            if (context.marshalProcessInstances) {
                context.parameterObject = _pdata;
                processMarshaller.writeProcessInstances(context);
            }
            if (context.marshalWorkItems) {
                context.parameterObject = _pdata;
                processMarshaller.writeWorkItems(context);
            }
            context.parameterObject = _pdata;
            processMarshaller.writeProcessTimers(context);
            _session.setProcessData(_pdata.build());
        }
        if ((_timers = ProtobufOutputMarshaller.writeTimers(context.wm.getTimerService().getTimerJobInstances(), context)) != null) {
            _session.setTimers(_timers);
        }
        if (multithread) {
            wm.startPartitionManagers();
        }
        return _session.build();
    }

    private static void writeAgenda(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _ksb) throws IOException {
        InternalWorkingMemory wm = context.wm;
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        ProtobufMessages.Agenda.Builder _ab = ProtobufMessages.Agenda.newBuilder();
        AgendaGroup[] agendaGroups = agenda.getAgendaGroupsMap().values().toArray(new AgendaGroup[agenda.getAgendaGroupsMap().size()]);
        Arrays.sort(agendaGroups, AgendaGroupSorter.instance);
        for (AgendaGroup group : agendaGroups) {
            ProtobufMessages.Agenda.AgendaGroup.Builder _agb = ProtobufMessages.Agenda.AgendaGroup.newBuilder();
            _agb.setName(group.getName());
            _agb.setIsActive(group.isActive());
            _ab.addAgendaGroup(_agb.build());
        }
        ProtobufMessages.Agenda.FocusStack.Builder _fsb = ProtobufMessages.Agenda.FocusStack.newBuilder();
        java.util.LinkedList<AgendaGroup> focusStack = agenda.getStackList();
        for (AgendaGroup group : focusStack) {
            _fsb.addGroupName(group.getName());
        }
        _ab.setFocusStack(_fsb.build());
        RuleFlowGroupImpl[] ruleFlowGroups = agenda.getRuleFlowGroupsMap().values().toArray(new RuleFlowGroupImpl[agenda.getRuleFlowGroupsMap().size()]);
        Arrays.sort(ruleFlowGroups, RuleFlowGroupSorter.instance);
        for (RuleFlowGroupImpl group : ruleFlowGroups) {
            ProtobufMessages.Agenda.RuleFlowGroup.Builder _rfgb = ProtobufMessages.Agenda.RuleFlowGroup.newBuilder();
            _rfgb.setName(group.getName());
            _rfgb.setIsActive(group.isActive());
            _rfgb.setIsAutoDeactivate(group.isAutoDeactivate());
            Map<Long, String> nodeInstances = group.getNodeInstances();
            for (Map.Entry<Long, String> entry : nodeInstances.entrySet()) {
                ProtobufMessages.Agenda.RuleFlowGroup.NodeInstance.Builder _nib = ProtobufMessages.Agenda.RuleFlowGroup.NodeInstance.newBuilder();
                _nib.setProcessInstanceId(entry.getKey());
                _nib.setNodeInstanceId(entry.getValue());
                _rfgb.addNodeInstance(_nib.build());
            }
            _ab.addRuleFlowGroup(_rfgb.build());
        }
        ActivationIterator it = ActivationIterator.iterator(wm);
        ArrayList<Activation> dormant = new ArrayList<Activation>();
        Activation item = (Activation)it.next();
        while (item != null) {
            if (!item.isActive()) {
                dormant.add(item);
            }
            item = (Activation)it.next();
        }
        Collections.sort(dormant, ActivationsSorter.INSTANCE);
        for (Activation activation : dormant) {
            _ab.addActivation(ProtobufOutputMarshaller.writeActivation(context, (AgendaItem)activation));
        }
        _ksb.setAgenda(_ab.build());
    }

    private static void writeNodeMemories(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _ksb) throws IOException {
        InternalWorkingMemory wm = context.wm;
        NodeMemories memories = wm.getNodeMemories();
        for (int i = 0; i < memories.length(); ++i) {
            Memory memory = memories.peekNodeMemory(i);
            if (memory == null) continue;
            ProtobufMessages.NodeMemory _node = null;
            switch (memory.getNodeType()) {
                case 6: {
                    _node = ProtobufOutputMarshaller.writeAccumulateNodeMemory(i, memory);
                    break;
                }
                case 7: {
                    _node = ProtobufOutputMarshaller.writeRIANodeMemory(i, memory);
                    break;
                }
                case 4: {
                    _node = ProtobufOutputMarshaller.writeFromNodeMemory(i, memory);
                    break;
                }
                case 18: {
                    _node = ProtobufOutputMarshaller.writeQueryElementNodeMemory(i, memory, wm);
                }
            }
            if (_node == null) continue;
            _ksb.addNodeMemory(_node);
        }
    }

    private static ProtobufMessages.NodeMemory writeAccumulateNodeMemory(int nodeId, Memory memory) {
        AccumulateNode.AccumulateMemory accmem = (AccumulateNode.AccumulateMemory)memory;
        if (accmem.betaMemory.getLeftTupleMemory().size() > 0) {
            ProtobufMessages.NodeMemory.AccumulateNodeMemory.Builder _accumulate = ProtobufMessages.NodeMemory.AccumulateNodeMemory.newBuilder();
            org.drools.core.util.Iterator tupleIter = accmem.betaMemory.getLeftTupleMemory().iterator();
            LeftTuple leftTuple = (LeftTuple)tupleIter.next();
            while (leftTuple != null) {
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                if (accctx.result != null) {
                    ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(accctx.result.getFactHandle().getId()).setRecency(accctx.result.getFactHandle().getRecency()).build();
                    _accumulate.addContext(ProtobufMessages.NodeMemory.AccumulateNodeMemory.AccumulateContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setResultHandle(_handle).build());
                }
                leftTuple = (LeftTuple)tupleIter.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.ACCUMULATE).setAccumulate(_accumulate.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeRIANodeMemory(int nodeId, Memory memory) {
        RightInputAdapterNode.RIAMemory mem = (RightInputAdapterNode.RIAMemory)memory;
        if (!mem.memory.isEmpty()) {
            ProtobufMessages.NodeMemory.RIANodeMemory.Builder _ria = ProtobufMessages.NodeMemory.RIANodeMemory.newBuilder();
            org.drools.core.util.Iterator it = mem.memory.iterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(handle.getId()).setRecency(handle.getRecency()).build();
                _ria.addContext(ProtobufMessages.NodeMemory.RIANodeMemory.RIAContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setResultHandle(_handle).build());
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.RIA).setRia(_ria.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeFromNodeMemory(int nodeId, Memory memory) {
        FromNode.FromMemory fromMemory = (FromNode.FromMemory)memory;
        if (fromMemory.betaMemory.getLeftTupleMemory().size() > 0) {
            ProtobufMessages.NodeMemory.FromNodeMemory.Builder _from = ProtobufMessages.NodeMemory.FromNodeMemory.newBuilder();
            org.drools.core.util.Iterator tupleIter = fromMemory.betaMemory.getLeftTupleMemory().iterator();
            LeftTuple leftTuple = (LeftTuple)tupleIter.next();
            while (leftTuple != null) {
                Map matches = (Map)leftTuple.getObject();
                ProtobufMessages.NodeMemory.FromNodeMemory.FromContext.Builder _context = ProtobufMessages.NodeMemory.FromNodeMemory.FromContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple));
                for (RightTuple rightTuple : matches.values()) {
                    ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(rightTuple.getFactHandle().getId()).setRecency(rightTuple.getFactHandle().getRecency()).build();
                    _context.addHandle(_handle);
                }
                _from.addContext(_context.build());
                leftTuple = (LeftTuple)tupleIter.next();
            }
            return ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.FROM).setFrom(_from.build()).build();
        }
        return null;
    }

    private static ProtobufMessages.NodeMemory writeQueryElementNodeMemory(int nodeId, Memory memory, InternalWorkingMemory wm) {
        LeftTupleIterator it = LeftTupleIterator.iterator(wm, ((QueryElementNode.QueryElementNodeMemory)memory).node);
        ProtobufMessages.NodeMemory.QueryElementNodeMemory.Builder _query = ProtobufMessages.NodeMemory.QueryElementNodeMemory.newBuilder();
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            InternalFactHandle handle = (InternalFactHandle)leftTuple.getObject();
            ProtobufMessages.FactHandle _handle = ProtobufMessages.FactHandle.newBuilder().setId(handle.getId()).setRecency(handle.getRecency()).build();
            ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext.Builder _context = ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext.newBuilder().setTuple(PersisterHelper.createTuple(leftTuple)).setHandle(_handle);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                _context.addResult(ProtobufMessages.FactHandle.newBuilder().setId(rightParent.getFactHandle().getId()).setRecency(rightParent.getFactHandle().getRecency()).build());
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            _query.addContext(_context.build());
            leftTuple = (LeftTuple)it.next();
        }
        return _query.getContextCount() > 0 ? ProtobufMessages.NodeMemory.newBuilder().setNodeId(nodeId).setNodeType(ProtobufMessages.NodeMemory.NodeType.QUERY_ELEMENT).setQueryElement(_query.build()).build() : null;
    }

    public static void writeActionQueue(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _session) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        if (!wm.getActionQueue().isEmpty()) {
            ProtobufMessages.ActionQueue.Builder _queue = ProtobufMessages.ActionQueue.newBuilder();
            WorkingMemoryAction[] queue = wm.getActionQueue().toArray(new WorkingMemoryAction[wm.getActionQueue().size()]);
            for (int i = queue.length - 1; i >= 0; --i) {
                _queue.addAction(queue[i].serialize(context));
            }
            _session.setActionQueue(_queue.build());
        }
    }

    public static void writeTruthMaintenanceSystem(MarshallerWriteContext context, ProtobufMessages.RuleData.Builder _session) throws IOException {
        ObjectHashMap assertMap = context.wm.getTruthMaintenanceSystem().getAssertMap();
        ObjectHashMap justifiedMap = context.wm.getTruthMaintenanceSystem().getJustifiedMap();
        if (!assertMap.isEmpty() || !justifiedMap.isEmpty()) {
            EqualityKey[] keys = new EqualityKey[assertMap.size()];
            org.drools.core.util.Iterator it = assertMap.iterator();
            int i = 0;
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                EqualityKey key = (EqualityKey)entry.getKey();
                keys[i++] = key;
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
            Arrays.sort(keys, EqualityKeySorter.instance);
            ProtobufMessages.TruthMaintenanceSystem.Builder _tms = ProtobufMessages.TruthMaintenanceSystem.newBuilder();
            for (EqualityKey key : keys) {
                ProtobufMessages.EqualityKey.Builder _key = ProtobufMessages.EqualityKey.newBuilder();
                _key.setStatus(key.getStatus());
                _key.setHandleId(key.getFactHandle().getId());
                if (key.getOtherFactHandle() != null && !key.getOtherFactHandle().isEmpty()) {
                    for (InternalFactHandle handle : key.getOtherFactHandle()) {
                        _key.addOtherHandle(handle.getId());
                    }
                }
                _tms.addKey(_key.build());
            }
            it = justifiedMap.iterator();
            i = 0;
            ObjectHashMap.ObjectEntry entry2 = (ObjectHashMap.ObjectEntry)it.next();
            while (entry2 != null) {
                ProtobufMessages.Justification.Builder _justification = ProtobufMessages.Justification.newBuilder();
                _justification.setHandleId((Integer)entry2.getKey());
                LinkedList list = (LinkedList)entry2.getValue();
                for (LinkedListEntry node = (LinkedListEntry)list.getFirst(); node != null; node = (LinkedListEntry)node.getNext()) {
                    LogicalDependency dependency = (LogicalDependency)node.getObject();
                    Activation activation = dependency.getJustifier();
                    ProtobufMessages.Activation _activation = ProtobufMessages.Activation.newBuilder().setPackageName(activation.getRule().getPackage()).setRuleName(activation.getRule().getName()).setTuple(PersisterHelper.createTuple(activation.getTuple())).build();
                    _justification.addActivation(_activation);
                }
                _tms.addJustification(_justification.build());
                entry2 = (ObjectHashMap.ObjectEntry)it.next();
            }
            _session.setTms(_tms.build());
        }
    }

    private static void writeFactHandles(MarshallerWriteContext context, ProtobufMessages.EntryPoint.Builder _epb, ObjectStore objectStore) throws IOException {
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = context.objectMarshallingStrategyStore;
        for (InternalFactHandle handle : ProtobufOutputMarshaller.orderFacts(objectStore)) {
            ProtobufMessages.FactHandle _handle = ProtobufOutputMarshaller.writeFactHandle(context, objectMarshallingStrategyStore, handle);
            _epb.addHandle(_handle);
        }
    }

    private static ProtobufMessages.FactHandle writeFactHandle(MarshallerWriteContext context, ObjectMarshallingStrategyStore objectMarshallingStrategyStore, InternalFactHandle handle) throws IOException {
        Object object;
        ProtobufMessages.FactHandle.Builder _handle = ProtobufMessages.FactHandle.newBuilder();
        _handle.setType(ProtobufOutputMarshaller.getHandleType(handle));
        _handle.setId(handle.getId());
        _handle.setRecency(handle.getRecency());
        if (_handle.getType() == ProtobufMessages.FactHandle.HandleType.EVENT) {
            EventFactHandle efh = (EventFactHandle)handle;
            _handle.setTimestamp(efh.getStartTimestamp());
            _handle.setDuration(efh.getDuration());
            _handle.setIsExpired(efh.isExpired());
            _handle.setActivationsCount(efh.getActivationsCount());
        }
        if ((object = handle.getObject()) != null) {
            ObjectMarshallingStrategy strategy = objectMarshallingStrategyStore.getStrategyObject(object);
            String strategyClassName = strategy.getClass().getName();
            Integer index = context.usedStrategies.get(strategyClassName);
            if (index == null) {
                index = context.usedStrategies.size();
                context.usedStrategies.put(strategyClassName, index);
            }
            _handle.setStrategyIndex(index);
            _handle.setObject(ByteString.copyFrom((byte[])strategy.marshal((ObjectOutputStream)context, object)));
        }
        return _handle.build();
    }

    private static ProtobufMessages.FactHandle.HandleType getHandleType(InternalFactHandle handle) {
        if (handle instanceof EventFactHandle) {
            return ProtobufMessages.FactHandle.HandleType.EVENT;
        }
        if (handle instanceof QueryElementFactHandle) {
            return ProtobufMessages.FactHandle.HandleType.QUERY;
        }
        if (handle.getObject() instanceof InitialFact) {
            return ProtobufMessages.FactHandle.HandleType.INITIAL_FACT;
        }
        return ProtobufMessages.FactHandle.HandleType.FACT;
    }

    public static InternalFactHandle[] orderFacts(ObjectStore objectStore) {
        int size = objectStore.size();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        int i = 0;
        Iterator it = objectStore.iterateFactHandles();
        while (it.hasNext()) {
            handles[i++] = (InternalFactHandle)it.next();
        }
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static InternalFactHandle[] orderFacts(List<InternalFactHandle> handlesList) {
        int size = handlesList.size();
        InternalFactHandle[] handles = handlesList.toArray(new InternalFactHandle[size]);
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static ProtobufMessages.Activation writeActivation(MarshallerWriteContext context, AgendaItem agendaItem) {
        LinkedList list;
        ProtobufMessages.Activation.Builder _activation = ProtobufMessages.Activation.newBuilder();
        Rule rule = agendaItem.getRule();
        _activation.setPackageName(rule.getPackage());
        _activation.setRuleName(rule.getName());
        ProtobufMessages.Tuple.Builder _tb = ProtobufMessages.Tuple.newBuilder();
        for (LeftTuple entry = agendaItem.getTuple(); entry != null; entry = entry.getParent()) {
            InternalFactHandle handle = entry.getLastHandle();
            _tb.addHandleId(handle.getId());
        }
        _activation.setTuple(_tb.build());
        _activation.setSalience(agendaItem.getSalience());
        _activation.setIsActivated(agendaItem.isActivated());
        if (agendaItem.getActivationGroupNode() != null) {
            _activation.setActivationGroup(agendaItem.getActivationGroupNode().getActivationGroup().getName());
        }
        if (agendaItem.getFactHandle() != null) {
            _activation.setHandleId(agendaItem.getFactHandle().getId());
        }
        if ((list = agendaItem.getLogicalDependencies()) != null && !list.isEmpty()) {
            for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                _activation.addLogicalDependency(((InternalFactHandle)node.getJustified()).getId());
            }
        }
        return _activation.build();
    }

    private static ProtobufMessages.Timers writeTimers(Collection<TimerJobInstance> timers, MarshallerWriteContext outCtx) {
        if (!timers.isEmpty()) {
            ArrayList<TimerJobInstance> sortedTimers = new ArrayList<TimerJobInstance>(timers);
            Collections.sort(sortedTimers, new Comparator<TimerJobInstance>(){

                @Override
                public int compare(TimerJobInstance o1, TimerJobInstance o2) {
                    return (int)(o1.getJobHandle().getId() - o2.getJobHandle().getId());
                }
            });
            ProtobufMessages.Timers.Builder _timers = ProtobufMessages.Timers.newBuilder();
            for (TimerJobInstance timer : sortedTimers) {
                JobContext jctx = ((SelfRemovalJobContext)timer.getJobContext()).getJobContext();
                TimersOutputMarshaller writer = outCtx.writersByClass.get(jctx.getClass());
                ProtobufMessages.Timers.Timer _timer = writer.serialize(jctx, outCtx);
                _timers.addTimer(_timer);
            }
            return _timers.build();
        }
        return null;
    }

    public static ProtobufMessages.Trigger writeTrigger(Trigger trigger, MarshallerWriteContext outCtx) {
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            ProtobufMessages.Trigger.CronTrigger.Builder _cron = ProtobufMessages.Trigger.CronTrigger.newBuilder().setStartTime(cronTrigger.getStartTime().getTime()).setRepeatLimit(cronTrigger.getRepeatLimit()).setRepeatCount(cronTrigger.getRepeatCount()).setCronExpression(cronTrigger.getCronEx().getCronExpression());
            if (cronTrigger.getEndTime() != null) {
                _cron.setEndTime(cronTrigger.getEndTime().getTime());
            }
            if (cronTrigger.getNextFireTime() != null) {
                _cron.setNextFireTime(cronTrigger.getNextFireTime().getTime());
            }
            if (cronTrigger.getCalendarNames() != null) {
                for (String calendarName : cronTrigger.getCalendarNames()) {
                    _cron.addCalendarName(calendarName);
                }
            }
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.CRON).setCron(_cron.build()).build();
        }
        if (trigger instanceof IntervalTrigger) {
            IntervalTrigger intTrigger = (IntervalTrigger)trigger;
            ProtobufMessages.Trigger.IntervalTrigger.Builder _interval = ProtobufMessages.Trigger.IntervalTrigger.newBuilder().setStartTime(intTrigger.getStartTime().getTime()).setRepeatLimit(intTrigger.getRepeatLimit()).setRepeatCount(intTrigger.getRepeatCount()).setPeriod(intTrigger.getPeriod());
            if (intTrigger.getEndTime() != null) {
                _interval.setEndTime(intTrigger.getEndTime().getTime());
            }
            if (intTrigger.getNextFireTime() != null) {
                _interval.setNextFireTime(intTrigger.getNextFireTime().getTime());
            }
            if (intTrigger.getCalendarNames() != null) {
                for (String calendarName : intTrigger.getCalendarNames()) {
                    _interval.addCalendarName(calendarName);
                }
            }
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.INTERVAL).setInterval(_interval.build()).build();
        }
        if (trigger instanceof PointInTimeTrigger) {
            PointInTimeTrigger pinTrigger = (PointInTimeTrigger)trigger;
            return ProtobufMessages.Trigger.newBuilder().setType(ProtobufMessages.Trigger.TriggerType.POINT_IN_TIME).setPit(ProtobufMessages.Trigger.PointInTimeTrigger.newBuilder().setNextFireTime(pinTrigger.hasNextFireTime().getTime()).build()).build();
        }
        throw new RuntimeException("Unable to serialize Trigger for type: " + trigger.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActivationsSorter
    implements Comparator<Activation> {
        public static final ActivationsSorter INSTANCE = new ActivationsSorter();

        @Override
        public int compare(Activation o1, Activation o2) {
            int result = o1.getRule().getName().compareTo(o2.getRule().getName());
            if (result == 0) {
                LeftTuple t1 = o1.getTuple();
                for (LeftTuple t2 = o2.getTuple(); result == 0 && t1 != null && t2 != null; t1 = t1.getParent(), t2 = t2.getParent()) {
                    result = t1.getLastHandle().getId() - t2.getLastHandle().getId();
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleSorter
    implements Comparator<InternalFactHandle> {
        @Override
        public int compare(InternalFactHandle h1, InternalFactHandle h2) {
            return h1.getId() - h2.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualityKeySorter
    implements Comparator<EqualityKey> {
        public static final EqualityKeySorter instance = new EqualityKeySorter();

        @Override
        public int compare(EqualityKey key1, EqualityKey key2) {
            return key1.getFactHandle().getId() - key2.getFactHandle().getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RuleFlowGroupSorter
    implements Comparator<RuleFlowGroup> {
        public static final RuleFlowGroupSorter instance = new RuleFlowGroupSorter();

        private RuleFlowGroupSorter() {
        }

        @Override
        public int compare(RuleFlowGroup group1, RuleFlowGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AgendaGroupSorter
    implements Comparator<AgendaGroup> {
        public static final AgendaGroupSorter instance = new AgendaGroupSorter();

        private AgendaGroupSorter() {
        }

        @Override
        public int compare(AgendaGroup group1, AgendaGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }
}

