/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public final class QueryTerminalNode
extends BaseNode
implements LeftTupleSinkNode,
TerminalNode {
    private static final long serialVersionUID = 510L;
    public static final short type = 8;
    private Query query;
    private GroupElement subrule;
    private int subruleIndex;
    private LeftTupleSource tupleSource;
    private Declaration[] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private long declaredMask;
    private long inferredMask;
    private long negativeMask;
    private int leftInputOtnId;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.query = (Query)rule;
        this.subrule = subrule;
        this.tupleSource = source;
        this.subruleIndex = subruleIndex;
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.query = (Query)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.declaredMask = in.readLong();
        this.inferredMask = in.readLong();
        this.negativeMask = in.readLong();
        this.leftInputOtnId = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.query);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.tupleSource);
        out.writeLong(this.declaredMask);
        out.writeLong(this.inferredMask);
        out.writeLong(this.negativeMask);
        out.writeLong(this.leftInputOtnId);
    }

    public void initDeclaredMask(BuildContext context) {
        RuleTerminalNode.doInitDeclaredMask(this, context);
    }

    public void initInferredMask() {
        RuleTerminalNode.doInitInferredMask(this);
    }

    public long getDeclaredMask() {
        return this.declaredMask;
    }

    public long getInferredMask() {
        return this.inferredMask;
    }

    public Rule getRule() {
        return this.query;
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowAdded(this.query, leftTuple, context, workingMemory);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowRemoved(this.query, leftTuple, context, workingMemory);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSource.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, this, this.getLeftInputOtnId(), this.inferredMask);
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowUpdated(this.query, leftTuple, context, workingMemory);
    }

    public String toString() {
        return "[QueryTerminalNode(" + this.getId() + "): query=" + this.query.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isInUse() {
        return false;
    }

    public void updateNewNode(InternalWorkingMemory workingMemory, PropagationContext context) {
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public GroupElement getSubrule() {
        return this.subrule;
    }

    public Declaration[] getDeclarations() {
        if (this.declarations == null) {
            this.declarations = new Declaration[this.query.getParameters().length];
            Map<String, Declaration> declMap = this.subrule.getOuterDeclarations();
            int i = 0;
            for (Declaration declr : this.query.getParameters()) {
                this.declarations[i++] = declMap.get(declr.getIdentifier());
            }
        }
        return this.declarations;
    }

    public int getSubruleIndex() {
        return this.subruleIndex;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public short getType() {
        return 8;
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public int getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(int leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? ((FromNode)this.tupleSource).getLeftTupleSource() : this.tupleSource;
    }

    public void setDeclaredMask(long mask) {
        this.declaredMask = mask;
    }

    public void setInferredMask(long mask) {
        this.inferredMask = mask;
    }

    public long getNegativeMask() {
        return this.negativeMask;
    }

    public void setNegativeMask(long mask) {
        this.negativeMask = mask;
    }
}

