/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Date;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemory;
import org.drools.runtime.Calendars;
import org.drools.spi.Activation;
import org.drools.time.Trigger;
import org.drools.time.impl.CronExpression;
import org.drools.time.impl.CronTrigger;
import org.drools.time.impl.Timer;

public class CronTimer
implements Timer,
Externalizable {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private CronExpression cronExpression;

    public CronTimer() {
    }

    public CronTimer(Date startTime, Date endTime, int repeatLimit, CronExpression cronExpression) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.cronExpression = cronExpression;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.cronExpression.getCronExpression());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
        this.repeatLimit = in.readInt();
        String string = (String)in.readObject();
        try {
            this.cronExpression = new CronExpression(string);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to marshal CronExpression '" + string + "'", e);
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public Trigger createTrigger(Activation item, WorkingMemory wm) {
        long timestamp = ((InternalWorkingMemory)wm).getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = ((InternalWorkingMemory)wm).getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new CronTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, this.cronExpression, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cronExpression.getCronExpression() == null ? 0 : this.cronExpression.getCronExpression().hashCode());
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CronTimer other = (CronTimer)obj;
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.cronExpression.getCronExpression() == null ? other.cronExpression.getCronExpression() != null : !this.cronExpression.getCronExpression().equals(other.cronExpression.getCronExpression())) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }
}

