/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import org.drools.time.impl.DefaultTimerJobFactoryManager;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.time.impl.TrackableTimeJobFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimerJobFactoryType {
    DEFUALT("default"){

        public TimerJobFactoryManager createInstance() {
            return DefaultTimerJobFactoryManager.instance;
        }
    }
    ,
    TRACKABLE("trackable"){

        public TimerJobFactoryManager createInstance() {
            return new TrackableTimeJobFactoryManager();
        }
    }
    ,
    JPA("jpa"){

        public TimerJobFactoryManager createInstance() {
            try {
                return (TimerJobFactoryManager)Class.forName("org.drools.persistence.jpa.JpaTimeJobFactoryManager").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    private final String string;

    public abstract TimerJobFactoryManager createInstance();

    private TimerJobFactoryType(String string2) {
        this.string = string2;
    }

    public String toExternalForm() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public String getId() {
        return this.string;
    }

    public static TimerJobFactoryType resolveTimerJobFactoryType(String id) {
        if (TRACKABLE.getId().equalsIgnoreCase(id)) {
            return TRACKABLE;
        }
        if (DEFUALT.getId().equalsIgnoreCase(id)) {
            return DEFUALT;
        }
        if (JPA.getId().equalsIgnoreCase(id)) {
            return JPA;
        }
        throw new IllegalArgumentException("Illegal enum value '" + id + "' for TimerJobFactoryType");
    }
}

