/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.common.InternalRuleBase;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.MethodAccessor;
import org.mvel2.optimizers.impl.refl.nodes.SetterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyInterceptor
implements Interceptor,
Externalizable {
    private static final long serialVersionUID = 510L;
    private long modificationMask = -1L;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.modificationMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.modificationMask);
    }

    public int doBefore(ASTNode node, VariableResolverFactory factory) {
        return 0;
    }

    public int doAfter(Object value, ASTNode node, VariableResolverFactory factory) {
        while (factory != null && !(factory instanceof MVELCompilationUnit.DroolsVarFactory)) {
            factory = factory.getNextFactory();
        }
        if (factory == null) {
            throw new RuntimeException("Unable to find DroolsMVELIndexedFactory");
        }
        KnowledgeHelper knowledgeHelper = ((MVELCompilationUnit.DroolsVarFactory)factory).getKnowledgeHelper();
        if (this.modificationMask < 0L) {
            this.calculateModificationMask(knowledgeHelper, (WithNode)node);
        }
        knowledgeHelper.update(value, this.modificationMask, value.getClass());
        return 0;
    }

    private void calculateModificationMask(KnowledgeHelper knowledgeHelper, WithNode node) {
        WithNode.ParmValuePair[] parmValuePairs;
        Class nodeClass = node.getEgressType();
        InternalRuleBase ruleBase = (InternalRuleBase)knowledgeHelper.getWorkingMemory().getRuleBase();
        TypeDeclaration typeDeclaration = ruleBase.getTypeDeclaration(nodeClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.modificationMask = Long.MAX_VALUE;
            return;
        }
        List<String> settableProperties = typeDeclaration.getSettableProperties();
        this.modificationMask = 0L;
        for (WithNode.ParmValuePair parmValuePair : parmValuePairs = (WithNode.ParmValuePair[])this.getFieldValue(WithNode.class, "withExpressions", node)) {
            List<String> modifiedProps;
            int pos;
            Method method = this.extractMethod(parmValuePair);
            if (method == null) {
                this.modificationMask = Long.MAX_VALUE;
                return;
            }
            String propertyName = ClassUtils.setter2property(method.getName());
            if (propertyName != null && (pos = settableProperties.indexOf(propertyName)) >= 0) {
                this.modificationMask = BitMaskUtil.set(this.modificationMask, pos);
            }
            if ((modifiedProps = typeDeclaration.getTypeClassDef().getModifiedPropsByMethod(method)) == null) continue;
            for (String modifiedProp : modifiedProps) {
                int pos2 = settableProperties.indexOf(modifiedProp);
                if (pos2 < 0) continue;
                this.modificationMask = BitMaskUtil.set(this.modificationMask, pos2);
            }
        }
    }

    private Method extractMethod(WithNode.ParmValuePair parmValuePair) {
        Serializable setExpression = parmValuePair.getSetExpression();
        if (setExpression != null) {
            SetterAccessor setterAccessor = (SetterAccessor)((CompiledAccExpression)setExpression).getAccessor();
            return setterAccessor.getMethod();
        }
        ExecutableAccessor accessor = (ExecutableAccessor)parmValuePair.getStatement();
        AccessorNode accessorNode = (AccessorNode)accessor.getNode().getAccessor();
        MethodAccessor methodAccessor = (MethodAccessor)accessorNode.getNextNode();
        return methodAccessor.getMethod();
    }

    private <T, V> V getFieldValue(Class<T> clazz, String fieldName, T object) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (V)f.get(object);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

