/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchySorter<K> {
    public List<K> sort(Map<K, Collection<K>> hierarchy) {
        Node<Object, Object> root = new Node<Object, Object>(null);
        HashMap map = new HashMap();
        for (K element : hierarchy.keySet()) {
            K key = element;
            Node<K, K> node = (Node<K, K>)map.get(key);
            if (node == null) {
                node = new Node<K, K>(key, element);
                map.put(key, node);
            } else if (node.getData() == null) {
                node.setData(element);
            }
            Collection<K> px = hierarchy.get(key);
            if (px.isEmpty()) {
                root.addChild(node);
                continue;
            }
            for (K parentElement : px) {
                K superKey = parentElement;
                Node<K, K> superNode = (Node<K, K>)map.get(superKey);
                if (superNode == null) {
                    superNode = new Node<K, K>(superKey);
                    map.put(superKey, superNode);
                }
                if (((Node)superNode).children.contains(node)) continue;
                superNode.addChild(node);
            }
        }
        for (Node n : map.values()) {
            if (n.getData() != null) continue;
            root.addChild(n);
        }
        LinkedList sortedList = new LinkedList();
        root.accept(sortedList);
        return sortedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K, T> {
        private K key;
        private T data;
        private List<Node<K, T>> children;

        public Node(K key) {
            this.key = key;
            this.children = new LinkedList<Node<K, T>>();
        }

        public Node(K key, T content) {
            this(key);
            this.data = content;
        }

        public void addChild(Node<K, T> child) {
            this.children.add(child);
        }

        public List<Node<K, T>> getChildren() {
            return this.children;
        }

        public K getKey() {
            return this.key;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T content) {
            this.data = content;
        }

        public void accept(List<T> list) {
            if (this.data != null) {
                if (list.contains(this.data)) {
                    list.remove(this.data);
                }
                list.add(this.data);
            }
            for (int j = 0; j < this.children.size(); ++j) {
                if (this.children.get(j) == this) continue;
                this.children.get(j).accept(list);
            }
        }

        public String toString() {
            return "Node{key='" + this.key + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.key.equals(node.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

