/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.DefaultFactHandle;
import org.kie.api.runtime.rule.EntryPoint;

public class EventFactHandle
extends DefaultFactHandle
implements Comparable<EventFactHandle> {
    private static final long serialVersionUID = 510L;
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private long activationsCount;
    private EventFactHandle linkedFactHandle;

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration, EntryPoint wmEntryPoint) {
        super(id, object, recency, wmEntryPoint);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    @Override
    public String toExternalForm() {
        return "5:" + super.getId() + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (super.getEntryPoint() != null ? super.getEntryPoint().getEntryPointId() : "null") + ":" + this.getObject();
    }

    @Override
    public String toString() {
        return this.toExternalForm();
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public boolean isExpired() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.isExpired();
        }
        return this.expired;
    }

    public void setExpired(boolean expired) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setExpired(expired);
        } else {
            this.expired = expired;
        }
    }

    public long getActivationsCount() {
        if (this.linkedFactHandle != null) {
            return this.linkedFactHandle.getActivationsCount();
        }
        return this.activationsCount;
    }

    public void setActivationsCount(long activationsCount) {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.setActivationsCount(activationsCount);
        } else {
            this.activationsCount = activationsCount;
        }
    }

    public void increaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.increaseActivationsCount();
        } else {
            ++this.activationsCount;
        }
    }

    public void decreaseActivationsCount() {
        if (this.linkedFactHandle != null) {
            this.linkedFactHandle.decreaseActivationsCount();
        } else {
            --this.activationsCount;
        }
    }

    @Override
    public EventFactHandle clone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPoint());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setExpired(this.isExpired());
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setFirstLeftTuple(this.getLastLeftTuple());
        clone.setLastLeftTuple(this.getLastLeftTuple());
        clone.setFirstRightTuple(this.getFirstRightTuple());
        clone.setLastRightTuple(this.getLastRightTuple());
        clone.setObjectHashCode(this.getObjectHashCode());
        return clone;
    }

    @Override
    public EventFactHandle quickClone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.getStartTimestamp(), this.getDuration(), this.getEntryPoint());
        clone.setActivationsCount(this.getActivationsCount());
        clone.setExpired(this.isExpired());
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setObjectHashCode(this.getObjectHashCode());
        return clone;
    }

    public EventFactHandle cloneAndLink() {
        EventFactHandle clone = this.quickClone();
        clone.linkedFactHandle = this;
        return clone;
    }

    @Override
    public int compareTo(EventFactHandle e) {
        return this.getStartTimestamp() < e.getStartTimestamp() ? -1 : (this.getStartTimestamp() == e.getStartTimestamp() ? 0 : 1);
    }
}

