/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.SingleLeftTupleSinkAdapter;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;

public abstract class LeftTupleSource
extends BaseNode
implements Externalizable {
    private long leftDeclaredMask;
    private long leftInferredMask;
    private long leftNegativeMask;
    protected LeftTupleSource leftInput;
    protected LeftTupleSinkPropagator sink;
    private transient ObjectTypeNode.Id leftInputOtnId;

    public LeftTupleSource() {
    }

    protected LeftTupleSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        super(id, partitionId, partitionsEnabled);
        this.sink = EmptyLeftTupleSinkAdapter.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (LeftTupleSinkPropagator)in.readObject();
        this.leftInput = (LeftTupleSource)in.readObject();
        this.leftDeclaredMask = in.readLong();
        this.leftInferredMask = in.readLong();
        this.leftNegativeMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeObject(this.leftInput);
        out.writeLong(this.leftDeclaredMask);
        out.writeLong(this.leftInferredMask);
        out.writeLong(this.leftNegativeMask);
    }

    @Override
    public abstract short getType();

    public abstract LeftTuple createPeer(LeftTuple var1);

    public void addTupleSink(LeftTupleSink tupleSink) {
        this.addTupleSink(tupleSink, null);
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    public void setLeftTupleSource(LeftTupleSource leftInput) {
        this.leftInput = leftInput;
    }

    public void addTupleSink(LeftTupleSink tupleSink, BuildContext context) {
        this.sink = this.addTupleSink(this.sink, tupleSink, context);
    }

    protected LeftTupleSinkPropagator addTupleSink(LeftTupleSinkPropagator sinkPropagator, LeftTupleSink tupleSink, BuildContext context) {
        if (sinkPropagator instanceof EmptyLeftTupleSinkAdapter) {
            return new SingleLeftTupleSinkAdapter(this.getPartitionId(), tupleSink);
        }
        if (sinkPropagator instanceof SingleLeftTupleSinkAdapter) {
            CompositeLeftTupleSinkAdapter sinkAdapter = new CompositeLeftTupleSinkAdapter(this.getPartitionId());
            sinkAdapter.addTupleSink(sinkPropagator.getSinks()[0]);
            sinkAdapter.addTupleSink(tupleSink);
            return sinkAdapter;
        }
        ((CompositeLeftTupleSinkAdapter)sinkPropagator).addTupleSink(tupleSink);
        return sinkPropagator;
    }

    public void removeTupleSink(LeftTupleSink tupleSink) {
        if (this.sink instanceof EmptyLeftTupleSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleLeftTupleSinkAdapter) {
            this.sink = EmptyLeftTupleSinkAdapter.getInstance();
        } else {
            CompositeLeftTupleSinkAdapter sinkAdapter = (CompositeLeftTupleSinkAdapter)this.sink;
            sinkAdapter.removeTupleSink(tupleSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleLeftTupleSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public LeftTupleSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public abstract void updateSink(LeftTupleSink var1, PropagationContext var2, InternalWorkingMemory var3);

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    protected final void initMasks(BuildContext context, LeftTupleSource leftInput) {
        this.initDeclaredMask(context, leftInput);
        this.initInferredMask(leftInput);
    }

    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        ObjectType objectType;
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.leftDeclaredMask = -1L;
            return;
        }
        if (leftInput.getType() != 120) {
            this.leftDeclaredMask = -1L;
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[1];
        ObjectType objectType2 = objectType = pattern == null || this.getType() == 211 ? ((LeftInputAdapterNode)leftInput).getParentObjectSource().getObjectTypeNode().getObjectType() : pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.leftDeclaredMask = -1L;
            return;
        }
        Class<?> objectClass = ((ClassWireable)((Object)objectType)).getClassType();
        if (PropertySpecificUtil.isPropertyReactive(context, objectClass)) {
            if (pattern != null) {
                List<String> leftListenedProperties = pattern.getListenedProperties();
                List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
                this.leftDeclaredMask = PropertySpecificUtil.calculatePositiveMask(leftListenedProperties, settableProperties);
                this.leftNegativeMask = PropertySpecificUtil.calculateNegativeMask(leftListenedProperties, settableProperties);
                this.setLeftListenedProperties(leftListenedProperties);
            }
        } else {
            this.leftDeclaredMask = -1L;
        }
    }

    protected void setLeftListenedProperties(List<String> leftListenedProperties) {
    }

    protected void initInferredMask(LeftTupleSource leftInput) {
        LeftTupleSource unwrappedLeft = this.unwrapLeftInput(leftInput);
        if (unwrappedLeft.getType() == 120 && ((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource().getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)unwrappedLeft).getParentObjectSource();
            this.leftInferredMask = alphaNode.updateMask(this.leftDeclaredMask);
        } else {
            this.leftInferredMask = this.leftDeclaredMask;
        }
        this.leftInferredMask &= -1L - this.leftNegativeMask;
    }

    private LeftTupleSource unwrapLeftInput(LeftTupleSource leftInput) {
        if (leftInput.getType() == 151) {
            return ((FromNode)leftInput).getLeftTupleSource();
        }
        return leftInput;
    }

    public long getLeftDeclaredMask() {
        return this.leftDeclaredMask;
    }

    public long getLeftInferredMask() {
        return this.leftInferredMask;
    }

    protected void setLeftInferredMask(long leftInferredMask) {
        this.leftInferredMask = leftInferredMask;
    }

    public long getLeftNegativeMask() {
        return this.leftNegativeMask;
    }

    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    protected abstract ObjectTypeNode getObjectTypeNode();

    public ObjectType getObjectType() {
        ObjectTypeNode objectTypeNode = this.getObjectTypeNode();
        return objectTypeNode != null ? objectTypeNode.getObjectType() : null;
    }

    public abstract boolean isLeftTupleMemoryEnabled();
}

