/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;

public class ModifyPreviousTuples {
    private LeftTuple leftTuple;
    private RightTuple rightTuple;
    private EntryPointNode epNode;

    public ModifyPreviousTuples(LeftTuple leftTuple, RightTuple rightTuple, EntryPointNode epNode) {
        this.leftTuple = leftTuple;
        this.rightTuple = rightTuple;
        this.epNode = epNode;
    }

    public LeftTuple peekLeftTuple() {
        return this.leftTuple;
    }

    public RightTuple peekRightTuple() {
        return this.rightTuple;
    }

    public void removeLeftTuple() {
        LeftTuple current = this.leftTuple;
        current.setLeftParentPrevious(null);
        this.leftTuple = current.getLeftParentNext();
        current.setLeftParentNext(null);
    }

    public void removeRightTuple() {
        RightTuple current = this.rightTuple;
        current.setHandlePrevious(null);
        this.rightTuple = current.getHandleNext();
        current.setHandleNext(null);
    }

    public void retractTuples(PropagationContext pctx, InternalWorkingMemory wm) {
        Entry current;
        if (this.leftTuple != null) {
            for (current = this.leftTuple; current != null; current = current.getLeftParentNext()) {
                this.epNode.doDeleteObject(pctx, wm, (LeftTuple)current);
            }
        }
        if (this.rightTuple != null) {
            for (current = this.rightTuple; current != null; current = ((RightTuple)current).getHandleNext()) {
                this.epNode.doRightDelete(pctx, wm, (RightTuple)current);
            }
        }
    }
}

