/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;

public class RightTupleList
implements RightTupleMemory,
Entry {
    private static final long serialVersionUID = 510L;
    public Entry previous;
    public Entry next;
    public RightTuple first;
    public RightTuple last;
    private int hashCode;
    private AbstractHashTable.Index index;
    private TupleHashTableIterator iterator;
    private int size;

    public RightTupleList() {
        this.hashCode = 0;
        this.index = null;
    }

    public RightTupleList(AbstractHashTable.Index index, int hashCode) {
        this.index = index;
        this.hashCode = hashCode;
    }

    public RightTupleList(AbstractHashTable.Index index, int hashCode, Entry next) {
        this.index = index;
        this.hashCode = hashCode;
        this.next = next;
    }

    public RightTupleList(RightTupleList p, Entry next) {
        this.index = p.index;
        this.hashCode = p.hashCode;
        this.next = next;
        this.first = p.first;
        this.last = p.last;
    }

    @Override
    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle, FastIterator rightTupleIterator) {
        return this.first;
    }

    public RightTuple getFirst() {
        return this.first;
    }

    public RightTuple getLast() {
        return this.last;
    }

    @Override
    public void removeAdd(RightTuple rightTuple) {
        this.remove(rightTuple);
        this.add(rightTuple);
    }

    public void split(RightTuple rightTuple, int count) {
        this.first = rightTuple;
        rightTuple.setPrevious(null);
        this.size -= count;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    @Override
    public void add(RightTuple rightTuple) {
        if (this.last != null) {
            this.last.setNext(rightTuple);
            rightTuple.setPrevious(this.last);
            this.last = rightTuple;
        } else {
            this.first = rightTuple;
            this.last = rightTuple;
        }
        rightTuple.setMemory(this);
        ++this.size;
    }

    public void insertAfter(RightTuple rightTuple, RightTuple previous) {
        RightTuple next = (RightTuple)previous.getNext();
        previous.setNext(rightTuple);
        rightTuple.setPrevious(previous);
        if (next != null) {
            next.setPrevious(rightTuple);
            rightTuple.setNext(next);
        } else {
            this.last = rightTuple;
        }
        rightTuple.setMemory(this);
    }

    public void insertBefore(RightTuple rightTuple, RightTuple next) {
        RightTuple previous = (RightTuple)next.getPrevious();
        next.setPrevious(rightTuple);
        rightTuple.setNext(next);
        if (previous != null) {
            previous.setNext(rightTuple);
            rightTuple.setPrevious(previous);
        } else {
            this.first = rightTuple;
        }
        rightTuple.setMemory(this);
    }

    @Override
    public void remove(RightTuple rightTuple) {
        RightTuple previous = (RightTuple)rightTuple.getPrevious();
        RightTuple next = (RightTuple)rightTuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first = next;
            next.setPrevious(null);
        } else if (previous != null) {
            this.last = previous;
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
        rightTuple.clear();
        --this.size;
    }

    public RightTuple get(InternalFactHandle handle) {
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(InternalFactHandle handle) {
        return this.get(handle) != null;
    }

    public RightTuple get(RightTuple rightTuple) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    @Override
    public boolean contains(RightTuple rightTuple) {
        return this.get(rightTuple) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public FastIterator fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator fullFastIterator(RightTuple rightTuple) {
        return LinkedList.fastIterator;
    }

    @Override
    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new TupleHashTableIterator();
        }
        this.iterator.reset(this.first);
        return this.iterator;
    }

    public boolean matches(Object object, int objectHashCode) {
        return this.hashCode == objectHashCode && this.index.equal(this.first.getFactHandle().getObject(), object);
    }

    public boolean matches(LeftTuple tuple, int tupleHashCode, InternalFactHandle factHandle) {
        RightTuple rightTuple;
        if (this.hashCode != tupleHashCode) {
            return false;
        }
        if (this.first.getFactHandle() == factHandle && (rightTuple = (RightTuple)this.first.getNext()) != null) {
            return this.index.equal(rightTuple.getFactHandle().getObject(), tuple);
        }
        return this.index.equal(this.first.getFactHandle().getObject(), tuple);
    }

    public RightTuple[] toArray() {
        RightTuple[] tuples = new RightTuple[this.size];
        RightTuple current = this.first;
        for (int i = 0; i < this.size; ++i) {
            tuples[i] = current;
            current = (RightTuple)current.getNext();
        }
        return tuples;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        RightTupleList other = (RightTupleList)object;
        return this.hashCode == other.hashCode && this.index == other.index;
    }

    public Entry getNext() {
        return this.next;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    @Override
    public boolean isIndexed() {
        return this.index != null;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (RightTuple rightTuple = this.first; rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            builder.append(rightTuple);
        }
        return builder.toString();
    }

    @Override
    public RightTupleMemory.IndexType getIndexType() {
        return RightTupleMemory.IndexType.NONE;
    }

    protected void copyStateInto(RightTupleList other) {
        other.previous = this.previous;
        other.next = this.next;
        other.first = this.first;
        other.last = this.last;
        other.hashCode = this.hashCode;
        other.index = this.index;
        other.iterator = this.iterator;
        other.size = this.size;
    }

    public static class TupleHashTableIterator
    implements Iterator {
        private RightTuple current;

        public void reset(RightTuple first) {
            this.current = first;
        }

        public Object next() {
            if (this.current != null) {
                RightTuple returnValue = this.current;
                this.current = (RightTuple)this.current.getNext();
                return returnValue;
            }
            return null;
        }

        public void remove() {
        }
    }
}

