/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.impl.FixedKnowledgeCommandContext;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.WorkingMemoryFactory;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.agent.KnowledgeAgent;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class StatelessKnowledgeSessionImpl
extends AbstractRuntime
implements StatelessKnowledgeSession,
StatelessKieSession {
    private InternalKnowledgeBase kBase;
    private KnowledgeAgent kagent;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    public Set<RuleRuntimeEventListener> cachedRuleRuntimeListeners;
    public Set<AgendaEventListener> cachedAgendaListeners;
    public Set<ProcessEventListener> cachedProcessEventListener;
    private AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    private RuleRuntimeEventSupport ruleRuntimeEventSupport = new RuleRuntimeEventSupport();
    private ProcessEventSupport processEventSupport = new ProcessEventSupport();
    private KieSessionConfiguration conf;
    private Environment environment;
    private WorkingMemoryFactory wmFactory;

    public StatelessKnowledgeSessionImpl() {
    }

    public StatelessKnowledgeSessionImpl(InternalKnowledgeBase kBase, KnowledgeAgent kagent, KieSessionConfiguration conf) {
        this.kBase = kBase;
        this.kagent = kagent;
        this.conf = conf != null ? conf : SessionConfigurationImpl.getDefaultInstance();
        this.environment = EnvironmentFactory.newEnvironment();
        this.wmFactory = kBase.getConfiguration().getComponentFactory().getWorkingMemoryFactory();
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        if (this.kagent != null) {
            this.kBase = (InternalKnowledgeBase)this.kagent.getKnowledgeBase();
        }
        return this.kBase;
    }

    public KnowledgeAgent getKnowledgeAgent() {
        return this.kagent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSession newWorkingMemory() {
        if (this.kagent != null) {
            this.kBase = (InternalKnowledgeBase)this.kagent.getKnowledgeBase();
        }
        this.kBase.readLock();
        try {
            StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.wmFactory.createWorkingMemory(this.kBase.nextWorkingMemoryCounter(), this.kBase, (SessionConfiguration)this.conf, this.environment);
            StatefulKnowledgeSessionImpl ksessionImpl = (StatefulKnowledgeSessionImpl)ksession;
            ((Globals)ksessionImpl.getGlobalResolver()).setDelegate((Globals)this.sessionGlobals);
            this.registerSystemListeners(ksessionImpl);
            this.registerCustomListeners();
            ksessionImpl.setAgendaEventSupport(this.agendaEventSupport);
            ksessionImpl.setRuleRuntimeEventSupport(this.ruleRuntimeEventSupport);
            InternalProcessRuntime processRuntime = ksessionImpl.internalGetProcessRuntime();
            if (processRuntime != null) {
                processRuntime.setProcessEventSupport(this.processEventSupport);
            }
            for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
                ksession.registerChannel(entry.getKey(), entry.getValue());
            }
            StatefulKnowledgeSession statefulKnowledgeSession = ksession;
            return statefulKnowledgeSession;
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    private void registerSystemListeners(StatefulKnowledgeSessionImpl wm) {
        for (AgendaEventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
            this.agendaEventSupport.addEventListener(listener);
        }
        for (AgendaEventListener listener : wm.getRuleRuntimeEventSupport().getEventListeners()) {
            this.ruleRuntimeEventSupport.addEventListener(listener);
        }
        InternalProcessRuntime processRuntime = wm.internalGetProcessRuntime();
        if (processRuntime != null) {
            for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                this.processEventSupport.addEventListener(listener);
            }
        }
    }

    private void registerCustomListeners() {
        if (this.cachedAgendaListeners != null) {
            for (AgendaEventListener agendaListener : this.cachedAgendaListeners) {
                this.agendaEventSupport.addEventListener(agendaListener);
            }
        }
        if (this.cachedRuleRuntimeListeners != null) {
            for (RuleRuntimeEventListener wmListener : this.cachedRuleRuntimeListeners) {
                this.ruleRuntimeEventSupport.addEventListener(wmListener);
            }
        }
        if (this.cachedProcessEventListener != null) {
            for (ProcessEventListener processListener : this.cachedProcessEventListener) {
                this.processEventSupport.addEventListener(processListener);
            }
        }
    }

    public void addEventListener(AgendaEventListener listener) {
        this.registerAgendaEventListener(listener);
    }

    private void registerAgendaEventListener(AgendaEventListener listener) {
        if (this.cachedAgendaListeners == null) {
            this.cachedAgendaListeners = new HashSet<AgendaEventListener>();
        }
        this.cachedAgendaListeners.add(listener);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.cachedAgendaListeners != null ? Collections.unmodifiableCollection(this.cachedAgendaListeners) : Collections.emptySet();
    }

    public void removeEventListener(AgendaEventListener listener) {
        if (this.cachedAgendaListeners != null) {
            this.cachedAgendaListeners.remove(listener);
            this.agendaEventSupport.removeEventListener(listener);
        }
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        this.registerRuleRuntimeEventListener(listener);
    }

    private void registerRuleRuntimeEventListener(RuleRuntimeEventListener listener) {
        if (this.cachedRuleRuntimeListeners == null) {
            this.cachedRuleRuntimeListeners = new HashSet<RuleRuntimeEventListener>();
        }
        this.cachedRuleRuntimeListeners.add(listener);
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        if (this.cachedRuleRuntimeListeners != null) {
            this.ruleRuntimeEventSupport.removeEventListener(listener);
        }
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        if (this.cachedRuleRuntimeListeners == null) {
            this.cachedRuleRuntimeListeners = new HashSet<RuleRuntimeEventListener>();
        }
        return Collections.unmodifiableCollection(this.cachedRuleRuntimeListeners);
    }

    public void addEventListener(ProcessEventListener listener) {
        if (this.cachedProcessEventListener == null) {
            this.cachedProcessEventListener = new HashSet<ProcessEventListener>();
        }
        this.cachedProcessEventListener.add(listener);
        this.processEventSupport.addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return Collections.unmodifiableCollection(this.cachedProcessEventListener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        if (this.cachedProcessEventListener != null) {
            this.cachedProcessEventListener.remove(listener);
        }
        this.processEventSupport.removeEventListener(listener);
    }

    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public KieBase getKieBase() {
        return this.getKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        FixedKnowledgeCommandContext context = new FixedKnowledgeCommandContext(new ContextImpl("ksession", null), null, null, (KieSession)ksession, new ExecutionResultImpl());
        try {
            ((StatefulKnowledgeSessionImpl)ksession).startBatchExecution(new ExecutionResultImpl());
            Object o = ((GenericCommand)command).execute(context);
            boolean autoFireAllRules = true;
            if (command instanceof FireAllRulesCommand) {
                autoFireAllRules = false;
            } else if (command instanceof BatchExecutionCommandImpl) {
                for (Command executionResultImpl : ((BatchExecutionCommandImpl)command).getCommands()) {
                    if (!(executionResultImpl instanceof FireAllRulesCommand)) continue;
                    autoFireAllRules = false;
                    break;
                }
            }
            if (autoFireAllRules) {
                ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommandImpl) {
                ExecutionResultImpl result;
                ExecutionResultImpl executionResultImpl = result = ((StatefulKnowledgeSessionImpl)ksession).getExecutionResult();
                return (T)executionResultImpl;
            }
            Object t = o;
            return t;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)ksession).endBatchExecution();
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            ksession.insert(object);
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Iterable objects) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeWithResults(Iterable objects, ObjectFilter filter) {
        ArrayList<Object> list = new ArrayList<Object>();
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
            for (FactHandle fh : ksession.getFactHandles(filter)) {
                list.add(((InternalFactHandle)fh).getObject());
            }
        }
        finally {
            this.dispose(ksession);
        }
        return list;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected void dispose(StatefulKnowledgeSession ksession) {
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)ksession;
        for (AgendaEventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
            this.agendaEventSupport.removeEventListener(listener);
        }
        for (AgendaEventListener listener : wm.getRuleRuntimeEventSupport().getEventListeners()) {
            this.ruleRuntimeEventSupport.removeEventListener(listener);
        }
        InternalProcessRuntime processRuntime = wm.internalGetProcessRuntime();
        if (processRuntime != null) {
            for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                this.processEventSupport.removeEventListener(listener);
            }
        }
        ksession.dispose();
    }
}

