/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.PropagationContext;

public class QueryTerminalNode
extends AbstractTerminalNode
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    public static final short type = 8;
    protected QueryImpl query;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] allDeclarations;
    private Declaration[] requiredDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private transient ObjectTypeNode.Id leftInputOtnId;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, RuleImpl rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), source);
        this.query = (QueryImpl)rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.initDeclaredMask(context);
        this.initInferredMask();
        this.initDeclarations();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.query = (QueryImpl)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.initDeclarations();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.query);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
    }

    public QueryImpl getQuery() {
        return this.query;
    }

    @Override
    public RuleImpl getRule() {
        return this.query;
    }

    @Override
    public String toString() {
        return "[QueryTerminalNode(" + this.getId() + "): query=" + this.query.getName() + "]";
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    @Override
    public boolean isFireDirect() {
        return false;
    }

    @Override
    public Declaration[] getAllDeclarations() {
        return this.allDeclarations;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    private void initDeclarations() {
        Map<String, Declaration> declMap = this.subrule.getOuterDeclarations();
        this.allDeclarations = declMap.values().toArray(new Declaration[declMap.size()]);
        this.requiredDeclarations = new Declaration[this.query.getParameters().length];
        int i = 0;
        for (Declaration declr : this.query.getParameters()) {
            this.requiredDeclarations[i++] = declMap.get(declr.getIdentifier());
        }
    }

    public int getSubruleIndex() {
        return this.subruleIndex;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public short getType() {
        return 91;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new RuleTerminalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public Declaration[] getSalienceDeclarations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Declaration[][] getTimerDeclarations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
    }
}

