/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PredicateExpression;
import org.drools.core.spi.Restriction;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class PredicateConstraint
extends MutableTypeConstraint
implements Restriction,
Wireable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private PredicateExpression expression;
    private Declaration[] requiredDeclarations;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] requiredGlobals;
    private String[] requiredOperators;
    private List<PredicateConstraint> cloned = Collections.emptyList();
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final String[] EMPTY_STRINGS = new String[0];

    public PredicateConstraint() {
        this(null);
    }

    public PredicateConstraint(PredicateExpression evaluator) {
        this(evaluator, null, null, null, null);
    }

    public PredicateConstraint(Declaration[] previousDeclarations, Declaration[] localDeclarations) {
        this(null, previousDeclarations, localDeclarations, null, null);
    }

    public PredicateConstraint(PredicateExpression expression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, String[] requiredOperators) {
        this.expression = expression;
        this.previousDeclarations = previousDeclarations == null ? EMPTY_DECLARATIONS : previousDeclarations;
        this.localDeclarations = localDeclarations == null ? EMPTY_DECLARATIONS : localDeclarations;
        this.requiredGlobals = requiredGlobals == null ? EMPTY_STRINGS : requiredGlobals;
        this.requiredOperators = requiredOperators == null ? EMPTY_STRINGS : requiredOperators;
        this.requiredDeclarations = new Declaration[this.previousDeclarations.length + this.localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.expression = (PredicateExpression)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.requiredGlobals = (String[])in.readObject();
        this.requiredOperators = (String[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.requiredGlobals);
        out.writeObject(this.requiredOperators);
        out.writeObject(this.cloned);
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getGlobals() {
        return this.requiredGlobals;
    }

    public String[] getOperators() {
        return this.requiredOperators;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i;
        for (i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(oldDecl)) continue;
            this.requiredDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.previousDeclarations.length; ++i) {
            if (!this.previousDeclarations[i].equals(oldDecl)) continue;
            this.previousDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.localDeclarations.length; ++i) {
            if (!this.localDeclarations[i].equals(oldDecl)) continue;
            this.localDeclarations[i] = newDecl;
        }
    }

    @Override
    public void wire(Object object) {
        this.setPredicateExpression(KiePolicyHelper.isPolicyEnabled() ? new SafePredicateExpression((PredicateExpression)object) : (PredicateExpression)object);
        for (PredicateConstraint clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setPredicateExpression(PredicateExpression expression) {
        this.expression = expression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    public String toString() {
        return "[PredicateConstraint previousDeclarations=" + Arrays.toString(this.previousDeclarations) + " localDeclarations=" + Arrays.toString(this.localDeclarations) + "]";
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    public boolean equals(Object object) {
        int i;
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PredicateConstraint.class) {
            return false;
        }
        PredicateConstraint other = (PredicateConstraint)object;
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        if (this.requiredOperators.length != other.requiredOperators.length) {
            return false;
        }
        int length = this.previousDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.previousDeclarations[i].getPattern().getOffset() != other.previousDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.previousDeclarations[i].getExtractor().equals(other.previousDeclarations[i].getExtractor())) continue;
            return false;
        }
        length = this.localDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.localDeclarations[i].getPattern().getOffset() != other.localDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.localDeclarations[i].getExtractor().equals(other.localDeclarations[i].getExtractor())) continue;
            return false;
        }
        if (!Arrays.equals(this.requiredGlobals, other.requiredGlobals)) {
            return false;
        }
        if (!Arrays.equals(this.requiredOperators, other.requiredOperators)) {
            return false;
        }
        return this.expression.equals(other.expression);
    }

    @Override
    public ContextEntry createContextEntry() {
        PredicateContextEntry ctx = new PredicateContextEntry();
        ctx.dialectContext = this.expression.createContext();
        return ctx;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(handle, null, this.previousDeclarations, this.localDeclarations, workingMemory, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public boolean isAllowed(InternalReadAccessor extractor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        throw new UnsupportedOperationException("Method not supported. Please contact development team.");
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(handle, ctx.tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(ctx.rightHandle, tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public PredicateConstraint clone() {
        Declaration[] previous = new Declaration[this.previousDeclarations.length];
        for (int i = 0; i < previous.length; ++i) {
            previous[i] = this.previousDeclarations[i].clone();
        }
        Declaration[] local = new Declaration[this.localDeclarations.length];
        for (int i = 0; i < local.length; ++i) {
            local[i] = this.localDeclarations[i].clone();
        }
        PredicateConstraint clone = new PredicateConstraint(this.expression, previous, local, this.requiredGlobals, this.requiredOperators);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<PredicateConstraint>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    @Override
    public Evaluator getEvaluator() {
        return null;
    }

    public static class SafePredicateExpression
    implements PredicateExpression,
    Serializable {
        private static final long serialVersionUID = -4570820770000524010L;
        private PredicateExpression delegate;

        public SafePredicateExpression(PredicateExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return SafePredicateExpression.this.delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean evaluate(final InternalFactHandle handle, final Tuple tuple, final Declaration[] previousDeclarations, final Declaration[] localDeclarations, final WorkingMemory workingMemory, final Object context) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return SafePredicateExpression.this.delegate.evaluate(handle, tuple, previousDeclarations, localDeclarations, workingMemory, context);
                }
            }, KiePolicyHelper.getAccessContext());
        }
    }

    public static class PredicateContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public Tuple tuple;
        public InternalFactHandle rightHandle;
        public InternalWorkingMemory workingMemory;
        public Object dialectContext;
        private ContextEntry entry;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tuple = (LeftTuple)in.readObject();
            this.rightHandle = (InternalFactHandle)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.dialectContext = in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tuple);
            out.writeObject(this.rightHandle);
            out.writeObject(this.workingMemory);
            out.writeObject(this.dialectContext);
            out.writeObject(this.entry);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightHandle = handle;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, Tuple tuple) {
            this.workingMemory = workingMemory;
            this.tuple = tuple;
        }

        @Override
        public void resetTuple() {
            this.tuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.rightHandle = null;
        }
    }
}

