/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.NumberUtils;
import org.kie.api.runtime.Calendars;

public class DurationTimer
extends BaseTimer
implements Timer,
Externalizable {
    private long duration;
    private Declaration eventFactHandle;

    public DurationTimer() {
    }

    public DurationTimer(long duration) {
        this.duration = duration;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.duration);
        out.writeObject(this.eventFactHandle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.duration = in.readLong();
        this.eventFactHandle = (Declaration)in.readObject();
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{{this.getEventFactHandleDeclaration()}, null};
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp;
        if (this.eventFactHandle != null) {
            Tuple leftTuple = item.getTuple();
            EventFactHandle fh = (EventFactHandle)leftTuple.get(this.eventFactHandle);
            timestamp = fh.getStartTimestamp();
        } else {
            timestamp = wm.getTimerService().getCurrentTime();
        }
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, Tuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        return this.createTrigger(this.getEventTimestamp(leftTuple, timestamp), calendarNames, calendars);
    }

    long getEventTimestamp(Tuple leftTuple, long timestamp) {
        return this.eventFactHandle != null ? ((EventFactHandle)leftTuple.get(this.eventFactHandle)).getStartTimestamp() : timestamp;
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        long offset = timestamp + this.duration;
        if (NumberUtils.isAddOverflow(timestamp, this.duration, offset)) {
            return new PointInTimeTrigger(timestamp, calendarNames, calendars);
        }
        return new PointInTimeTrigger(offset, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DurationTimer other = (DurationTimer)obj;
        return this.duration == other.duration;
    }

    @Override
    public ConditionalElement clone() {
        return new DurationTimer(this.duration);
    }

    public String toString() {
        return "DurationTimer: " + this.duration + "ms";
    }

    public void setEventFactHandle(Declaration eventFactHandle) {
        this.eventFactHandle = eventFactHandle;
    }

    public Declaration getEventFactHandleDeclaration() {
        return this.eventFactHandle;
    }
}

