/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.world.impl.ContextManagerImpl;
import org.kie.api.runtime.Context;
import org.kie.internal.command.ContextManager;

public class ContextImpl
implements RegistryContext {
    public static final String REGISTRY = "__REGISTRY__";
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private final ContextManager manager;
    private final String name;
    private final Context delegate;

    public ContextImpl() {
        this(UUID.randomUUID().toString(), new ContextManagerImpl());
    }

    public ContextImpl(String name, ContextManager manager) {
        this(name, manager, null);
    }

    public ContextImpl(String name, ContextManager manager, Context delegate) {
        this.name = name;
        this.manager = manager;
        this.delegate = delegate;
        this.set(REGISTRY, new HashMap());
    }

    public Object get(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return null;
        }
        Object object = null;
        if (this.map.containsKey(identifier)) {
            object = this.map.get(identifier);
        } else if (this.delegate != null) {
            object = this.delegate.get(identifier);
        }
        return object;
    }

    public void set(String identifier, Object value) {
        this.map.put(identifier, value);
    }

    public void remove(String identifier) {
        this.map.remove(identifier);
    }

    public boolean has(String identifier) {
        return this.map.containsKey(identifier);
    }

    @Override
    public ContextManager getContextManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ContextImpl{name='" + this.name + '\'' + '}';
    }

    @Override
    public <T> ContextImpl register(Class<T> clazz, T instance) {
        ((Map)this.get(REGISTRY)).put(clazz.getName(), instance);
        return this;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        return (T)((Map)this.get(REGISTRY)).get(clazz.getName());
    }
}

