/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.InitialFact;
import org.drools.core.QueryResultsImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.base.StandardQueryViewChangedEventListener;
import org.drools.core.common.BaseNode;
import org.drools.core.common.CompositeDefaultAgenda;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EndOperationListener;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.InternalRuleUnitExecutor;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.rule.impl.LiveQueryImpl;
import org.drools.core.runtime.rule.impl.OpenQueryViewChangedEventListenerAdapter;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AsyncExceptionHandler;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.TupleList;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessEventManager;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.internal.runtime.KieRuntimeService;
import org.kie.api.internal.runtime.KieRuntimes;
import org.kie.api.internal.runtime.beliefs.Mode;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class StatefulKnowledgeSessionImpl
extends AbstractRuntime
implements StatefulKnowledgeSession,
WorkingMemoryEntryPoint,
InternalKnowledgeRuntime,
KieSession,
KieRuntimeEventManager,
InternalWorkingMemoryActions,
EventSupport,
RuleEventManager,
ProcessEventManager,
CorrelationAwareProcessRuntime,
Externalizable {
    public static final String ERRORMSG = "Illegal method call. This session was previously disposed.";
    public static final String DEFAULT_RULE_UNIT = "DEFAULT_RULE_UNIT";
    private static final long serialVersionUID = 510L;
    public byte[] bytes;
    protected Long id;
    protected NodeMemories nodeMemories;
    protected InternalWorkingMemoryEntryPoint defaultEntryPoint;
    protected GlobalResolver globalResolver;
    protected Calendars calendars;
    protected RuleRuntimeEventSupport ruleRuntimeEventSupport;
    protected RuleEventListenerSupport ruleEventListenerSupport;
    protected AgendaEventSupport agendaEventSupport;
    protected List<KieBaseEventListener> kieBaseEventListeners;
    protected transient InternalKnowledgeBase kBase;
    protected FactHandleFactory handleFactory;
    protected InternalAgenda agenda;
    protected ReentrantLock lock;
    protected AtomicLong propagationIdCounter;
    private boolean sequential;
    private WorkItemManager workItemManager;
    private TimerService timerService;
    protected Map<String, WorkingMemoryEntryPoint> entryPoints = new ConcurrentHashMap<String, WorkingMemoryEntryPoint>();
    protected InternalFactHandle initialFactHandle;
    protected PropagationContextFactory pctxFactory;
    protected SessionConfiguration config;
    private Map<String, Channel> channels;
    private Environment environment;
    private AtomicLong opCounter;
    private AtomicLong lastIdleTimestamp;
    private InternalProcessRuntime processRuntime;
    private Map<String, Object> runtimeServices;
    private boolean alive = true;
    private AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private DroolsManagementAgent.CBSKey mbeanRegisteredCBSKey;
    protected transient InternalRuleUnitExecutor ruleUnitExecutor;
    private EndOperationListener endOperationListener;
    public static final DummyInternalProcessRuntime DUMMY_PROCESS_RUNTIME = new DummyInternalProcessRuntime();

    public StatefulKnowledgeSessionImpl() {
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase) {
        this(id, kBase, true, kBase.getSessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        this(id, kBase, kBase != null ? kBase.newFactHandleFactory() : null, initInitFactHandle, 1L, config, environment, new RuleRuntimeEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), null);
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        this(id, kBase, handleFactory, false, propagationContext, config, environment, new RuleRuntimeEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), agenda);
    }

    private StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, boolean initInitFactHandle, long propagationContext, SessionConfiguration config, Environment environment, RuleRuntimeEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport, RuleEventListenerSupport ruleEventListenerSupport, InternalAgenda agenda) {
        this.id = id;
        this.handleFactory = handleFactory;
        this.ruleRuntimeEventSupport = workingMemoryEventSupport;
        this.agendaEventSupport = agendaEventSupport;
        this.ruleEventListenerSupport = ruleEventListenerSupport;
        this.propagationIdCounter = new AtomicLong(propagationContext);
        this.init(config, environment, propagationContext);
        if (kBase != null) {
            this.bindRuleBase(kBase, agenda, initInitFactHandle);
        }
    }

    protected void init(SessionConfiguration config, Environment environment) {
        this.init(config, environment, 1L);
    }

    private void init(SessionConfiguration config, Environment environment, long propagationContext) {
        this.config = config;
        this.environment = environment;
        this.propagationIdCounter = new AtomicLong(propagationContext);
        Globals globals = (Globals)this.environment.get("org.kie.Globals");
        this.globalResolver = globals != null ? (!(globals instanceof GlobalResolver) ? new GlobalsAdapter(globals) : (GlobalResolver)globals) : new MapGlobalResolver();
        this.kieBaseEventListeners = new LinkedList<KieBaseEventListener>();
        this.lock = new ReentrantLock();
        this.timerService = TimerServiceFactory.getTimerService(this.config);
        this.opCounter = new AtomicLong(0L);
        this.lastIdleTimestamp = new AtomicLong(-1L);
    }

    public void initMBeans(String containerId, String kbaseName, String ksessionName) {
        if (this.kBase.getConfiguration() != null && this.kBase.getConfiguration().isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            this.mbeanRegisteredCBSKey = new DroolsManagementAgent.CBSKey(containerId, kbaseName, ksessionName);
            DroolsManagementAgent.getInstance().registerKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, this);
        }
    }

    protected void bindRuleBase(InternalKnowledgeBase kBase, InternalAgenda agenda, boolean initInitFactHandle) {
        this.kBase = kBase;
        this.nodeMemories = new ConcurrentNodeMemories(kBase, DEFAULT_RULE_UNIT);
        this.pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.agenda = agenda == null ? kBase.getConfiguration().getComponentFactory().getAgendaFactory().createAgenda(kBase) : agenda;
        this.agenda.setWorkingMemory(this);
        RuleBaseConfiguration conf = kBase.getConfiguration();
        this.sequential = conf.isSequential();
        this.initDefaultEntryPoint();
        this.updateEntryPointsCache();
        if (initInitFactHandle) {
            this.initialFactHandle = this.initInitialFact(kBase, null);
        }
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.defaultEntryPoint.getTruthMaintenanceSystem();
    }

    @Override
    public FactHandleFactory getHandleFactory() {
        return this.handleFactory;
    }

    public <T> T getKieRuntime(Class<T> cls) {
        Object runtime;
        if (this.runtimeServices == null) {
            runtime = this.createRuntimeService(cls);
        } else {
            runtime = this.runtimeServices.get(cls.getName());
            if (runtime == null) {
                runtime = this.createRuntimeService(cls);
            }
        }
        return runtime;
    }

    public synchronized <T> T createRuntimeService(Class<T> cls) {
        Object runtime;
        if (this.runtimeServices == null) {
            this.runtimeServices = new HashMap<String, Object>();
        }
        if ((runtime = this.runtimeServices.get(cls.getName())) == null) {
            KieRuntimes runtimes = (KieRuntimes)ServiceRegistry.getInstance().get(KieRuntimes.class);
            KieRuntimeService service = (KieRuntimeService)runtimes.getRuntimes().get(cls.getName());
            runtime = service.newKieRuntime((KieRuntime)this);
        }
        return (T)runtime;
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.getWorkingMemoryEntryPoint(name);
    }

    @Override
    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.entryPoints.values();
    }

    public Map<String, WorkingMemoryEntryPoint> getEntryPointMap() {
        return this.entryPoints;
    }

    @Override
    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return Collections.unmodifiableCollection(this.ruleRuntimeEventSupport.getEventListeners());
    }

    @Override
    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return Collections.unmodifiableCollection(this.agendaEventSupport.getEventListeners());
    }

    private InternalProcessRuntime createProcessRuntime() {
        InternalProcessRuntime processRuntime = ProcessRuntimeFactory.newProcessRuntime(this);
        if (processRuntime == null) {
            processRuntime = DUMMY_PROCESS_RUNTIME;
        }
        return processRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalProcessRuntime getProcessRuntime() {
        if (this.processRuntime == null) {
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = this;
            synchronized (statefulKnowledgeSessionImpl) {
                if (this.processRuntime == null) {
                    this.processRuntime = this.createProcessRuntime();
                }
            }
        }
        return this.processRuntime;
    }

    @Override
    public InternalProcessRuntime internalGetProcessRuntime() {
        return this.processRuntime;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.getProcessRuntime().addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.getProcessRuntime().getProcessEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.getProcessRuntime().removeEventListener(listener);
    }

    public KieBase getKieBase() {
        return this.kBase;
    }

    @Override
    public void dispose() {
        if (!this.agenda.dispose(this)) {
            return;
        }
        if (this.logger != null) {
            try {
                this.logger.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            ep.dispose();
        }
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.agendaEventSupport.clear();
        for (KieBaseEventListener listener : this.kieBaseEventListeners) {
            this.kBase.removeEventListener(listener);
        }
        if (this.processRuntime != null) {
            this.processRuntime.dispose();
        }
        if (this.timerService != null) {
            this.timerService.shutdown();
        }
        if (this.workItemManager != null) {
            ((org.drools.core.process.instance.WorkItemManager)this.workItemManager).dispose();
        }
        this.kBase.disposeStatefulSession(this);
        if (this.mbeanRegistered.get()) {
            DroolsManagementAgent.getInstance().unregisterKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, this);
        }
    }

    public boolean isAlive() {
        return this.agenda.isAlive();
    }

    public void destroy() {
        this.dispose();
    }

    public void update(FactHandle factHandle) {
        this.update(factHandle, ((InternalFactHandle)factHandle).getObject());
    }

    public void abortProcessInstance(long id) {
        this.getProcessRuntime().abortProcessInstance(id);
    }

    public void signalEvent(String type, Object event) {
        this.getProcessRuntime().signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.getProcessRuntime().signalEvent(type, event, processInstanceId);
    }

    public Globals getGlobals() {
        return (Globals)this.getGlobalResolver();
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return new ObjectStoreWrapper(this.getObjectStore(), null, 1);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.getObjectStore(), filter, 1);
    }

    public Collection<?> getObjects() {
        return new ObjectStoreWrapper(this.getObjectStore(), null, 0);
    }

    public Collection<?> getObjects(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.getObjectStore(), filter, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        ExecutableRunner runner = ExecutableRunner.create();
        RequestContext context = ((RequestContext)runner.createContext()).with((KieBase)this.kBase).with((KieSession)this);
        if (!(command instanceof BatchExecutionCommand)) {
            return (T)runner.execute(command, (Context)context);
        }
        try {
            this.startBatchExecution();
            Object object = runner.execute(command, (Context)context);
            return (T)object;
        }
        finally {
            this.endBatchExecution();
            if (this.kBase.flushModifications()) {
                this.fireAllRules();
            }
        }
    }

    public InternalFactHandle initInitialFact(InternalKnowledgeBase kBase, MarshallerReaderContext context) {
        return this.initInitialFact(kBase, this.defaultEntryPoint, this.defaultEntryPoint.getEntryPoint(), context);
    }

    public InternalFactHandle initInitialFact(InternalKnowledgeBase kBase, InternalWorkingMemoryEntryPoint entryPoint, EntryPointId epId, MarshallerReaderContext context) {
        InitialFact initialFact = InitialFactImpl.getInstance();
        DefaultFactHandle handle = new DefaultFactHandle(0, initialFact, 0L, entryPoint);
        ClassObjectTypeConf otc = (ClassObjectTypeConf)entryPoint.getObjectTypeConfigurationRegistry().getObjectTypeConf(epId, initialFact);
        ObjectTypeNode otn = otc.getConcreteObjectTypeNode();
        if (otn != null) {
            PropagationContextFactory ctxFact = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext pctx = ctxFact.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, handle, epId, context);
            otn.assertInitialFact(handle, pctx, this);
        }
        return handle;
    }

    public String getEntryPointId() {
        return EntryPointId.DEFAULT.getEntryPointId();
    }

    public QueryResultsImpl getQueryResultsFromRHS(String queryName, Object ... arguments) {
        return this.internalGetQueryResult(true, queryName, arguments);
    }

    @Override
    public QueryResultsImpl getQueryResults(String queryName, Object ... arguments) {
        return this.internalGetQueryResult(false, queryName, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResultsImpl internalGetQueryResult(boolean calledFromRHS, String queryName, Object ... arguments) {
        try {
            this.startOperation();
            this.lock.lock();
            this.kBase.executeQueuedActions();
            if (calledFromRHS) {
                this.flushPropagations();
                this.flushPropagations();
            } else {
                this.agenda.executeFlush();
                this.agenda.executeFlush();
            }
            DroolsQuery queryObject = new DroolsQuery(queryName, arguments, this.getQueryListenerInstance(), false, null, null, null, null, null);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, null, this, this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getEntryPoint());
            BaseNode[] tnodes = this.evalQuery(queryName, queryObject, handle, pCtx, calledFromRHS);
            ArrayList<Map<String, Declaration>> decls = new ArrayList<Map<String, Declaration>>();
            if (tnodes != null) {
                for (BaseNode node : tnodes) {
                    decls.add(((QueryTerminalNode)node).getSubRule().getOuterDeclarations());
                }
            }
            this.handleFactory.destroyFactHandle(handle);
            QueryResultsImpl queryResultsImpl = new QueryResultsImpl(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
            return queryResultsImpl;
        }
        finally {
            this.lock.unlock();
            this.endOperation();
        }
    }

    private InternalViewChangedEventListener getQueryListenerInstance() {
        switch (this.config.getQueryListenerOption()) {
            case STANDARD: {
                return new StandardQueryViewChangedEventListener();
            }
            case LIGHTWEIGHT: {
                return new NonCloningQueryViewListener();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        try {
            this.startOperation();
            this.lock.lock();
            this.kBase.executeQueuedActions();
            this.agenda.executeFlush();
            DroolsQuery queryObject = new DroolsQuery(query, arguments, new OpenQueryViewChangedEventListenerAdapter(listener), true, null, null, null, null, null);
            InternalFactHandle handle = this.handleFactory.newFactHandle(queryObject, null, this, this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getEntryPoint());
            this.evalQuery(queryObject.getName(), queryObject, handle, pCtx, false);
            LiveQueryImpl liveQueryImpl = new LiveQueryImpl(this, handle);
            return liveQueryImpl;
        }
        finally {
            this.lock.unlock();
            this.endOperation();
        }
    }

    protected BaseNode[] evalQuery(String queryName, DroolsQuery queryObject, InternalFactHandle handle, PropagationContext pCtx, boolean isCalledFromRHS) {
        ExecuteQuery executeQuery = new ExecuteQuery(queryName, queryObject, handle, pCtx, isCalledFromRHS);
        this.addPropagation(executeQuery);
        return (BaseNode[])executeQuery.getResult();
    }

    @Override
    public void closeLiveQuery(InternalFactHandle factHandle) {
        try {
            this.startOperation();
            this.lock.lock();
            ExecuteCloseLiveQuery query = new ExecuteCloseLiveQuery(factHandle);
            this.addPropagation(query);
            query.getResult();
        }
        finally {
            this.lock.unlock();
            this.endOperation();
        }
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.defaultEntryPoint.getEntryPoint();
    }

    @Override
    public InternalWorkingMemory getInternalWorkingMemory() {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.getKnowledgeRuntime();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)ksession.getKieBase(), (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)stream, (KieSession)((StatefulKnowledgeSession)this.getKnowledgeRuntime()));
        stream.close();
        byte[] bytes = stream.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
    }

    @Override
    public void updateEntryPointsCache() {
        if (this.kBase.getAddedEntryNodeCache() != null) {
            for (EntryPointNode addedNode : this.kBase.getAddedEntryNodeCache()) {
                EntryPointId id = addedNode.getEntryPoint();
                if (EntryPointId.DEFAULT.equals(id)) continue;
                NamedEntryPoint wmEntryPoint = new NamedEntryPoint(id, addedNode, this);
                this.entryPoints.put(id.getEntryPointId(), wmEntryPoint);
            }
        }
        if (this.kBase.getRemovedEntryNodeCache() != null) {
            for (EntryPointNode removedNode : this.kBase.getRemovedEntryNodeCache()) {
                this.entryPoints.remove(removedNode.getEntryPoint().getEntryPointId());
            }
        }
    }

    protected void initDefaultEntryPoint() {
        this.defaultEntryPoint = this.createDefaultEntryPoint();
        this.entryPoints.clear();
        this.entryPoints.put("DEFAULT", this.defaultEntryPoint);
    }

    protected InternalWorkingMemoryEntryPoint createDefaultEntryPoint() {
        EntryPointNode epn = this.kBase.getRete().getEntryPointNode(EntryPointId.DEFAULT);
        return new NamedEntryPoint(EntryPointId.DEFAULT, epn, this);
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.config;
    }

    @Override
    public void reset() {
        if (this.nodeMemories != null) {
            this.nodeMemories.resetAllMemories(this);
        }
        this.agenda.reset();
        this.globalResolver.clear();
        this.kieBaseEventListeners.clear();
        this.handleFactory.clear(0, 0L);
        this.propagationIdCounter.set(0L);
        this.opCounter.set(0L);
        this.lastIdleTimestamp.set(-1L);
        this.initDefaultEntryPoint();
        this.updateEntryPointsCache();
        this.timerService = TimerServiceFactory.getTimerService(this.config);
        this.processRuntime = null;
        this.initialFactHandle = this.initInitialFact(this.kBase, null);
        this.alive = true;
    }

    public void reset(int handleId, long handleCounter, long propagationCounter) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clear();
        }
        this.agenda.clear();
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            ep.reset();
        }
        this.handleFactory.clear(handleId, handleCounter);
        this.propagationIdCounter = new AtomicLong(propagationCounter);
        this.opCounter.set(0L);
        this.lastIdleTimestamp.set(-1L);
    }

    @Override
    public void setRuleRuntimeEventSupport(RuleRuntimeEventSupport ruleRuntimeEventSupport) {
        this.ruleRuntimeEventSupport = ruleRuntimeEventSupport;
    }

    @Override
    public void setAgendaEventSupport(AgendaEventSupport agendaEventSupport) {
        this.agendaEventSupport = agendaEventSupport;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public void addEventListener(RuleRuntimeEventListener listener) {
        this.ruleRuntimeEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.ruleRuntimeEventSupport.removeEventListener(listener);
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    public void addEventListener(KieBaseEventListener listener) {
        this.kBase.addEventListener(listener);
        this.kieBaseEventListeners.add(listener);
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return Collections.unmodifiableCollection(this.kieBaseEventListeners);
    }

    public void removeEventListener(KieBaseEventListener listener) {
        this.kBase.removeEventListener(listener);
        this.kieBaseEventListeners.remove(listener);
    }

    @Override
    public RuleEventListenerSupport getRuleEventSupport() {
        return this.ruleEventListenerSupport;
    }

    public void addEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.addEventListener(listener);
    }

    public void removeEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.removeEventListener(listener);
    }

    @Override
    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobal(String identifier, Object value) {
        if (value == null) {
            return;
        }
        try {
            this.kBase.readLock();
            this.startOperation();
            Class<?> type = this.kBase.getGlobals().get(identifier);
            if (type == null) {
                throw new RuntimeException("Unexpected global [" + identifier + "]");
            }
            if (!type.isInstance(value)) {
                throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], found [" + value.getClass().getName() + "].");
            }
            this.globalResolver.setGlobal(identifier, value);
        }
        finally {
            this.endOperation();
            this.kBase.readUnlock();
        }
    }

    @Override
    public void removeGlobal(String identifier) {
        this.globalResolver.removeGlobal(identifier);
    }

    @Override
    public void setGlobalResolver(GlobalResolver globalResolver) {
        try {
            this.lock.lock();
            this.globalResolver = globalResolver;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public Calendars getCalendars() {
        if (this.calendars == null) {
            this.calendars = new CalendarsImpl();
        }
        return this.calendars;
    }

    public int getId() {
        this.checkAlive();
        return this.id.intValue();
    }

    @Override
    public long getIdentifier() {
        this.checkAlive();
        return this.id;
    }

    @Override
    public void setIdentifier(long id) {
        this.checkAlive();
        this.id = id;
    }

    protected void checkAlive() {
        if (!this.isAlive()) {
            throw new IllegalStateException(ERRORMSG);
        }
    }

    @Override
    public Object getGlobal(String identifier) {
        return this.globalResolver.resolveGlobal(identifier);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InternalAgenda getAgenda() {
        return this.agenda;
    }

    @Override
    public void clearAgenda() {
        this.agenda.clearAndCancel();
    }

    @Override
    public void clearAgendaGroup(String group) {
        this.agenda.clearAndCancelAgendaGroup(group);
    }

    @Override
    public void clearActivationGroup(String group) {
        this.agenda.clearAndCancelActivationGroup(group);
    }

    @Override
    public void clearRuleFlowGroup(String group) {
        this.agenda.clearAndCancelRuleFlowGroup(group);
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    @Override
    public void halt() {
        this.agenda.halt();
    }

    @Override
    public int fireAllRules() {
        return this.fireAllRules(null, -1);
    }

    @Override
    public int fireAllRules(int fireLimit) {
        return this.fireAllRules(null, fireLimit);
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.checkAlive();
        try {
            this.startOperation();
            int n = this.internalFireAllRules(agendaFilter, fireLimit);
            return n;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalFireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        int fireCount = 0;
        try {
            fireCount = this.agenda.fireAllRules(agendaFilter, fireLimit);
        }
        finally {
            if (this.kBase.flushModifications()) {
                fireCount += this.internalFireAllRules(agendaFilter, fireLimit);
            }
        }
        return fireCount;
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (this.isSequential()) {
            throw new IllegalStateException("fireUntilHalt() can not be called in sequential mode.");
        }
        try {
            this.startOperation();
            this.agenda.fireUntilHalt(agendaFilter);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Object getObject(FactHandle handle) {
        if (((InternalFactHandle)handle).isDisconnected()) {
            handle = this.defaultEntryPoint.getObjectStore().reconnect((InternalFactHandle)handle);
        }
        return this.defaultEntryPoint.getObject(handle);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.defaultEntryPoint.getObjectStore();
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.defaultEntryPoint.getFactHandle(object);
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.getObjectStore().getHandleForObjectIdentity(object);
    }

    public Iterator iterateObjects() {
        return this.getObjectStore().iterateObjects();
    }

    public Iterator iterateObjects(ObjectFilter filter) {
        return this.getObjectStore().iterateObjects(filter);
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles() {
        return this.getObjectStore().iterateFactHandles();
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles(ObjectFilter filter) {
        return this.getObjectStore().iterateFactHandles(filter);
    }

    @Override
    public void setFocus(String focus) {
        this.agenda.getAgendaGroup(focus).setFocus();
    }

    @Override
    public FactHandle insertAsync(Object object) {
        this.checkAlive();
        return this.defaultEntryPoint.insertAsync(object);
    }

    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) {
        return this.insert(object, dynamic, null, null);
    }

    public void submit(final KieSession.AtomicAction action) {
        this.agenda.addPropagation(new PropagationEntry.AbstractPropagationEntry(){

            @Override
            public void execute(InternalWorkingMemory wm) {
                action.execute((KieSession)wm);
            }
        });
    }

    @Override
    public void updateTraits(InternalFactHandle h, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.defaultEntryPoint.getTraitHelper().updateTraits(h, mask, modifiedClass, activation);
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(Activation activation, TraitableBean<K, X> core, Class<T> trait) {
        return this.defaultEntryPoint.getTraitHelper().shed(core, trait, activation);
    }

    @Override
    public <T, K> T don(Activation activation, K core, Collection<Class<? extends Thing>> traits, boolean b, Mode[] modes) {
        return this.defaultEntryPoint.getTraitHelper().don(activation, core, traits, b, modes);
    }

    @Override
    public <T, K> T don(Activation activation, K core, Class<T> trait, boolean b, Mode[] modes) {
        return this.defaultEntryPoint.getTraitHelper().don(activation, core, trait, b, modes);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, TerminalNode terminalNode) {
        this.checkAlive();
        return this.defaultEntryPoint.insert(object, dynamic, rule, terminalNode);
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, null, null);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.delete(handle, null, null, fhState);
    }

    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode) {
        this.delete(factHandle, rule, terminalNode, FactHandle.State.ALL);
    }

    @Override
    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        this.checkAlive();
        this.defaultEntryPoint.delete(factHandle, rule, terminalNode, fhState);
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.defaultEntryPoint.getEntryPointNode();
    }

    public void update(FactHandle handle, Object object) {
        this.update(handle, object, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        this.checkAlive();
        this.defaultEntryPoint.update(handle, object, modifiedProperties);
    }

    @Override
    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.checkAlive();
        this.defaultEntryPoint.update(factHandle, object, mask, modifiedClass, activation);
    }

    @Override
    public void executeQueuedActions() {
        this.flushPropagations();
    }

    @Override
    public void queueWorkingMemoryAction(WorkingMemoryAction action) {
        try {
            this.startOperation();
            this.addPropagation(action);
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node) {
        return this.nodeMemories.getNodeMemory(node, this);
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clearNodeMemory(node);
        }
    }

    @Override
    public NodeMemories getNodeMemories() {
        return this.nodeMemories;
    }

    @Override
    public RuleRuntimeEventSupport getRuleRuntimeEventSupport() {
        return this.ruleRuntimeEventSupport;
    }

    @Override
    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    @Override
    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
    }

    @Override
    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public long getPropagationIdCounter() {
        return this.propagationIdCounter.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.getProcessRuntime().startProcess(processId);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.getProcessRuntime().startProcess(processId, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.getProcessRuntime().createProcessInstance(processId, parameters);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.getProcessRuntime().startProcessInstance(processInstanceId);
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.getProcessRuntime().getProcessInstances();
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.getProcessRuntime().getProcessInstance(processInstanceId);
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.getProcessRuntime().startProcess(processId, correlationKey, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.getProcessRuntime().createProcessInstance(processId, correlationKey, parameters);
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.getProcessRuntime().getProcessInstance(correlationKey);
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId, boolean readOnly) {
        return this.getProcessRuntime().getProcessInstance(processInstanceId, readOnly);
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = this.config.getWorkItemManagerFactory().createWorkItemManager(this.getKnowledgeRuntime());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ksession", this.getKnowledgeRuntime());
            Map<String, WorkItemHandler> workItemHandlers = this.config.getWorkItemHandlers(params);
            if (workItemHandlers != null) {
                for (Map.Entry<String, WorkItemHandler> entry : workItemHandlers.entrySet()) {
                    this.workItemManager.registerWorkItemHandler(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.workItemManager;
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.entryPoints.get(name);
    }

    public Map<String, WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        return this.entryPoints;
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.defaultEntryPoint.getObjectTypeConfigurationRegistry();
    }

    @Override
    public InternalFactHandle getInitialFactHandle() {
        return this.initialFactHandle;
    }

    public void setInitialFactHandle(InternalFactHandle initialFactHandle) {
        this.initialFactHandle = initialFactHandle;
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    @Override
    public void startBatchExecution() {
        this.lock.lock();
    }

    @Override
    public void endBatchExecution() {
        this.lock.unlock();
    }

    @Override
    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this;
    }

    public void registerChannel(String name, Channel channel) {
        this.getChannels().put(name, channel);
    }

    public void unregisterChannel(String name) {
        if (this.channels != null) {
            this.channels.remove(name);
        }
    }

    @Override
    public Map<String, Channel> getChannels() {
        if (this.channels == null) {
            this.channels = new ConcurrentHashMap<String, Channel>();
        }
        return this.channels;
    }

    public long getFactCount() {
        return this.getObjectStore().size();
    }

    @Override
    public long getTotalFactCount() {
        long result = 0L;
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            result += ep.getFactCount();
        }
        return result;
    }

    @Override
    public void startOperation() {
        if (this.opCounter.getAndIncrement() == 0L) {
            this.lastIdleTimestamp.set(-1L);
        }
    }

    @Override
    public void setEndOperationListener(EndOperationListener listener) {
        this.endOperationListener = listener;
    }

    @Override
    public void endOperation() {
        if (this.opCounter.decrementAndGet() == 0L) {
            this.lastIdleTimestamp.set(this.timerService.getCurrentTime());
            if (this.endOperationListener != null) {
                this.endOperationListener.endOperation(this.getKnowledgeRuntime());
            }
        }
    }

    @Override
    public long getIdleTime() {
        long lastIdle = this.lastIdleTimestamp.get();
        return lastIdle > -1L ? this.timerService.getCurrentTime() - lastIdle : -1L;
    }

    @Override
    public long getLastIdleTimestamp() {
        return this.lastIdleTimestamp.get();
    }

    @Override
    public void prepareToFireActivation() {
    }

    @Override
    public void activationFired() {
    }

    @Override
    public long getTimeToNextJob() {
        return this.timerService.getTimeToNextJob();
    }

    @Override
    public void addPropagation(PropagationEntry propagationEntry) {
        this.agenda.addPropagation(propagationEntry);
    }

    @Override
    public void flushPropagations() {
        this.agenda.flushPropagations();
    }

    @Override
    public void notifyWaitOnRest() {
        this.agenda.notifyWaitOnRest();
    }

    @Override
    public Iterator<? extends PropagationEntry> getActionsIterator() {
        return this.agenda.getActionsIterator();
    }

    @Override
    public void activate() {
        this.agenda.activate();
    }

    @Override
    public void deactivate() {
        this.agenda.deactivate();
    }

    @Override
    public boolean tryDeactivate() {
        return this.agenda.tryDeactivate();
    }

    @Override
    public void cancelActivation(Activation activation, boolean declarativeAgenda) {
        if (declarativeAgenda && activation.getActivationFactHandle() != null) {
            this.getEntryPointNode().retractActivation(activation.getActivationFactHandle(), activation.getPropagationContext(), this);
        }
        if (this.ruleUnitExecutor != null) {
            this.ruleUnitExecutor.cancelActivation(activation);
        }
    }

    @Override
    public void onSuspend() {
        if (this.ruleUnitExecutor != null) {
            this.ruleUnitExecutor.onSuspend();
        }
    }

    @Override
    public void onResume() {
        if (this.ruleUnitExecutor != null) {
            this.ruleUnitExecutor.onResume();
        }
    }

    @Override
    public InternalRuleUnitExecutor getRuleUnitExecutor() {
        return this.ruleUnitExecutor;
    }

    @Override
    public PropagationList getPropagationList() {
        return this.agenda.getPropagationList();
    }

    public String toString() {
        return "KieSession[" + this.id + "]";
    }

    public List iterateObjectsToList() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.iterateObjects();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public List iterateNonDefaultEntryPointObjectsToList() {
        ArrayList<EntryPointObjects> result = new ArrayList<EntryPointObjects>();
        for (Map.Entry<String, WorkingMemoryEntryPoint> entry : this.entryPoints.entrySet()) {
            WorkingMemoryEntryPoint entryPoint = entry.getValue();
            if (!(entryPoint instanceof NamedEntryPoint)) continue;
            result.add(new EntryPointObjects(entry.getKey(), new ArrayList(entry.getValue().getObjects())));
        }
        return result;
    }

    public Map.Entry[] getActivationParameters(long activationId) {
        Activation[] activations = this.agenda.getActivations();
        for (int i = 0; i < activations.length; ++i) {
            if (activations[i].getActivationNumber() != activationId) continue;
            Map params = this.getActivationParameters(activations[i]);
            return params.entrySet().toArray(new Map.Entry[params.size()]);
        }
        return new Map.Entry[0];
    }

    public Map getActivationParameters(Activation activation) {
        if (activation instanceof RuleAgendaItem) {
            RuleAgendaItem ruleAgendaItem = (RuleAgendaItem)activation;
            TupleList tupleList = ruleAgendaItem.getRuleExecutor().getLeftTupleList();
            TreeMap<String, Map.Entry[]> result = new TreeMap<String, Map.Entry[]>();
            int i = 0;
            for (Tuple tuple = tupleList.getFirst(); tuple != null; tuple = (Tuple)tuple.getNext()) {
                Map params = this.getActivationParameters(tuple);
                result.put("Parameters set [" + i++ + "]", params.entrySet().toArray(new Map.Entry[params.size()]));
            }
            return result;
        }
        return this.getActivationParameters(activation.getTuple());
    }

    private Map getActivationParameters(Tuple tuple) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Declaration[] declarations = ((RuleTerminalNode)tuple.getTupleSink()).getAllDeclarations();
        for (int i = 0; i < declarations.length; ++i) {
            InternalFactHandle handle = tuple.get(declarations[i]);
            if (!(handle instanceof InternalFactHandle)) continue;
            result.put(declarations[i].getIdentifier(), declarations[i].getValue(this, handle.getObject()));
        }
        return result;
    }

    private class EntryPointObjects {
        private String name;
        private List objects;

        public EntryPointObjects(String name, List objects) {
            this.name = name;
            this.objects = objects;
        }
    }

    public static class DummyInternalProcessRuntime
    implements InternalProcessRuntime {
        @Override
        public void dispose() {
        }

        @Override
        public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearProcessInstances() {
        }

        @Override
        public void clearProcessInstancesState() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
            throw new UnsupportedOperationException();
        }

        public void addEventListener(ProcessEventListener listener) {
        }

        public void removeEventListener(ProcessEventListener listener) {
        }

        public Collection<ProcessEventListener> getProcessEventListeners() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public void signalEvent(String type, Object event) {
            throw new UnsupportedOperationException();
        }

        public void signalEvent(String type, Object event, long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public Collection<ProcessInstance> getProcessInstances() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(long processInstanceId, boolean readonly) {
            throw new UnsupportedOperationException();
        }

        public void abortProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public WorkItemManager getWorkItemManager() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PartitionAwareWorkingMemoryReteExpireAction
    extends PropagationEntry.AbstractPartitionedPropagationEntry {
        private final EventFactHandle factHandle;
        private final ObjectTypeNode node;

        public PartitionAwareWorkingMemoryReteExpireAction(EventFactHandle factHandle, ObjectTypeNode node, int partition) {
            super(partition);
            this.factHandle = factHandle;
            this.node = node;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            if (!this.factHandle.isValid()) {
                return;
            }
            PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(wm, this.factHandle, PropagationContext.Type.EXPIRATION);
            ((CompositeDefaultAgenda)wm.getAgenda()).getPartitionedAgenda(this.partition).registerExpiration(context);
            DefaultFactHandle.CompositeLinkedTuples linkedTuples = (DefaultFactHandle.CompositeLinkedTuples)this.factHandle.getLinkedTuples();
            linkedTuples.forEachLeftTuple(this.partition, ObjectTypeNode::expireLeftTuple);
            linkedTuples.forEachRightTuple(this.partition, rt -> {
                rt.setExpired(true);
                ObjectTypeNode.expireRightTuple(rt);
            });
            if (this.isMasterPartition()) {
                WorkingMemoryReteExpireAction.expireFactHandle(wm, this.factHandle);
            }
        }

        public String toString() {
            return "Expiration of " + this.factHandle.getObject() + " for partition " + this.partition;
        }
    }

    public static class WorkingMemoryReteExpireAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private EventFactHandle factHandle;
        private ObjectTypeNode node;

        public WorkingMemoryReteExpireAction(EventFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public WorkingMemoryReteExpireAction(EventFactHandle factHandle, ObjectTypeNode node) {
            this(factHandle);
            this.node = node;
            factHandle.increaseOtnCount();
        }

        public EventFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(EventFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public ObjectTypeNode getNode() {
            return this.node;
        }

        public void setNode(ObjectTypeNode node) {
            this.node = node;
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = (EventFactHandle)context.handles.get(context.readInt());
            int nodeId = context.readInt();
            this.node = (ObjectTypeNode)context.sinks.get(nodeId);
        }

        public WorkingMemoryReteExpireAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.factHandle = (EventFactHandle)context.handles.get(_action.getExpire().getHandleId());
            if (_action.getExpire().getNodeId() > 0) {
                this.node = (ObjectTypeNode)context.sinks.get(_action.getExpire().getNodeId());
            }
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.EXPIRE).setExpire(ProtobufMessages.ActionQueue.Expire.newBuilder().setHandleId(this.factHandle.getId()).setNodeId(this.node != null ? this.node.getId() : -1).build()).build();
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            if (!this.factHandle.isValid()) {
                return;
            }
            PropagationContext context = PhreakPropagationContextFactory.createPropagationContextForFact(workingMemory, this.factHandle, PropagationContext.Type.EXPIRATION);
            workingMemory.getAgenda().registerExpiration(context);
            this.factHandle.forEachLeftTuple(ObjectTypeNode::expireLeftTuple);
            this.factHandle.forEachRightTuple(rt -> {
                rt.setExpired(true);
                ObjectTypeNode.expireRightTuple(rt);
            });
            WorkingMemoryReteExpireAction.expireFactHandle(workingMemory, this.factHandle);
        }

        private static void expireFactHandle(InternalWorkingMemory workingMemory, EventFactHandle factHandle) {
            factHandle.decreaseOtnCount();
            if (factHandle.getOtnCount() == 0) {
                factHandle.setExpired(true);
                if (factHandle.getActivationsCount() == 0L) {
                    String epId = factHandle.getEntryPoint().getEntryPointId();
                    ((InternalWorkingMemoryEntryPoint)workingMemory.getEntryPoint(epId)).removeFromObjectStore(factHandle);
                } else {
                    factHandle.setPendingRemoveFromStore(true);
                }
            }
        }

        @Override
        public boolean isPartitionSplittable() {
            return true;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            return new PartitionAwareWorkingMemoryReteExpireAction(this.factHandle, this.node, partitionNr);
        }

        public String toString() {
            return "Expiration of " + this.factHandle.getObject();
        }
    }

    public static class WorkingMemoryReteAssertAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private final InternalFactHandle factHandle;
        private final boolean removeLogical;
        private final boolean updateEqualsMap;
        private RuleImpl ruleOrigin;
        private Tuple tuple;

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context) throws IOException {
            this.factHandle = context.handles.get(context.readInt());
            this.removeLogical = context.readBoolean();
            this.updateEqualsMap = context.readBoolean();
            if (context.readBoolean()) {
                String pkgName = context.readUTF();
                String ruleName = context.readUTF();
                InternalKnowledgePackage pkg = context.kBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
            }
            if (context.readBoolean()) {
                this.tuple = context.terminalTupleMap.get(context.readInt());
            }
        }

        public WorkingMemoryReteAssertAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            ProtobufMessages.ActionQueue.Assert _assert = _action.getAssert();
            this.factHandle = context.handles.get(_assert.getHandleId());
            this.removeLogical = _assert.getRemoveLogical();
            this.updateEqualsMap = _assert.getUpdateEqualsMap();
            if (_assert.hasTuple()) {
                String pkgName = _assert.getOriginPkgName();
                String ruleName = _assert.getOriginRuleName();
                InternalKnowledgePackage pkg = context.kBase.getPackage(pkgName);
                this.ruleOrigin = pkg.getRule(ruleName);
                this.tuple = context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(pkgName, ruleName, _assert.getTuple()));
            }
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            ProtobufMessages.ActionQueue.Assert.Builder _assert = ProtobufMessages.ActionQueue.Assert.newBuilder();
            _assert.setHandleId(this.factHandle.getId()).setRemoveLogical(this.removeLogical).setUpdateEqualsMap(this.updateEqualsMap);
            if (this.tuple != null) {
                ProtobufMessages.Tuple.Builder _tuple = ProtobufMessages.Tuple.newBuilder();
                for (Tuple entry = this.tuple; entry != null; entry = entry.getParent()) {
                    if (entry.getFactHandle() == null) continue;
                    _tuple.addHandleId(entry.getFactHandle().getId());
                }
                _assert.setOriginPkgName(this.ruleOrigin.getPackageName()).setOriginRuleName(this.ruleOrigin.getName()).setTuple(_tuple.build());
            }
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.ASSERT).setAssert(_assert.build()).build();
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext context = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, this.ruleOrigin, this.tuple != null ? (TerminalNode)this.tuple.getTupleSink() : null, this.factHandle);
            workingMemory.getKnowledgeBase().getRete().assertObject(this.factHandle, context, workingMemory);
        }
    }

    public static class GlobalsAdapter
    implements GlobalResolver {
        private Globals globals;

        public GlobalsAdapter(Globals globals) {
            this.globals = globals;
        }

        @Override
        public Object resolveGlobal(String identifier) {
            return this.globals.get(identifier);
        }

        @Override
        public void setGlobal(String identifier, Object value) {
            this.globals.set(identifier, value);
        }

        @Override
        public void removeGlobal(String identifier) {
            ((GlobalResolver)this.globals).removeGlobal(identifier);
        }

        @Override
        public void clear() {
            if (this.globals instanceof GlobalResolver) {
                ((GlobalResolver)this.globals).clear();
            }
        }
    }

    private class ExecuteCloseLiveQuery
    extends PropagationEntry.PropagationEntryWithResult<Void> {
        private final InternalFactHandle factHandle;

        private ExecuteCloseLiveQuery(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            LeftInputAdapterNode lian = (LeftInputAdapterNode)this.factHandle.getFirstLeftTuple().getTupleSource();
            LeftInputAdapterNode.LiaNodeMemory lmem = StatefulKnowledgeSessionImpl.this.getNodeMemory(lian);
            SegmentMemory lsmem = lmem.getSegmentMemory();
            LeftTuple childLeftTuple = this.factHandle.getFirstLeftTuple();
            LeftInputAdapterNode.doDeleteObject(childLeftTuple, childLeftTuple.getPropagationContext(), lsmem, StatefulKnowledgeSessionImpl.this, lian, false, lmem);
            for (PathMemory rm : lmem.getSegmentMemory().getPathMemories()) {
                RuleAgendaItem evaluator = StatefulKnowledgeSessionImpl.this.agenda.createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)((Object)rm.getPathEndNode()));
                evaluator.getRuleExecutor().setDirty(true);
                evaluator.getRuleExecutor().evaluateNetworkAndFire(StatefulKnowledgeSessionImpl.this, null, 0, -1);
            }
            StatefulKnowledgeSessionImpl.this.getFactHandleFactory().destroyFactHandle(this.factHandle);
            this.done(null);
        }
    }

    private class ExecuteQuery
    extends PropagationEntry.PropagationEntryWithResult<BaseNode[]> {
        private final String queryName;
        private final DroolsQuery queryObject;
        private final InternalFactHandle handle;
        private final PropagationContext pCtx;
        private final boolean calledFromRHS;

        private ExecuteQuery(String queryName, DroolsQuery queryObject, InternalFactHandle handle, PropagationContext pCtx, boolean calledFromRHS) {
            this.queryName = queryName;
            this.queryObject = queryObject;
            this.handle = handle;
            this.pCtx = pCtx;
            this.calledFromRHS = calledFromRHS;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            BaseNode[] tnodes = StatefulKnowledgeSessionImpl.this.kBase.getReteooBuilder().getTerminalNodesForQuery(this.queryName);
            if (tnodes == null) {
                throw new RuntimeException("Query '" + this.queryName + "' does not exist");
            }
            QueryTerminalNode tnode = (QueryTerminalNode)tnodes[0];
            LeftTupleSource lts = tnode.getLeftTupleSource();
            while (lts.getType() != 120) {
                lts = lts.getLeftTupleSource();
            }
            LeftInputAdapterNode lian = (LeftInputAdapterNode)lts;
            LeftInputAdapterNode.LiaNodeMemory lmem = StatefulKnowledgeSessionImpl.this.getNodeMemory(lian);
            if (lmem.getSegmentMemory() == null) {
                SegmentUtilities.createSegmentMemory(lts, StatefulKnowledgeSessionImpl.this);
            }
            LeftInputAdapterNode.doInsertObject(this.handle, this.pCtx, lian, StatefulKnowledgeSessionImpl.this, lmem, false, this.queryObject.isOpen());
            for (PathMemory rm : lmem.getSegmentMemory().getPathMemories()) {
                RuleAgendaItem evaluator = StatefulKnowledgeSessionImpl.this.agenda.createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)((Object)rm.getPathEndNode()));
                evaluator.getRuleExecutor().setDirty(true);
                evaluator.getRuleExecutor().evaluateNetworkAndFire(StatefulKnowledgeSessionImpl.this, null, 0, -1);
            }
            this.done(tnodes);
        }

        @Override
        public boolean isCalledFromRHS() {
            return this.calledFromRHS;
        }
    }

    public static class ObjectStoreWrapper
    extends AbstractImmutableCollection {
        public ObjectStore store;
        public ObjectFilter filter;
        public int type;
        public static final int OBJECT = 0;
        public static final int FACT_HANDLE = 1;

        public ObjectStoreWrapper(ObjectStore store, ObjectFilter filter, int type) {
            this.store = store;
            this.filter = filter;
            this.type = type;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof FactHandle) {
                return this.store.getObjectForHandle((InternalFactHandle)object) != null;
            }
            return this.store.getHandleForObject(object) != null;
        }

        public boolean containsAll(Collection c) {
            for (Object object : c) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            if (this.filter == null) {
                return this.store.isEmpty();
            }
            return this.size() == 0;
        }

        @Override
        public int size() {
            if (this.filter == null) {
                return this.store.size();
            }
            int i = 0;
            for (Object o : this) {
                ++i;
            }
            return i;
        }

        @Override
        public Iterator<?> iterator() {
            Iterator<Object> it = this.type == 0 ? (this.filter != null ? this.store.iterateObjects(this.filter) : this.store.iterateObjects()) : (this.filter != null ? this.store.iterateFactHandles(this.filter) : this.store.iterateFactHandles());
            return it;
        }

        @Override
        public Object[] toArray() {
            return this.asList().toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.asList().toArray(array);
        }

        private List asList() {
            ArrayList list = new ArrayList();
            for (Object o : this) {
                list.add(o);
            }
            return list;
        }
    }

    public static abstract class AbstractImmutableCollection
    implements Collection {
        public boolean add(Object o) {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("This is an immmutable Collection");
        }
    }
}

