/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.common.NetworkNode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.EagerPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaTerminalNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.util.FastIterator;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyPhreakBuilder
implements PhreakBuilder {
    private static final Logger log = LoggerFactory.getLogger(LazyPhreakBuilder.class);

    LazyPhreakBuilder() {
    }

    @Override
    public void addRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kBase) {
        boolean hasWms;
        if (log.isTraceEnabled()) {
            log.trace("Adding Rule {}", (Object)tn.getRule().getName());
        }
        boolean hasProtos = kBase.hasSegmentPrototypes();
        boolean bl = hasWms = !wms.isEmpty();
        if (!hasProtos && !hasWms) {
            return;
        }
        RuleImpl rule = tn.getRule();
        LeftTupleNode firstSplit = LazyPhreakBuilder.getNetworkSplitPoint(tn);
        PathEndNodes pathEndNodes = LazyPhreakBuilder.getPathEndNodes(kBase, firstSplit, tn, (Rule)rule, hasProtos, hasWms);
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            if (120 == firstSplit.getType() && firstSplit.getAssociatedTerminalsSize() == 1) {
                LazyPhreakBuilder.insertLiaFacts(firstSplit, wm);
                continue;
            }
            PathEndNodeMemories tnms = LazyPhreakBuilder.getPathEndMemories(wm, pathEndNodes);
            if (tnms.subjectPmem == null) continue;
            Map<PathMemory, SegmentMemory[]> prevSmemsLookup = LazyPhreakBuilder.reInitPathMemories(tnms.otherPmems, null);
            Set<SegmentMemory> smemsToNotify = LazyPhreakBuilder.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.ADD_STRATEGY);
            LazyPhreakBuilder.addNewPaths(wm, smemsToNotify, tnms.subjectPmems);
            LazyPhreakBuilder.processLeftTuples(firstSplit, wm, true, (Rule)rule);
            LazyPhreakBuilder.notifySegments(smemsToNotify, wm);
        }
        if (hasWms) {
            LazyPhreakBuilder.insertFacts(pathEndNodes, wms);
        } else {
            for (PathEndNode node : pathEndNodes.otherEndNodes) {
                node.resetPathMemSpec(null);
            }
        }
    }

    @Override
    public void removeRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalRuleBase kBase) {
        boolean hasWms;
        if (log.isTraceEnabled()) {
            log.trace("Removing Rule {}", (Object)tn.getRule().getName());
        }
        boolean hasProtos = kBase.hasSegmentPrototypes();
        boolean bl = hasWms = !wms.isEmpty();
        if (!hasProtos && !hasWms) {
            return;
        }
        RuleImpl rule = tn.getRule();
        LeftTupleNode firstSplit = LazyPhreakBuilder.getNetworkSplitPoint(tn);
        PathEndNodes pathEndNodes = LazyPhreakBuilder.getPathEndNodes(kBase, firstSplit, tn, (Rule)rule, hasProtos, hasWms);
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            PathEndNodeMemories tnms = LazyPhreakBuilder.getPathEndMemories(wm, pathEndNodes);
            if (!tnms.subjectPmems.isEmpty()) {
                if (120 == firstSplit.getType() && firstSplit.getAssociatedTerminalsSize() == 1) {
                    if (tnms.subjectPmem != null) {
                        LazyPhreakBuilder.flushStagedTuples(firstSplit, tnms.subjectPmem, wm);
                    }
                    LazyPhreakBuilder.processLeftTuples(firstSplit, wm, false, (Rule)tn.getRule());
                    LazyPhreakBuilder.removeNewPaths(wm, tnms.subjectPmems);
                } else {
                    LazyPhreakBuilder.flushStagedTuples(tn, tnms.subjectPmem, pathEndNodes.subjectSplits, wm);
                    LazyPhreakBuilder.processLeftTuples(firstSplit, wm, false, (Rule)tn.getRule());
                    LazyPhreakBuilder.removeNewPaths(wm, tnms.subjectPmems);
                    Map<PathMemory, SegmentMemory[]> prevSmemsLookup = LazyPhreakBuilder.reInitPathMemories(tnms.otherPmems, tn);
                    Set<SegmentMemory> smemsToNotify = LazyPhreakBuilder.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.REMOVE_STRATEGY);
                    LazyPhreakBuilder.notifySegments(smemsToNotify, wm);
                }
            }
            if (tnms.subjectPmem == null || !tnms.subjectPmem.isInitialized() || !tnms.subjectPmem.getRuleAgendaItem().isQueued()) continue;
            tnms.subjectPmem.getRuleAgendaItem().dequeue();
        }
        if (!hasWms) {
            for (PathEndNode node : pathEndNodes.otherEndNodes) {
                node.resetPathMemSpec(null);
            }
        }
    }

    private static Set<SegmentMemory> handleExistingPaths(TerminalNode tn, Map<PathMemory, SegmentMemory[]> prevSmemsLookup, List<PathMemory> pmems, InternalWorkingMemory wm, ExistingPathStrategy strategy) {
        HashSet<SegmentMemory> smemsToNotify = new HashSet<SegmentMemory>();
        HashSet<SegmentMemory> visitedSegments = new HashSet<SegmentMemory>();
        HashSet<LeftTupleNode> visitedNodes = new HashSet<LeftTupleNode>();
        HashMap<LeftTupleNode, SegmentMemory> nodeToSegmentMap = new HashMap<LeftTupleNode, SegmentMemory>();
        for (PathMemory pmem : pmems) {
            LeftTupleNode node;
            LeftTupleNode[] nodes = pmem.getPathEndNode().getPathNodes();
            SegmentMemory[] prevSmems = prevSmemsLookup.get(pmem);
            SegmentMemory[] smems = strategy.getSegmenMemories(pmem);
            int prevSmemIndex = 0;
            int smemIndex = 0;
            int smemSplitAdjustAmount = 0;
            int nodeIndex = 0;
            int nodeTypesInSegment = 0;
            smems[smemIndex] = prevSmems[prevSmemIndex];
            do {
                node = nodes[nodeIndex++];
                LeftTupleSource parentNode = node.getLeftTupleSource();
                nodeTypesInSegment = BuildtimeSegmentUtilities.updateNodeTypesMask(parentNode, nodeTypesInSegment);
                if (!LazyPhreakBuilder.isSplit(parentNode)) continue;
                smemIndex = strategy.incSmemIndex1(smemIndex);
                prevSmemIndex = strategy.incPrevSmemIndex1(prevSmemIndex);
                if (LazyPhreakBuilder.isSplit(parentNode, tn)) {
                    smemIndex = strategy.incSmemIndex2(smemIndex);
                    prevSmemIndex = strategy.incPrevSmemIndex2(prevSmemIndex);
                    smems[smemIndex] = prevSmems[prevSmemIndex];
                    if (smems[smemIndex] != null && smemSplitAdjustAmount > 0 && visitedSegments.add(smems[smemIndex])) {
                        strategy.adjustSegment(wm, smemsToNotify, smems[smemIndex], smemSplitAdjustAmount);
                    }
                } else {
                    strategy.handleSplit(pmem, prevSmems, smems, smemIndex, prevSmemIndex, parentNode, node, tn, visitedNodes, smemsToNotify, nodeToSegmentMap, wm);
                    ++smemSplitAdjustAmount;
                }
                LazyPhreakBuilder.checkEagerSegmentCreation(parentNode, wm, nodeTypesInSegment);
                nodeTypesInSegment = 0;
            } while (!NodeTypeEnums.isEndNode((NetworkNode)node));
            strategy.processSegmentMemories(smems, pmem);
        }
        return smemsToNotify;
    }

    private static void addNewPaths(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, List<PathMemory> pmems) {
        HashSet<PathEndNode> visited = new HashSet<PathEndNode>();
        block0: for (PathMemory pmem : pmems) {
            PathEndNode tipNode;
            LeftTupleNode child = tipNode = pmem.getPathEndNode();
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                Memory mem;
                if (visited.add((PathEndNode)child)) {
                    SegmentMemory sm;
                    if (parent != null && parent.getAssociatedTerminalsSize() != 1 && child.getAssociatedTerminalsSize() == 1) {
                        mem = wm.getNodeMemories().peekNodeMemory(parent);
                        if (mem != null && mem.getSegmentMemory() != null) {
                            sm = mem.getSegmentMemory();
                            if (sm.getFirst() != null && sm.size() < parent.getSinkPropagator().size()) {
                                LeftTupleSink[] sinks = parent.getSinkPropagator().getSinks();
                                for (int i = sm.size(); i < sinks.length; ++i) {
                                    SegmentMemory childSmem = LazyPhreakBuilder.createChildSegment(wm, sinks[i]);
                                    sm.add(childSmem);
                                    pmem.setSegmentMemory(childSmem.getPos(), childSmem);
                                    smemsToNotify.add(childSmem);
                                }
                            }
                            LazyPhreakBuilder.correctMemoryOnSplitsChanged(parent, null, wm);
                        }
                    } else {
                        mem = wm.getNodeMemories().peekNodeMemory(child);
                        if (mem != null && (sm = mem.getSegmentMemory()) != null && !sm.getPathMemories().contains(pmem)) {
                            RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, sm);
                            sm.notifyRuleLinkSegment((ReteEvaluator)wm, pmem);
                        }
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null) {
                        mem.getSegmentMemory().notifyRuleLinkSegment((ReteEvaluator)wm, pmem);
                    }
                }
                if (parent == null) continue block0;
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static void removeNewPaths(InternalWorkingMemory wm, List<PathMemory> pmems) {
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        block0: for (PathMemory pmem : pmems) {
            PathEndNode tipNode;
            LeftTupleNode child = tipNode = pmem.getPathEndNode();
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                SegmentMemory sm;
                Memory mem;
                if (child.getAssociatedTerminalsSize() == 1 && NodeTypeEnums.isBetaNode((NetworkNode)child)) {
                    LazyPhreakBuilder.deleteRightInputData(child, wm);
                }
                if (parent != null && parent.getAssociatedTerminalsSize() != 1 && child.getAssociatedTerminalsSize() == 1) {
                    if (!visitedNodes.contains(child.getId()) && (mem = wm.getNodeMemories().peekNodeMemory(parent)) != null && mem.getSegmentMemory() != null && (sm = mem.getSegmentMemory()).getFirst() != null) {
                        SegmentMemory childSm = wm.getNodeMemories().peekNodeMemory(child).getSegmentMemory();
                        sm.remove(childSm);
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null && (sm = mem.getSegmentMemory()) != null && sm.getPathMemories().contains(pmem)) {
                        mem.getSegmentMemory().removePathMemory(pmem);
                    }
                }
                if (parent == null) continue block0;
                visitedNodes.add(child.getId());
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static boolean isSplit(LeftTupleNode node) {
        return LazyPhreakBuilder.isSplit(node, null);
    }

    private static boolean isSplit(LeftTupleNode node, TerminalNode removingTN) {
        return node != null && BuildtimeSegmentUtilities.isTipNode(node, removingTN);
    }

    public static void flushStagedTuples(TerminalNode tn, PathMemory pmem, List<LeftTupleNode> splits, InternalWorkingMemory wm) {
        if (pmem.isInitialized()) {
            RuleNetworkEvaluator.INSTANCE.evaluateNetwork(pmem, pmem.getRuleAgendaItem().getRuleExecutor(), wm);
        }
        ArrayList<Flushed> flushed = new ArrayList<Flushed>();
        for (LeftTupleNode node : splits) {
            SegmentMemory smem;
            Memory mem;
            if (LazyPhreakBuilder.isSplit(node, tn) || (mem = wm.getNodeMemories().peekNodeMemory(node)) == null || (smem = mem.getSegmentMemory()).isEmpty()) continue;
            for (SegmentMemory childSmem = (SegmentMemory)smem.getFirst(); childSmem != null; childSmem = childSmem.getNext()) {
                if (childSmem.getStagedLeftTuples().isEmpty()) continue;
                PathMemory childPmem = childSmem.getPathMemories().get(0);
                flushed.add(new Flushed(childSmem, childPmem));
                TupleEvaluationUtil.forceFlushLeftTuple(childPmem, childSmem, wm, childSmem.getStagedLeftTuples().takeAll());
            }
        }
        int flushCount = 1;
        while (!flushed.isEmpty() && flushCount != 0) {
            flushCount = 0;
            for (Flushed path : flushed) {
                if (path.segmentMemory.getStagedLeftTuples().isEmpty()) continue;
                ++flushCount;
                TupleEvaluationUtil.forceFlushLeftTuple(pmem, path.segmentMemory, wm, path.segmentMemory.getStagedLeftTuples().takeAll());
            }
        }
    }

    private static void flushStagedTuples(LeftTupleNode splitStartNode, PathMemory pmem, InternalWorkingMemory wm) {
        if (!pmem.isInitialized()) {
            return;
        }
        int smemIndex = LazyPhreakBuilder.getSegmentPos(splitStartNode);
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory sm = null;
        int length = smems.length;
        if (splitStartNode.getAssociatedTerminalsSize() == 1) {
            length = 1;
        }
        while (smemIndex < length && ((sm = smems[smemIndex]) == null || sm.getStagedLeftTuples().isEmpty())) {
            ++smemIndex;
        }
        if (smemIndex < length) {
            TupleEvaluationUtil.forceFlushLeftTuple(pmem, sm, wm, sm.getStagedLeftTuples().takeAll());
        }
    }

    private static Map<PathMemory, SegmentMemory[]> reInitPathMemories(List<PathMemory> pathMems, TerminalNode removingTN) {
        HashMap<PathMemory, SegmentMemory[]> previousSmems = new HashMap<PathMemory, SegmentMemory[]>();
        for (PathMemory pmem : pathMems) {
            previousSmems.put(pmem, pmem.getSegmentMemories());
            PathEndNode pathEndNode = pmem.getPathEndNode();
            pathEndNode.resetPathMemSpec(removingTN);
            AbstractTerminalNode.initPathMemory(pathEndNode, pmem);
        }
        return previousSmems;
    }

    private static void notifySegments(Set<SegmentMemory> smems, InternalWorkingMemory wm) {
        for (SegmentMemory sm : smems) {
            sm.notifyRuleLinkSegment(wm);
        }
    }

    private static void correctMemoryOnSplitsChanged(LeftTupleNode splitStart, TerminalNode removingTN, InternalWorkingMemory wm) {
        QueryElementNode.QueryElementNodeMemory mem;
        if (splitStart.getType() == 165 && (mem = (QueryElementNode.QueryElementNodeMemory)wm.getNodeMemories().peekNodeMemory(splitStart)) != null) {
            mem.correctMemoryOnSinksChanged(removingTN);
        }
    }

    public static void correctSegmentMemoryAfterSplitOnAdd(SegmentMemory sm) {
        LazyPhreakBuilder.correctSegmentMemoryAfterSplitOnAdd(sm, 1);
    }

    public static void correctSegmentMemoryAfterSplitOnAdd(SegmentMemory sm, int i) {
        sm.setPos(sm.getPos() + i);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() << i);
    }

    public static void correctSegmentMemoryAfterSplitOnRemove(SegmentMemory sm, int i) {
        sm.setPos(sm.getPos() - i);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() >> i);
    }

    private static int getSegmentPos(LeftTupleNode lts) {
        int counter = 0;
        while (lts.getType() != 120) {
            if (!BuildtimeSegmentUtilities.isTipNode(lts = lts.getLeftTupleSource(), null)) continue;
            ++counter;
        }
        return counter;
    }

    private static void insertLiaFacts(LeftTupleNode startNode, InternalWorkingMemory wm) {
        PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
        LeftInputAdapterNode.RightTupleSinkAdapter liaAdapter = new LeftInputAdapterNode.RightTupleSinkAdapter(lian);
        lian.getObjectSource().updateSink(liaAdapter, pctx, wm);
    }

    private static void insertFacts(PathEndNodes endNodes, Collection<InternalWorkingMemory> wms) {
        HashSet<LeftTupleNode> visited = new HashSet<LeftTupleNode>();
        for (PathEndNode endNode : endNodes.subjectEndNodes) {
            LeftTupleNode[] nodes = endNode.getPathNodes();
            for (int i = 0; i < nodes.length; ++i) {
                BetaNode bn;
                LeftTupleNode node = nodes[i];
                if (!NodeTypeEnums.isBetaNode((NetworkNode)node) || node.getAssociatedTerminalsSize() != 1 || !visited.add(node) || (bn = (BetaNode)node).isRightInputIsRiaNode()) continue;
                for (InternalWorkingMemory wm : wms) {
                    PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
                    PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
                    bn.getRightInput().updateSink(bn, pctx, wm);
                }
            }
        }
    }

    private static void deleteRightInputData(LeftTupleSink node, InternalWorkingMemory wm) {
        if (wm.getNodeMemories().peekNodeMemory(node) != null) {
            BetaNode bn = (BetaNode)node;
            BetaMemory bm = bn.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(bn)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(bn);
            TupleMemory rtm = bm.getRightTupleMemory();
            FastIterator<Tuple> it = rtm.fullFastIterator();
            Tuple rightTuple = BetaNode.getFirstTuple(rtm, it);
            while (rightTuple != null) {
                Tuple next = it.next(rightTuple);
                rtm.remove(rightTuple);
                rightTuple.unlinkFromRightParent();
                rightTuple = next;
            }
            if (!bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
            LazyPhreakBuilder.unlinkRightTuples(srcRightTuples.getInsertFirst());
            LazyPhreakBuilder.unlinkRightTuples(srcRightTuples.getUpdateFirst());
            LazyPhreakBuilder.unlinkRightTuples(srcRightTuples.getDeleteFirst());
            LazyPhreakBuilder.deleteFactsFromRightInput(bn, wm);
        }
    }

    private static void deleteFactsFromRightInput(BetaNode bn, InternalWorkingMemory wm) {
        ObjectSource source = bn.getRightInput();
        if (source instanceof WindowNode) {
            WindowNode.WindowMemory memory = wm.getNodeMemory((WindowNode)source);
            for (DefaultEventHandle factHandle : memory.getFactHandles()) {
                factHandle.forEachRightTuple(rt -> {
                    if (source.equals(rt.getTupleSink())) {
                        rt.unlinkFromRightParent();
                    }
                });
            }
        }
    }

    private static void unlinkRightTuples(RightTuple rightTuple) {
        RightTuple rt = rightTuple;
        while (rt != null) {
            RightTuple next = (RightTuple)rt.getStagedNext();
            if (rt.getFactHandle() != null) {
                rt.unlinkFromRightParent();
            }
            rt = next;
        }
    }

    private static void processLeftTuples(LeftTupleNode node, InternalWorkingMemory wm, boolean insert, Rule rule) {
        if (node instanceof AlphaTerminalNode) {
            LazyPhreakBuilder.processLeftTuplesOnLian(wm, insert, rule, (LeftInputAdapterNode)node);
            return;
        }
        Memory memory = wm.getNodeMemories().peekNodeMemory(node);
        if (memory == null || memory.getSegmentMemory() == null) {
            return;
        }
        SegmentMemory sm = memory.getSegmentMemory();
        while (120 != node.getType()) {
            if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
                if (211 == node.getType()) {
                    AccumulateNode.AccumulateMemory am = (AccumulateNode.AccumulateMemory)memory;
                    BetaMemory bm = am.getBetaMemory();
                    FastIterator<Tuple> it = bm.getLeftTupleMemory().fullFastIterator();
                    Tuple lt = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    while (lt != null) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)lt.getContextObject();
                        LazyPhreakBuilder.visitChild((LeftTuple)accctx.getResultLeftTuple(), insert, wm, rule);
                        lt = (LeftTuple)it.next(lt);
                    }
                } else if (201 == node.getType() && !node.isRightInputIsRiaNode()) {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator<Tuple> it = bm.getRightTupleMemory().fullFastIterator();
                    RightTuple rt = (RightTuple)BetaNode.getFirstTuple(bm.getRightTupleMemory(), it);
                    while (rt != null) {
                        for (LeftTuple lt = rt.getBlocked(); lt != null; lt = lt.getBlockedNext()) {
                            LazyPhreakBuilder.visitLeftTuple(wm, insert, rule, lt);
                        }
                        rt = (RightTuple)it.next(rt);
                    }
                } else {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator<Tuple> it = bm.getLeftTupleMemory().fullFastIterator();
                    LeftTuple lt = (LeftTuple)BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    while (lt != null) {
                        LazyPhreakBuilder.visitLeftTuple(wm, insert, rule, lt);
                        lt = (LeftTuple)it.next(lt);
                    }
                }
                return;
            }
            if (151 == node.getType()) {
                FromNode.FromMemory fm = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                TupleMemory ltm = fm.getBetaMemory().getLeftTupleMemory();
                FastIterator<Tuple> it = ltm.fullFastIterator();
                LeftTuple lt = (LeftTuple)ltm.getFirst(null);
                while (lt != null) {
                    LazyPhreakBuilder.visitChild(lt, insert, wm, rule);
                    lt = (LeftTuple)it.next(lt);
                }
                return;
            }
            if (sm.getRootNode() == node) {
                sm = wm.getNodeMemory((MemoryFactory)((Object)node.getLeftTupleSource())).getSegmentMemory();
            }
            node = node.getLeftTupleSource();
        }
        LazyPhreakBuilder.processLeftTuplesOnLian(wm, insert, rule, (LeftInputAdapterNode)node);
    }

    private static void processLeftTuplesOnLian(InternalWorkingMemory wm, boolean insert, Rule rule, LeftInputAdapterNode lian) {
        ObjectSource os = lian.getObjectSource();
        while (os.getType() != 30) {
            os = os.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        Iterator<InternalFactHandle> it = otn.getFactHandlesIterator(wm);
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            fh.forEachLeftTuple(lt -> {
                LeftTuple nextLt = lt.getHandleNext();
                if (lt.getTupleSource().isAssociatedWith(rule)) {
                    LazyPhreakBuilder.visitChild(lt, insert, wm, rule);
                    if (lt.getHandlePrevious() != null && nextLt != null) {
                        lt.getHandlePrevious().setHandleNext(nextLt);
                        nextLt.setHandlePrevious(lt.getHandlePrevious());
                    }
                }
            });
        }
    }

    private static void visitLeftTuple(InternalWorkingMemory wm, boolean insert, Rule rule, LeftTuple lt) {
        LeftTuple childLt = lt.getFirstChild();
        while (childLt != null) {
            LeftTuple nextLt = childLt.getHandleNext();
            LazyPhreakBuilder.visitChild(childLt, insert, wm, rule);
            childLt = nextLt;
        }
    }

    private static void visitChild(LeftTuple lt, boolean insert, InternalWorkingMemory wm, Rule rule) {
        LeftTuple prevLt = null;
        for (LeftTupleSinkNode sink = (LeftTupleSinkNode)lt.getTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            block4: {
                block5: {
                    block6: {
                        block7: {
                            if (lt == null) break block4;
                            if (!lt.getTupleSink().isAssociatedWith(rule)) break block5;
                            if (lt.getTupleSink().getAssociatedTerminalsSize() <= 1) break block6;
                            if (lt.getFirstChild() == null) break block7;
                            for (LeftTuple child = lt.getFirstChild(); child != null; child = child.getHandleNext()) {
                                LazyPhreakBuilder.visitChild(child, insert, wm, rule);
                            }
                            break block5;
                        }
                        if (lt.getTupleSink().getType() != 71) break block5;
                        LazyPhreakBuilder.insertPeerRightTuple(lt, wm, rule, insert);
                        break block5;
                    }
                    if (!insert) {
                        LazyPhreakBuilder.iterateLeftTuple(lt, wm);
                        LeftTuple lt2 = null;
                        for (LeftTuple peerLt = lt.getPeer(); peerLt != null && peerLt.getTupleSink().isAssociatedWith(rule) && peerLt.getTupleSink().getAssociatedTerminalsSize() == 1; peerLt = peerLt.getPeer()) {
                            LazyPhreakBuilder.iterateLeftTuple(peerLt, wm);
                            lt2 = peerLt;
                        }
                        EagerPhreakBuilder.deleteLeftTuple(lt, lt2, prevLt);
                        break;
                    }
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            prevLt = LazyPhreakBuilder.insertPeerLeftTuple(prevLt, sink, wm, insert);
        }
    }

    private static void insertPeerRightTuple(LeftTuple lt, InternalWorkingMemory wm, Rule rule, boolean insert) {
        LeftTuple prevLt = null;
        RightInputAdapterNode rian = (RightInputAdapterNode)lt.getTupleSink();
        for (ObjectSink sink : rian.getObjectSinkPropagator().getSinks()) {
            if (lt != null) {
                if (prevLt != null && !insert && sink.isAssociatedWith(rule) && sink.getAssociatedTerminalsSize() == 1) {
                    prevLt.setPeer(null);
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            if (!insert) continue;
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((BetaNode)sink);
            prevLt = rian.createPeer(prevLt);
            bm.linkNode((BetaNode)sink, wm);
            bm.getStagedRightTuples().addInsert((RightTuple)((Object)prevLt));
        }
    }

    private static LeftTuple insertPeerLeftTuple(LeftTuple lt, LeftTupleSinkNode node, InternalWorkingMemory wm, boolean insert) {
        Memory memory;
        LeftTuple peer = node.createPeer(lt);
        if (node.getLeftTupleSource() instanceof AlphaTerminalNode) {
            if (insert) {
                TerminalNode rtn = (TerminalNode)node;
                InternalAgenda agenda = wm.getAgenda();
                RuleAgendaItem agendaItem = AlphaTerminalNode.getRuleAgendaItem(wm, agenda, rtn, insert);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, agendaItem.getRuleExecutor(), agenda, agendaItem, (RuleTerminalNodeLeftTuple)peer);
            }
            return peer;
        }
        LeftInputAdapterNode.LiaNodeMemory liaMem = null;
        if (node.getLeftTupleSource().getType() == 120) {
            liaMem = wm.getNodeMemory((LeftInputAdapterNode)node.getLeftTupleSource());
        }
        if ((memory = wm.getNodeMemories().peekNodeMemory(node)) == null || memory.getSegmentMemory() == null) {
            throw new IllegalStateException("Defensive Programming: this should not be possilbe, as the addRule code should init child segments if they are needed ");
        }
        if (liaMem == null) {
            memory.getSegmentMemory().getStagedLeftTuples().addInsert(peer);
        } else {
            LeftInputAdapterNode.doInsertSegmentMemoryWithFlush(wm, true, liaMem, memory.getSegmentMemory(), peer, node.getLeftTupleSource().isStreamMode());
        }
        return peer;
    }

    private static void iterateLeftTuple(LeftTuple lt, InternalWorkingMemory wm) {
        if (NodeTypeEnums.isTerminalNode((NetworkNode)lt.getTupleSink())) {
            PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(lt.getTupleSink());
            if (pmem != null) {
                PhreakRuleTerminalNode.doLeftDelete(pmem.getActualActivationsManager(wm), pmem.getRuleAgendaItem().getRuleExecutor(), (RuleTerminalNodeLeftTuple)lt);
            }
        } else {
            LeftTuple resultLt;
            if (lt.getContextObject() instanceof AccumulateNode.AccumulateContext && (resultLt = (LeftTuple)((AccumulateNode.AccumulateContext)lt.getContextObject()).getResultLeftTuple()) != null) {
                LazyPhreakBuilder.iterateLeftTuple(resultLt, wm);
            }
            for (LeftTuple child = lt.getFirstChild(); child != null; child = child.getHandleNext()) {
                for (LeftTuple peer = child; peer != null; peer = peer.getPeer()) {
                    if (peer.getPeer() != null) continue;
                    LazyPhreakBuilder.iterateLeftTuple(peer, wm);
                }
            }
        }
    }

    private static LeftTupleNode getNetworkSplitPoint(LeftTupleNode node) {
        while (node.getType() != 120 && node.getAssociatedTerminalsSize() == 1) {
            node = node.getLeftTupleSource();
        }
        return node;
    }

    public static SegmentMemory splitSegment(InternalWorkingMemory wm, SegmentMemory sm1, LeftTupleNode splitNode) {
        LeftTupleSinkNode childNode = splitNode.getSinkPropagator().getFirstLeftTupleSink();
        SegmentMemory sm2 = new SegmentMemory(childNode);
        wm.getNodeMemories().peekNodeMemory(childNode).setSegmentMemory(sm2);
        if (sm1.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm1.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm1.remove(sm);
                sm2.add(sm);
                sm = next;
            }
        }
        sm1.add(sm2);
        sm2.setPos(sm1.getPos());
        sm2.setSegmentPosMaskBit(sm1.getSegmentPosMaskBit());
        sm2.setLinkedNodeMask(sm1.getLinkedNodeMask());
        sm2.mergePathMemories(sm1);
        sm2.setTipNode(sm1.getTipNode());
        sm1.setTipNode(splitNode);
        if (sm1.getTipNode().getType() == 120 && !sm1.getStagedLeftTuples().isEmpty()) {
            sm2.getStagedLeftTuples().addAll(sm1.getStagedLeftTuples());
        }
        int pos = LazyPhreakBuilder.nodeSegmentPosition(sm1, splitNode);
        LazyPhreakBuilder.splitNodeMemories(sm1, sm2, pos);
        LazyPhreakBuilder.splitBitMasks(sm1, sm2, pos);
        LazyPhreakBuilder.correctSegmentMemoryAfterSplitOnAdd(sm2);
        return sm2;
    }

    private static void mergeSegment(SegmentMemory sm1, SegmentMemory sm2) {
        if (sm1.getTipNode().getType() == 120 && !sm2.getStagedLeftTuples().isEmpty()) {
            sm1.getStagedLeftTuples().addAll(sm2.getStagedLeftTuples());
        }
        if (sm1.contains(sm2)) {
            sm1.remove(sm2);
        }
        if (sm2.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm2.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm2.remove(sm);
                sm1.add(sm);
                sm = next;
            }
        }
        sm1.setTipNode(sm2.getTipNode());
        LazyPhreakBuilder.mergeNodeMemories(sm1, sm2);
        LazyPhreakBuilder.mergeBitMasks(sm1, sm2);
    }

    private static void splitBitMasks(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        int splitPos = pos + 1;
        long currentAllLinkedMaskTest = sm1.getAllLinkedMaskTest();
        long currentLinkedNodeMask = sm1.getLinkedNodeMask();
        long mask = (1L << splitPos) - 1L;
        sm1.setAllLinkedMaskTest(mask & currentAllLinkedMaskTest);
        sm1.setLinkedNodeMask(sm1.getLinkedNodeMask() & sm1.getAllLinkedMaskTest());
        mask = currentAllLinkedMaskTest >> splitPos;
        sm2.setAllLinkedMaskTest(mask);
        sm2.setLinkedNodeMask(mask & currentLinkedNodeMask >> splitPos);
    }

    private static void mergeBitMasks(SegmentMemory sm1, SegmentMemory sm2) {
        Memory[] smNodeMemories2 = sm2.getNodeMemories();
        long mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.length;
        sm1.setAllLinkedMaskTest(mask & sm1.getAllLinkedMaskTest());
        mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.length;
        sm1.setLinkedNodeMask(mask & sm1.getLinkedNodeMask());
    }

    private static void splitNodeMemories(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        ArrayList<Memory> smNodeMemories1 = new ArrayList<Memory>(Arrays.asList(sm1.getNodeMemories()));
        ArrayList<Memory> smNodeMemories2 = new ArrayList<Memory>();
        Memory mem = (Memory)smNodeMemories1.get(0);
        long nodePosMask = 1L;
        int length = smNodeMemories1.size();
        for (int i = 0; i < length; ++i) {
            Memory next = (Memory)mem.getNext();
            if (i > pos) {
                smNodeMemories1.remove(mem);
                LazyPhreakBuilder.addToMemoryList(smNodeMemories2, mem);
                mem.setSegmentMemory(sm2);
                if (mem instanceof SegmentNodeMemory) {
                    ((SegmentNodeMemory)mem).setNodePosMaskBit(nodePosMask);
                }
                nodePosMask = BuildtimeSegmentUtilities.nextNodePosMask(nodePosMask);
            }
            mem = next;
        }
        sm1.setNodeMemories(smNodeMemories1.toArray(new Memory[smNodeMemories1.size()]));
        sm2.setNodeMemories(smNodeMemories2.toArray(new Memory[smNodeMemories2.size()]));
    }

    private static void mergeNodeMemories(SegmentMemory sm1, SegmentMemory sm2) {
        ArrayList<Memory> mergedMemories = new ArrayList<Memory>();
        int nodePosMask = 1;
        for (Memory mem : sm1.getNodeMemories()) {
            nodePosMask >>= 1;
            mergedMemories.add(mem);
        }
        for (Memory mem : sm2.getNodeMemories()) {
            LazyPhreakBuilder.addToMemoryList(mergedMemories, mem);
            mem.setSegmentMemory(sm1);
            if (mem instanceof SegmentNodeMemory) {
                ((SegmentNodeMemory)mem).setNodePosMaskBit(nodePosMask);
            }
            nodePosMask >>= 1;
        }
        sm1.setNodeMemories(mergedMemories.toArray(new Memory[mergedMemories.size()]));
    }

    private static void addToMemoryList(List<Memory> smNodeMemories, Memory mem) {
        if (!smNodeMemories.isEmpty()) {
            Memory last = smNodeMemories.get(smNodeMemories.size() - 1);
            last.setNext(mem);
            mem.setPrevious(last);
        }
        smNodeMemories.add(mem);
    }

    private static int nodeSegmentPosition(SegmentMemory sm1, LeftTupleNode splitNode) {
        LeftTupleNode lt = splitNode;
        int nodePos = 0;
        while (lt != sm1.getRootNode()) {
            lt = lt.getLeftTupleSource();
            ++nodePos;
        }
        return nodePos;
    }

    private static PathEndNodeMemories getPathEndMemories(InternalWorkingMemory wm, PathEndNodes pathEndNodes) {
        PathMemory pmem;
        RightInputAdapterNode.RiaPathMemory riaMem;
        PathEndNodeMemories tnMems = new PathEndNodeMemories();
        for (LeftTupleNode leftTupleNode : pathEndNodes.otherEndNodes) {
            if (leftTupleNode.getType() == 71) {
                riaMem = (RightInputAdapterNode.RiaPathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
                if (riaMem == null) continue;
                tnMems.otherPmems.add(riaMem);
                continue;
            }
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
            if (pmem == null) continue;
            tnMems.otherPmems.add(pmem);
        }
        tnMems.subjectPmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(pathEndNodes.subjectEndNode);
        if (tnMems.subjectPmem == null && !tnMems.otherPmems.isEmpty()) {
            tnMems.subjectPmem = wm.getNodeMemory(pathEndNodes.subjectEndNode);
        }
        for (LeftTupleNode leftTupleNode : pathEndNodes.subjectEndNodes) {
            if (leftTupleNode.getType() == 71) {
                riaMem = (RightInputAdapterNode.RiaPathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
                if (riaMem == null && !tnMems.otherPmems.isEmpty()) {
                    riaMem = (RightInputAdapterNode.RiaPathMemory)wm.getNodeMemory((MemoryFactory)((Object)leftTupleNode));
                }
                if (riaMem == null) continue;
                tnMems.subjectPmems.add(riaMem);
                continue;
            }
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
            if (pmem == null) continue;
            tnMems.subjectPmems.add(pmem);
        }
        return tnMems;
    }

    private static PathEndNodes getPathEndNodes(InternalRuleBase kBase, LeftTupleNode lt, TerminalNode tn, Rule processedRule, boolean hasProtos, boolean hasWms) {
        PathEndNodes endNodes = new PathEndNodes();
        endNodes.subjectEndNode = tn;
        endNodes.subjectEndNodes.add(tn);
        if (hasWms && BuildtimeSegmentUtilities.isTipNode(lt, null)) {
            endNodes.subjectSplit = lt;
            endNodes.subjectSplits.add(lt);
        }
        if (hasProtos) {
            LazyPhreakBuilder.invalidateRootNode(kBase, lt);
        }
        LazyPhreakBuilder.collectPathEndNodes(kBase, lt, endNodes, tn, processedRule, hasProtos, hasWms, hasProtos && LazyPhreakBuilder.isSplit(lt));
        return endNodes;
    }

    private static void collectPathEndNodes(InternalRuleBase kBase, LeftTupleNode lt, PathEndNodes endNodes, TerminalNode tn, Rule processedRule, boolean hasProtos, boolean hasWms, boolean isBelowNewSplit) {
        for (LeftTupleSinkNode sink = lt.getSinkPropagator().getLastLeftTupleSink(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            if (sink == tn) continue;
            if (hasProtos) {
                if (isBelowNewSplit) {
                    if (BuildtimeSegmentUtilities.isRootNode(sink, null)) {
                        kBase.invalidateSegmentPrototype(sink);
                    }
                } else {
                    isBelowNewSplit = LazyPhreakBuilder.isSplit(sink);
                    if (isBelowNewSplit) {
                        LazyPhreakBuilder.invalidateRootNode(kBase, sink);
                    }
                }
            }
            if (NodeTypeEnums.isLeftTupleSource((NetworkNode)sink)) {
                if (hasWms && BuildtimeSegmentUtilities.isTipNode(sink, null) && !BuildtimeSegmentUtilities.isTipNode(sink, tn)) {
                    endNodes.subjectSplits.add(sink);
                }
                LazyPhreakBuilder.collectPathEndNodes(kBase, sink, endNodes, tn, processedRule, hasProtos, hasWms, isBelowNewSplit);
                continue;
            }
            if (NodeTypeEnums.isTerminalNode((NetworkNode)sink)) {
                endNodes.otherEndNodes.add((PathEndNode)sink);
                continue;
            }
            if (71 == sink.getType()) {
                if (sink.isAssociatedWith(processedRule)) {
                    endNodes.subjectEndNodes.add((PathEndNode)sink);
                }
                if (sink.getAssociatedTerminalsSize() <= 1 && sink.isAssociatedWith(processedRule)) continue;
                endNodes.otherEndNodes.add((PathEndNode)sink);
                continue;
            }
            throw new RuntimeException("Error: Unknown Node. Defensive programming test..");
        }
    }

    private static void invalidateRootNode(InternalRuleBase kBase, LeftTupleNode lt) {
        while (!BuildtimeSegmentUtilities.isRootNode(lt, null)) {
            lt = lt.getLeftTupleSource();
        }
        kBase.invalidateSegmentPrototype(lt);
    }

    static SegmentMemory createChildSegment(ReteEvaluator reteEvaluator, LeftTupleNode node) {
        Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node));
        if (memory.getSegmentMemory() == null) {
            if (NodeTypeEnums.isEndNode((NetworkNode)node)) {
                LazyPhreakBuilder.createChildSegmentForTerminalNode(node, memory);
            } else {
                LazyPhreakBuilder.createSegmentMemory((LeftTupleSource)node, reteEvaluator);
            }
        }
        return memory.getSegmentMemory();
    }

    static SegmentMemory createSegmentMemory(ReteEvaluator reteEvaluator, LeftTupleNode segmentRoot) {
        if (NodeTypeEnums.isTerminalNode((NetworkNode)segmentRoot)) {
            Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)segmentRoot));
            return LazyPhreakBuilder.createChildSegmentForTerminalNode(segmentRoot, memory);
        }
        return LazyPhreakBuilder.createSegmentMemory((LeftTupleSource)segmentRoot, reteEvaluator);
    }

    private static SegmentMemory createChildSegmentForTerminalNode(LeftTupleNode node, Memory memory) {
        SegmentMemory childSmem = new SegmentMemory(node);
        PathMemory pmem = (PathMemory)memory;
        childSmem.setPos(pmem.getSegmentMemories().length - 1);
        pmem.setSegmentMemory(childSmem);
        RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, childSmem);
        childSmem.setTipNode(node);
        childSmem.setNodeMemories(new Memory[]{memory});
        return childSmem;
    }

    private static SegmentMemory createSegmentMemory(LeftTupleSource segmentRoot, ReteEvaluator reteEvaluator) {
        ArrayList<Memory> memories;
        int nodeTypesInSegment;
        long allLinkedTestMask;
        SegmentMemory smem;
        LeftTupleSource tupleSource;
        block23: {
            block22: {
                LeftTupleSinkNode sink;
                tupleSource = segmentRoot;
                smem = new SegmentMemory(segmentRoot);
                long nodePosMask = 1L;
                allLinkedTestMask = 0L;
                boolean updateNodeBit = true;
                nodeTypesInSegment = 0;
                memories = new ArrayList<Memory>();
                while (true) {
                    nodeTypesInSegment = BuildtimeSegmentUtilities.updateNodeTypesMask(tupleSource, nodeTypesInSegment);
                    if (NodeTypeEnums.isBetaNode((NetworkNode)tupleSource)) {
                        allLinkedTestMask = LazyPhreakBuilder.processBetaNode((BetaNode)tupleSource, reteEvaluator, smem, memories, nodePosMask, allLinkedTestMask, updateNodeBit);
                    } else {
                        switch (tupleSource.getType()) {
                            case 120: {
                                allLinkedTestMask = LazyPhreakBuilder.processLiaNode((LeftInputAdapterNode)tupleSource, reteEvaluator, smem, memories, nodePosMask, allLinkedTestMask);
                                break;
                            }
                            case 131: {
                                LazyPhreakBuilder.processEvalNode((EvalConditionNode)tupleSource, reteEvaluator, smem, memories);
                                break;
                            }
                            case 167: {
                                updateNodeBit = LazyPhreakBuilder.processBranchNode((ConditionalBranchNode)tupleSource, reteEvaluator, smem, memories);
                                break;
                            }
                            case 151: {
                                LazyPhreakBuilder.processFromNode((FromNode)tupleSource, reteEvaluator, smem, memories);
                                break;
                            }
                            case 153: {
                                LazyPhreakBuilder.processReactiveFromNode((MemoryFactory)((Object)tupleSource), reteEvaluator, smem, memories, nodePosMask);
                                break;
                            }
                            case 133: {
                                LazyPhreakBuilder.processTimerNode((TimerNode)tupleSource, reteEvaluator, smem, memories, nodePosMask);
                                break;
                            }
                            case 135: {
                                LazyPhreakBuilder.processAsyncSendNode((AsyncSendNode)tupleSource, reteEvaluator, smem, memories);
                                break;
                            }
                            case 137: {
                                LazyPhreakBuilder.processAsyncReceiveNode((AsyncReceiveNode)tupleSource, reteEvaluator, smem, memories, nodePosMask);
                                break;
                            }
                            case 165: {
                                updateNodeBit = LazyPhreakBuilder.processQueryNode((QueryElementNode)tupleSource, reteEvaluator, segmentRoot, smem, memories, nodePosMask);
                            }
                        }
                    }
                    nodePosMask = BuildtimeSegmentUtilities.nextNodePosMask(nodePosMask);
                    if (tupleSource.getSinkPropagator().size() != 1) break block22;
                    sink = tupleSource.getSinkPropagator().getFirstLeftTupleSink();
                    if (!NodeTypeEnums.isLeftTupleSource((NetworkNode)sink)) break;
                    tupleSource = (LeftTupleSource)((Object)sink);
                }
                Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)sink));
                if (sink.getType() == 71) {
                    ObjectSink[] nodes;
                    RightInputAdapterNode.RiaPathMemory riaPmem = (RightInputAdapterNode.RiaPathMemory)memory;
                    memories.add(riaPmem);
                    RightInputAdapterNode rian = (RightInputAdapterNode)sink;
                    for (ObjectSink node : nodes = rian.getObjectSinkPropagator().getSinks()) {
                        if (!NodeTypeEnums.isLeftTupleSource((NetworkNode)node)) continue;
                        RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)((Object)node), reteEvaluator);
                    }
                } else if (NodeTypeEnums.isTerminalNode((NetworkNode)sink)) {
                    memories.add((Memory)memory);
                }
                memory.setSegmentMemory(smem);
                smem.setTipNode(sink);
                break block23;
            }
            smem.setTipNode(tupleSource);
        }
        smem.setAllLinkedMaskTest(allLinkedTestMask);
        smem.setNodeMemories(memories.toArray(new Memory[memories.size()]));
        Memory lastMem = null;
        for (Memory mem : memories) {
            if (lastMem != null) {
                mem.setPrevious(lastMem);
                lastMem.setNext(mem);
            }
            lastMem = mem;
        }
        LeftTupleSource pathRoot = segmentRoot;
        int ruleSegmentPosMask = 1;
        int counter = 0;
        while (pathRoot.getType() != 120) {
            LeftTupleSource leftTupleSource = pathRoot.getLeftTupleSource();
            if (BuildtimeSegmentUtilities.isNonTerminalTipNode(leftTupleSource, null)) {
                ruleSegmentPosMask <<= 1;
                ++counter;
            }
            pathRoot = leftTupleSource;
        }
        smem.setSegmentPosMaskBit(ruleSegmentPosMask);
        smem.setPos(counter);
        LazyPhreakBuilder.updateRiaAndTerminalMemory(tupleSource, tupleSource, smem, reteEvaluator, false, nodeTypesInSegment);
        reteEvaluator.getKnowledgeBase().registerSegmentPrototype(segmentRoot, smem.getSegmentPrototype().initFromSegmentMemory(smem));
        return smem;
    }

    private static boolean processQueryNode(QueryElementNode queryNode, ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, SegmentMemory smem, List<Memory> memories, long nodePosMask) {
        SegmentMemory querySmem = RuntimeSegmentUtilities.getQuerySegmentMemory(reteEvaluator, queryNode);
        QueryElementNode.QueryElementNodeMemory queryNodeMem = smem.createNodeMemory(queryNode, reteEvaluator);
        queryNodeMem.setNodePosMaskBit(nodePosMask);
        queryNodeMem.setQuerySegmentMemory(querySmem);
        queryNodeMem.setSegmentMemory(smem);
        memories.add(queryNodeMem);
        return !queryNode.getQueryElement().isAbductive();
    }

    private static void processFromNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories) {
        Object mem = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add((Memory)mem);
        mem.setSegmentMemory(smem);
    }

    private static void processAsyncSendNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories) {
        Object mem = smem.createNodeMemory(tupleSource, reteEvaluator);
        mem.setSegmentMemory(smem);
        memories.add((Memory)mem);
    }

    private static void processAsyncReceiveNode(AsyncReceiveNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories, long nodePosMask) {
        AsyncReceiveNode.AsyncReceiveMemory tnMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(tnMem);
        tnMem.setNodePosMaskBit(nodePosMask);
        tnMem.setSegmentMemory(smem);
    }

    private static void processReactiveFromNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories, long nodePosMask) {
        FromNode.FromMemory mem = (FromNode.FromMemory)smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(mem);
        mem.setSegmentMemory(smem);
        mem.setNodePosMaskBit(nodePosMask);
    }

    private static boolean processBranchNode(ConditionalBranchNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories) {
        ConditionalBranchNode.ConditionalBranchMemory branchMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(branchMem);
        branchMem.setSegmentMemory(smem);
        return false;
    }

    private static void processEvalNode(EvalConditionNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories) {
        EvalConditionNode.EvalMemory evalMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(evalMem);
        evalMem.setSegmentMemory(smem);
    }

    private static void processTimerNode(TimerNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories, long nodePosMask) {
        TimerNode.TimerNodeMemory tnMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(tnMem);
        tnMem.setNodePosMaskBit(nodePosMask);
        tnMem.setSegmentMemory(smem);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories, long nodePosMask, long allLinkedTestMask) {
        LeftInputAdapterNode.LiaNodeMemory liaMemory = smem.createNodeMemory(tupleSource, reteEvaluator);
        memories.add(liaMemory);
        liaMemory.setSegmentMemory(smem);
        liaMemory.setNodePosMaskBit(nodePosMask);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(BetaNode betaNode, ReteEvaluator reteEvaluator, SegmentMemory smem, List<Memory> memories, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit) {
        BetaMemory bm;
        if (211 == betaNode.getType()) {
            AccumulateNode.AccumulateMemory accMemory = (AccumulateNode.AccumulateMemory)smem.createNodeMemory(betaNode, reteEvaluator);
            memories.add(accMemory);
            accMemory.setSegmentMemory(smem);
            bm = accMemory.getBetaMemory();
        } else {
            bm = (BetaMemory)smem.createNodeMemory(betaNode, reteEvaluator);
            memories.add(bm);
        }
        bm.setSegmentMemory(smem);
        bm.setSegmentMemory(smem);
        if (betaNode.isRightInputIsRiaNode()) {
            RightInputAdapterNode riaNode = RuntimeSegmentUtilities.createRiaSegmentMemory(betaNode, reteEvaluator);
            PathMemory riaMem = reteEvaluator.getNodeMemory(riaNode);
            bm.setRiaRuleMemory((RightInputAdapterNode.RiaPathMemory)riaMem);
            if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode) && riaMem.getAllLinkedMaskTest() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode)) {
            allLinkedTestMask |= nodePosMask;
        }
        bm.setNodePosMaskBit(nodePosMask);
        if (191 == betaNode.getType()) {
            smem.linkNodeWithoutRuleNotify(bm.getNodePosMaskBit());
        }
        return allLinkedTestMask;
    }

    private static int updateRiaAndTerminalMemory(LeftTupleSource lt, LeftTupleSource originalLt, SegmentMemory smem, ReteEvaluator reteEvaluator, boolean fromPrototype, int nodeTypesInSegment) {
        nodeTypesInSegment = LazyPhreakBuilder.checkSegmentBoundary(lt, reteEvaluator, nodeTypesInSegment);
        PathMemory pmem = null;
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (NodeTypeEnums.isLeftTupleSource((NetworkNode)sink)) {
                nodeTypesInSegment = LazyPhreakBuilder.updateRiaAndTerminalMemory((LeftTupleSource)((Object)sink), originalLt, smem, reteEvaluator, fromPrototype, nodeTypesInSegment);
            } else if (sink.getType() == 71) {
                RightInputAdapterNode.RiaPathMemory riaMem = (RightInputAdapterNode.RiaPathMemory)reteEvaluator.getNodeMemory((MemoryFactory)((Object)sink));
                if (LazyPhreakBuilder.inSubNetwork((RightInputAdapterNode)sink, originalLt)) {
                    ObjectSink[] nodes;
                    pmem = riaMem;
                    if (fromPrototype) {
                        for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                            if (!NodeTypeEnums.isLeftTupleSource((NetworkNode)node) || reteEvaluator.getNodeMemory((MemoryFactory)((Object)node)).getSegmentMemory() != null) continue;
                            LazyPhreakBuilder.restoreSegmentFromPrototype(reteEvaluator, (LeftTupleSource)((Object)node), nodeTypesInSegment);
                        }
                    } else if ((pmem.getAllLinkedMaskTest() & 1L << pmem.getSegmentMemories().length) == 0L) {
                        for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                            if (!NodeTypeEnums.isLeftTupleSource((NetworkNode)node)) continue;
                            RuntimeSegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)((Object)node), reteEvaluator);
                        }
                    }
                }
            } else if (NodeTypeEnums.isTerminalNode((NetworkNode)sink)) {
                pmem = reteEvaluator.getNodeMemory((AbstractTerminalNode)sink);
            }
            if (pmem == null || smem.getPos() >= pmem.getSegmentMemories().length) continue;
            RuntimeSegmentUtilities.addSegmentToPathMemory(pmem, smem);
            if (smem.isSegmentLinked()) {
                smem.notifyRuleLinkSegment(reteEvaluator);
            }
            LazyPhreakBuilder.checkEagerSegmentCreation(sink.getLeftTupleSource(), reteEvaluator, nodeTypesInSegment);
            pmem = null;
        }
        return nodeTypesInSegment;
    }

    private static void restoreSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, int nodeTypesInSegment) {
        SegmentMemory smem = reteEvaluator.getKnowledgeBase().createSegmentFromPrototype(reteEvaluator, segmentRoot);
        if (smem != null) {
            LazyPhreakBuilder.updateRiaAndTerminalMemory(segmentRoot, segmentRoot, smem, reteEvaluator, true, nodeTypesInSegment);
        }
    }

    private static int checkSegmentBoundary(LeftTupleSource lt, ReteEvaluator reteEvaluator, int nodeTypesInSegment) {
        if (BuildtimeSegmentUtilities.isRootNode(lt, null)) {
            LazyPhreakBuilder.checkEagerSegmentCreation(lt.getLeftTupleSource(), reteEvaluator, nodeTypesInSegment);
            nodeTypesInSegment = 0;
        }
        return BuildtimeSegmentUtilities.updateNodeTypesMask(lt, nodeTypesInSegment);
    }

    private static boolean inSubNetwork(RightInputAdapterNode riaNode, LeftTupleSource leftTupleSource) {
        LeftTupleSource startTupleSource = riaNode.getStartTupleSource().getLeftTupleSource();
        for (LeftTupleSource current = riaNode.getLeftTupleSource(); current != startTupleSource; current = current.getLeftTupleSource()) {
            if (current != leftTupleSource) continue;
            return true;
        }
        return false;
    }

    public static void checkEagerSegmentCreation(LeftTupleSource lt, ReteEvaluator reteEvaluator, int nodeTypesInSegment) {
        if (BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 1) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 2) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 4)) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory(lt, reteEvaluator);
        }
    }

    private static class PathEndNodes {
        PathEndNode subjectEndNode;
        LeftTupleNode subjectSplit;
        List<PathEndNode> subjectEndNodes = new ArrayList<PathEndNode>();
        List<LeftTupleNode> subjectSplits = new ArrayList<LeftTupleNode>();
        List<PathEndNode> otherEndNodes = new ArrayList<PathEndNode>();

        private PathEndNodes() {
        }
    }

    private static class PathEndNodeMemories {
        PathMemory subjectPmem;
        List<PathMemory> subjectPmems = new ArrayList<PathMemory>();
        List<PathMemory> otherPmems = new ArrayList<PathMemory>();

        private PathEndNodeMemories() {
        }
    }

    public static class Flushed {
        SegmentMemory segmentMemory;
        PathMemory pathMemory;

        public Flushed(SegmentMemory segmentMemory, PathMemory pathMemory) {
            this.segmentMemory = segmentMemory;
            this.pathMemory = pathMemory;
        }
    }

    public static class RemoveExistingPaths
    implements ExistingPathStrategy {
        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return new SegmentMemory[pmem.getSegmentMemories().length];
        }

        @Override
        public void adjustSegment(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, SegmentMemory smem, int smemSplitAdjustAmount) {
            smemsToNotify.add(smem);
            smem.unlinkSegment(wm);
            LazyPhreakBuilder.correctSegmentMemoryAfterSplitOnRemove(smem, smemSplitAdjustAmount);
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<LeftTupleNode> visited, Set<SegmentMemory> smemsToNotify, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (visited.contains(node)) {
                return;
            }
            LazyPhreakBuilder.correctMemoryOnSplitsChanged(parentNode, tn, wm);
            SegmentMemory sm1 = smems[smemIndex];
            SegmentMemory sm2 = prevSmems[prevSmemIndex];
            if (sm1 != null || sm2 != null) {
                LeftTupleSource removedTerminalSource = tn.getLeftTupleSource();
                removedTerminalSource.removeTupleSink(tn);
                if (sm1 == null) {
                    smems[smemIndex] = sm1 = LazyPhreakBuilder.createChildSegment(wm, parentNode);
                    sm1.add(sm2);
                } else if (sm2 == null) {
                    prevSmems[prevSmemIndex] = sm2 = LazyPhreakBuilder.createChildSegment(wm, node);
                    sm1.add(sm2);
                }
                LazyPhreakBuilder.mergeSegment(sm1, sm2);
                smemsToNotify.add(sm1);
                sm1.unlinkSegment(wm);
                sm2.unlinkSegment(wm);
                visited.add(node);
                removedTerminalSource.addTupleSink(tn);
            }
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
            for (int i = 0; i < smems.length; ++i) {
                if (smems[i] == null) continue;
                pmem.setSegmentMemory(smems[i].getPos(), smems[i]);
            }
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex;
        }
    }

    public static class AddExistingPaths
    implements ExistingPathStrategy {
        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return pmem.getSegmentMemories();
        }

        @Override
        public void adjustSegment(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, SegmentMemory smem, int smemSplitAdjustAmount) {
            smemsToNotify.add(smem);
            smem.unlinkSegment(wm);
            LazyPhreakBuilder.correctSegmentMemoryAfterSplitOnAdd(smem, smemSplitAdjustAmount);
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<LeftTupleNode> visited, Set<SegmentMemory> smemsToNotify, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (smems[smemIndex - 1] != null) {
                SegmentMemory sm2 = nodeToSegmentMap.get(node);
                if (sm2 == null) {
                    SegmentMemory sm1 = smems[smemIndex - 1];
                    LazyPhreakBuilder.correctMemoryOnSplitsChanged(parentNode, null, wm);
                    sm2 = LazyPhreakBuilder.splitSegment(wm, sm1, parentNode);
                    nodeToSegmentMap.put(node, sm2);
                    smemsToNotify.add(sm1);
                    smemsToNotify.add(sm2);
                }
                smems[smemIndex] = sm2;
            }
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }
    }

    public static interface ExistingPathStrategy {
        public static final ExistingPathStrategy ADD_STRATEGY = new AddExistingPaths();
        public static final ExistingPathStrategy REMOVE_STRATEGY = new RemoveExistingPaths();

        public SegmentMemory[] getSegmenMemories(PathMemory var1);

        public void adjustSegment(InternalWorkingMemory var1, Set<SegmentMemory> var2, SegmentMemory var3, int var4);

        public void handleSplit(PathMemory var1, SegmentMemory[] var2, SegmentMemory[] var3, int var4, int var5, LeftTupleNode var6, LeftTupleNode var7, TerminalNode var8, Set<LeftTupleNode> var9, Set<SegmentMemory> var10, Map<LeftTupleNode, SegmentMemory> var11, InternalWorkingMemory var12);

        public void processSegmentMemories(SegmentMemory[] var1, PathMemory var2);

        public int incSmemIndex1(int var1);

        public int incSmemIndex2(int var1);

        public int incPrevSmemIndex1(int var1);

        public int incPrevSmemIndex2(int var1);
    }
}

