/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TreeItem;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.rpc.AnalysisFactUsage;
import org.drools.guvnor.client.rpc.AnalysisFieldUsage;

class FactUsagesItem
extends TreeItem {
    public FactUsagesItem(AnalysisFactUsage[] factUsages) {
        this.setStyleName("analysis-Report");
        this.setHTML(this.createImageTag(DroolsGuvnorImageResources.INSTANCE.factTemplate()) + "<b>" + Constants.INSTANCE.ShowFactUsages() + "</b>");
        this.setUserObject((Object)(this.createImageTag(DroolsGuvnorImageResources.INSTANCE.factTemplate()) + "<b>" + Constants.INSTANCE.FactUsages() + ":</b>"));
        this.doFacts(factUsages);
    }

    private void doFacts(AnalysisFactUsage[] factUsages) {
        for (AnalysisFactUsage factUsage : factUsages) {
            TreeItem fact = new TreeItem(this.createImageTag(DroolsGuvnorImageResources.INSTANCE.fact()) + factUsage.name);
            TreeItem fieldList = this.doFields(factUsage.fields);
            fact.addItem(fieldList);
            fieldList.setState(true);
            this.addItem(fact);
            fact.setState(true);
        }
    }

    private TreeItem doFields(AnalysisFieldUsage[] fields) {
        TreeItem fieldList = new TreeItem(Constants.INSTANCE.FieldsUsed());
        for (AnalysisFieldUsage fieldUsage : fields) {
            TreeItem field = new TreeItem(this.createImageTag(DroolsGuvnorImageResources.INSTANCE.field()) + fieldUsage.name);
            fieldList.addItem(field);
            TreeItem ruleList = this.doAffectedRules(fieldUsage);
            field.addItem(ruleList);
            field.setState(true);
        }
        return fieldList;
    }

    private TreeItem doAffectedRules(AnalysisFieldUsage fieldUsage) {
        TreeItem ruleList = new TreeItem(Constants.INSTANCE.ShowRulesAffected());
        ruleList.setUserObject((Object)new HTML(Constants.INSTANCE.RulesAffected()));
        for (String ruleName : fieldUsage.rules) {
            ruleList.addItem(new TreeItem(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImageResources.INSTANCE.ruleAsset()).getHTML() + ruleName));
        }
        return ruleList;
    }

    private String createImageTag(ImageResource imageResource) {
        return "<img src=\"" + imageResource.getURL() + "\" alt=\"\"/>";
    }
}

