/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.AddFieldToFactClickHandler;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.AddFieldToFactDataClickHandler;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.CollectionFieldDataConstraintEditor;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FactAssignmentFieldWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FactDataWidgetFactory;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldConstraintHelper;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldDataConstraintEditor;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldNameWidgetImpl;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldSelectorWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioParentWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.CollectionFieldData;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.FactAssignmentField;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.FieldPlaceHolder;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class FactDataWidgetFactory {
    private final DirtyableFlexTable widget;
    private final Scenario scenario;
    private final SuggestionCompletionEngine suggestionCompletionEngine;
    private final FixtureList definitionList;
    private final ExecutionTrace executionTrace;
    private final RowIndexByFieldName rowIndexByFieldName = new RowIndexByFieldName(this);
    private int col = 0;
    private final ScenarioParentWidget parent;

    public FactDataWidgetFactory(Scenario scenario, SuggestionCompletionEngine suggestionCompletionEngine, FixtureList definitionList, ExecutionTrace executionTrace, ScenarioParentWidget parent, DirtyableFlexTable widget) {
        this.scenario = scenario;
        this.suggestionCompletionEngine = suggestionCompletionEngine;
        this.definitionList = definitionList;
        this.executionTrace = executionTrace;
        this.parent = parent;
        this.widget = widget;
    }

    public void build(String headerText, Fact fact) {
        if (fact instanceof FactData) {
            FactData factData = (FactData)fact;
            this.widget.setWidget(0, ++this.col, (Widget)new SmallLabel("[" + factData.getName() + "]"));
        } else {
            ++this.col;
        }
        this.widget.setWidget(0, 0, (Widget)new ClickableLabel(headerText, this.createAddFieldButton(fact)));
        HashMap<FieldData, FieldDataConstraintEditor> enumEditorMap = new HashMap<FieldData, FieldDataConstraintEditor>();
        for (Field field : fact.getFieldData()) {
            FieldData fieldData;
            if (this.rowIndexByFieldName.doesNotContain(field.getName())) {
                this.newRow(fact, field.getName());
            }
            int fieldRowIndex = this.rowIndexByFieldName.getRowIndex(field.getName());
            IsWidget editableCell = this.editableCell(field, fact, fact.getType());
            this.widget.setWidget(fieldRowIndex, this.col, editableCell);
            if (!(field instanceof FieldData) || (fieldData = (FieldData)field).getNature() != 4L) continue;
            enumEditorMap.put(fieldData, (FieldDataConstraintEditor)editableCell);
        }
        for (FieldDataConstraintEditor outerEnumEditor : enumEditorMap.values()) {
            for (FieldDataConstraintEditor innerEnumEditor : enumEditorMap.values()) {
                if (outerEnumEditor == innerEnumEditor) continue;
                outerEnumEditor.addIfDependentEnumEditor(innerEnumEditor);
            }
        }
        if (fact instanceof FactData) {
            DeleteFactColumnButton deleteFactColumnButton = new DeleteFactColumnButton(this, (FactData)fact);
            this.widget.setWidget(this.rowIndexByFieldName.amountOrRows() + 1, this.col, (Widget)deleteFactColumnButton);
        }
    }

    private ClickHandler createAddFieldButton(Fact fact) {
        if (fact instanceof FactData) {
            return new AddFieldToFactDataClickHandler(this.definitionList, this.suggestionCompletionEngine, this.parent);
        }
        return new AddFieldToFactClickHandler(fact, this.suggestionCompletionEngine, this.parent);
    }

    private void newRow(Fact fact, String fieldName) {
        this.rowIndexByFieldName.addRow(fieldName);
        int rowIndex = this.rowIndexByFieldName.getRowIndex(fieldName);
        this.widget.setWidget(rowIndex, 0, this.createFieldNameWidget(fieldName));
        this.widget.setWidget(rowIndex, this.definitionList.size() + 1, (Widget)new DeleteFieldRowButton(this, fact, fieldName));
        this.widget.getCellFormatter().setHorizontalAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    private IsWidget editableCell(Field field, Fact fact, String factType) {
        if (field instanceof FieldData) {
            FieldDataConstraintEditor fieldDataConstraintEditor = new FieldDataConstraintEditor(factType, (FieldData)field, fact, this.suggestionCompletionEngine, this.scenario, this.executionTrace);
            fieldDataConstraintEditor.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            return fieldDataConstraintEditor;
        }
        if (field instanceof CollectionFieldData) {
            return new CollectionFieldDataConstraintEditor(factType, (CollectionFieldData)field, fact, this.suggestionCompletionEngine, this.scenario, this.executionTrace);
        }
        if (field instanceof FactAssignmentField) {
            return new FactAssignmentFieldWidget((FactAssignmentField)field, this.definitionList, this.scenario, this.suggestionCompletionEngine, this.parent, this.executionTrace);
        }
        if (field instanceof FieldPlaceHolder) {
            return new FieldSelectorWidget(field, new FieldConstraintHelper(this.scenario, this.executionTrace, this.suggestionCompletionEngine, factType, field, fact), this.parent);
        }
        throw new IllegalArgumentException("Unknown field type: " + field.getClass());
    }

    private IsWidget createFieldNameWidget(String fieldName) {
        return new FieldNameWidgetImpl(fieldName);
    }

    public int amountOrRows() {
        return this.rowIndexByFieldName.amountOrRows();
    }

    static /* synthetic */ Scenario access$000(FactDataWidgetFactory x0) {
        return x0.scenario;
    }

    static /* synthetic */ FixtureList access$100(FactDataWidgetFactory x0) {
        return x0.definitionList;
    }

    static /* synthetic */ ScenarioParentWidget access$200(FactDataWidgetFactory x0) {
        return x0.parent;
    }
}

