/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.common.DatePickerTextBox;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldConstraintHelper;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldSelectorWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioParentWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class FieldDataConstraintEditor
extends DirtyableComposite
implements HasValueChangeHandlers<String>,
ScenarioParentWidget {
    private FieldData field;
    private IsWidget valueEditorWidget;
    private final Panel panel = new SimplePanel();
    private final FieldConstraintHelper helper;
    private List<FieldDataConstraintEditor> dependentEnumEditors = null;

    public FieldDataConstraintEditor(String factType, FieldData field, Fact givenFact, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace executionTrace) {
        this.field = field;
        this.helper = new FieldConstraintHelper(scenario, executionTrace, sce, factType, (Field)field, givenFact);
        this.renderEditor();
        this.initWidget((Widget)this.panel);
    }

    public void renderEditor() {
        String flType = this.helper.getFieldType();
        this.panel.clear();
        if (flType != null && flType.equals("Boolean")) {
            this.addBooleanEditor();
        } else if (flType != null && flType.equals("Date")) {
            this.addDateEditor();
        } else {
            DropDownData dropDownData = this.helper.getEnums();
            if (dropDownData != null) {
                this.addDropDownEditor(dropDownData);
            } else {
                this.setFieldNatureIfItIsWasNotSetBefore();
                if (this.field.getNature() == 0L && (this.helper.isThereABoundVariableToSet() || this.helper.isItAList())) {
                    this.addFieldSelectorWidget();
                } else if (this.isFieldVariable()) {
                    this.addVariableEditor();
                } else {
                    this.addDefaultTextBoxWidget(flType);
                }
            }
        }
    }

    private void addDateEditor() {
        this.valueEditorWidget = this.dateEditor();
        this.panel.add(this.valueEditorWidget);
    }

    private void addBooleanEditor() {
        this.valueEditorWidget = this.booleanEditor();
        this.panel.add(this.valueEditorWidget);
    }

    private void addDropDownEditor(DropDownData dropDownData) {
        this.field.setNature(4L);
        this.dependentEnumEditors = new ArrayList();
        this.valueEditorWidget = this.dropDownEditor(dropDownData);
        this.panel.add(this.valueEditorWidget);
    }

    private void addDefaultTextBoxWidget(String flType) {
        this.valueEditorWidget = this.textBoxEditor((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */, flType, this.field.getName(), this.field.getValue());
        this.panel.add(this.valueEditorWidget);
    }

    private void setFieldNatureIfItIsWasNotSetBefore() {
        if (this.field.getValue() != null && this.field.getValue().length() > 0 && this.field.getNature() == 0L) {
            if (this.field.getValue().length() > 1 && this.field.getValue().charAt(1) == '[' && this.field.getValue().charAt(0) == '=') {
                this.field.setNature(1L);
            } else if (this.field.getValue().charAt(0) == '=') {
                this.field.setNature(2L);
            } else {
                this.field.setNature(1L);
            }
        }
    }

    private void addVariableEditor() {
        this.valueEditorWidget = this.variableEditor();
        this.panel.add(this.valueEditorWidget);
    }

    private void addFieldSelectorWidget() {
        this.helper.setParentIsAList(true);
        this.valueEditorWidget = new FieldSelectorWidget((Field)this.field, this.helper, (ScenarioParentWidget)this);
        this.panel.add(this.valueEditorWidget);
    }

    private boolean isFieldVariable() {
        return this.field.getNature() == 2L;
    }

    private EnumDropDown booleanEditor() {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])new String[]{"true", "false"}));
    }

    private EnumDropDown dropDownEditor(DropDownData dropDownData) {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, dropDownData);
    }

    private DatePickerTextBox dateEditor() {
        DatePickerTextBox editor = new DatePickerTextBox(this.field.getValue());
        editor.setTitle(Constants.INSTANCE.ValueFor0(this.field.getName()));
        editor.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
        return editor;
    }

    private TextBox textBoxEditor(ValueChangeHandler<String> valueChangeHandler, String dataType, String fieldName, String initialValue) {
        TextBox tb = TextBoxFactory.getTextBox((String)dataType);
        tb.setText(initialValue);
        tb.setTitle(Constants.INSTANCE.ValueFor0(fieldName));
        tb.addValueChangeHandler(valueChangeHandler);
        return tb;
    }

    private Widget variableEditor() {
        List vars = this.helper.getFactNamesInScope();
        ListBox box = new ListBox();
        if (this.field.getValue() == null) {
            box.addItem(Constants.INSTANCE.Choose());
        }
        int j = 0;
        for (String var : vars) {
            if (!this.helper.getFactTypeByVariableName(var).getType().equals(this.helper.resolveFieldType())) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.getValue() != null && this.field.getValue().equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private void valueHasChanged(String newValue) {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)newValue);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> stringValueChangeHandler) {
        return this.addHandler(stringValueChangeHandler, ValueChangeEvent.getType());
    }

    public void addIfDependentEnumEditor(FieldDataConstraintEditor candidateDependentEnumEditor) {
        if (this.helper.isDependentEnum(candidateDependentEnumEditor.helper)) {
            this.dependentEnumEditors.add(candidateDependentEnumEditor);
        }
    }

    private void refreshDropDownData() {
        if (this.valueEditorWidget instanceof EnumDropDown) {
            EnumDropDown dropdown = (EnumDropDown)this.valueEditorWidget;
            dropdown.setDropDownData(this.field.getValue(), this.helper.getEnums());
        }
    }

    static /* synthetic */ void access$000(FieldDataConstraintEditor x0, String x1) {
        x0.valueHasChanged(x1);
    }

    static /* synthetic */ List access$100(FieldDataConstraintEditor x0) {
        return x0.dependentEnumEditors;
    }

    static /* synthetic */ void access$200(FieldDataConstraintEditor x0) {
        x0.refreshDropDownData();
    }

    static /* synthetic */ FieldData access$300(FieldDataConstraintEditor x0) {
        return x0.field;
    }
}

