/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.AcceptItem;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.explorer.navigation.deployment.SnapshotPlace;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.AssetViewerActivity;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.widgets.drools.tables.SnapshotComparisonPagedTable;

public class SnapshotView
extends Composite {
    public static final String LATEST_SNAPSHOT = "LATEST";
    private Module parentConf;
    private SnapshotInfo snapInfo;
    private ListBox box = new ListBox();
    private VerticalPanel vert;
    private SnapshotComparisonPagedTable table;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public SnapshotView(ClientFactory clientFactory, EventBus eventBus, SnapshotInfo snapInfo, Module parentPackage) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.vert = new VerticalPanel();
        this.snapInfo = snapInfo;
        this.parentConf = parentPackage;
        PrettyFormLayout head = new PrettyFormLayout();
        Image snapshot = GuvnorImages.INSTANCE.Snapshot();
        snapshot.setAltText("");
        head.addHeader(snapshot, this.header());
        this.vert.add((Widget)head);
        AssetViewerActivity assetViewerActivity = new AssetViewerActivity(this.parentConf.getUuid(), clientFactory);
        assetViewerActivity.start((AcceptItem)new /* Unavailable Anonymous Inner Class!! */, null);
        this.vert.setWidth("100%");
        this.initWidget((Widget)this.vert);
    }

    private Widget header() {
        FlexTable ft = new FlexTable();
        ft.setWidget(0, 0, (Widget)new Label(Constants.INSTANCE.ViewingSnapshot()));
        ft.setWidget(0, 1, (Widget)new HTML("<b>" + this.snapInfo.getName() + "</b>"));
        ft.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(1, 0, (Widget)new Label(Constants.INSTANCE.ForPackage()));
        ft.setWidget(1, 1, (Widget)new Label(this.parentConf.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HTML dLink = new HTML("<a href='" + PackageBuilderWidget.getDownloadLink((Module)this.parentConf) + "' target='_blank'>" + Constants.INSTANCE.clickHereToDownloadBinaryOrCopyURLForDeploymentAgent() + "</a>");
        ft.setWidget(2, 0, (Widget)new Label(Constants.INSTANCE.DeploymentURL()));
        ft.setWidget(2, 1, (Widget)dLink);
        ft.getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 0, (Widget)new Label(Constants.INSTANCE.SnapshotCreatedOn()));
        ft.getFlexCellFormatter().setHorizontalAlignment(3, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(3, 1, (Widget)new Label(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(this.parentConf.getLastModified())));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.setWidget(4, 0, (Widget)new Label(Constants.INSTANCE.CommentColon()));
        ft.setWidget(4, 1, (Widget)new Label(this.parentConf.getCheckinComment()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        HorizontalPanel actions = new HorizontalPanel();
        actions.add((Widget)this.getDeleteButton(this.snapInfo.getName(), this.parentConf.getName()));
        actions.add((Widget)this.getCopyButton(this.snapInfo.getName(), this.parentConf.getName()));
        ft.setWidget(5, 0, (Widget)actions);
        ft.setWidget(6, 0, this.getCompareWidget(this.parentConf.getName(), this.snapInfo.getName()));
        ft.getFlexCellFormatter().setHorizontalAlignment(4, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        ft.getFlexCellFormatter().setColSpan(5, 0, 2);
        return ft;
    }

    private Widget getCompareWidget(String packageName, String snapshotName) {
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add((Widget)new Label("Compare to:"));
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listSnapshots(this.parentConf.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)this.box);
        Button button = new Button("Compare");
        button.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hPanel.add((Widget)button);
        return hPanel;
    }

    private Button getDeleteButton(String snapshotName, String moduleName) {
        Button btn = new Button(Constants.INSTANCE.Delete());
        btn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private ClosePlaceEvent getCloseEvent(String moduleName) {
        return new ClosePlaceEvent((Place)new SnapshotPlace(moduleName, this.snapInfo.getName()));
    }

    private Button getCopyButton(String snapshotName, String packageName) {
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        Button btn = new Button(Constants.INSTANCE.Copy());
        btn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return btn;
    }

    private GenericCallback<SnapshotInfo[]> createGenericCallback(String snapshotName, String packageName, ModuleServiceAsync serv) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void showNewSnapshot(Command refreshCmd) {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Snapshot(), Constants.INSTANCE.NewSnapshot());
        RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(Constants.INSTANCE.ForPackage(), (Widget)sel);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)ok);
        pop.show();
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void rebuildBinaries() {
        if (Window.confirm((String)Constants.INSTANCE.SnapshotRebuildWarning())) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.RebuildingSnapshotsPleaseWaitThisMayTakeSomeTime());
            ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
            moduleService.rebuildSnapshots((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ VerticalPanel access$000(SnapshotView x0) {
        return x0.vert;
    }

    static /* synthetic */ ListBox access$100(SnapshotView x0) {
        return x0.box;
    }

    static /* synthetic */ SnapshotComparisonPagedTable access$200(SnapshotView x0) {
        return x0.table;
    }

    static /* synthetic */ SnapshotComparisonPagedTable access$202(SnapshotView x0, SnapshotComparisonPagedTable x1) {
        x0.table = x1;
        return x0.table;
    }

    static /* synthetic */ ClientFactory access$300(SnapshotView x0) {
        return x0.clientFactory;
    }

    static /* synthetic */ ClosePlaceEvent access$400(SnapshotView x0, String x1) {
        return x0.getCloseEvent(x1);
    }

    static /* synthetic */ EventBus access$500(SnapshotView x0) {
        return x0.eventBus;
    }

    static /* synthetic */ GenericCallback access$600(SnapshotView x0, String x1, String x2, ModuleServiceAsync x3) {
        return x0.createGenericCallback(x1, x2, x3);
    }
}

