/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.simulation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.simulation.PathWidget;
import org.drools.guvnor.client.simulation.SimulationTestEventHandler;
import org.drools.guvnor.client.simulation.StepWidget;
import org.drools.guvnor.client.simulation.resources.SimulationResources;
import org.drools.guvnor.client.simulation.resources.SimulationStyle;
import org.drools.guvnor.shared.simulation.SimulationPathModel;
import org.drools.guvnor.shared.simulation.SimulationStepModel;
import org.drools.guvnor.shared.simulation.SimulationTestUtils;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;

public class PathWidget
extends Composite {
    private static PathWidgetBinder uiBinder = (PathWidgetBinder)GWT.create(PathWidgetBinder.class);
    private final SimulationPathModel path;
    private final SimulationTestEventHandler simulationTestEventHandler;
    @UiField
    protected SimulationResources simulationResources = SimulationResources.INSTANCE;
    protected SimulationStyle simulationStyle = SimulationResources.INSTANCE.style();
    @UiField
    protected FlexTable flexTable;
    @UiField
    protected PushButton addStepButton;
    @UiField
    protected PushButton removePathButton;
    private Map<SimulationStepModel, Integer> stepRowIndexMap = new HashMap();
    private Map<SimulationStepModel, StepWidget> stepWidgetMap = new HashMap();

    public PathWidget(SimulationPathModel path, SimulationTestEventHandler simulationTestEventHandler) {
        this.path = path;
        this.simulationTestEventHandler = simulationTestEventHandler;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.flexTable.getColumnFormatter().addStyleName(0, this.simulationStyle.distanceMillisColumn());
        this.flexTable.getColumnFormatter().addStyleName(1, this.simulationStyle.stepWidgetColumn());
        this.flexTable.getColumnFormatter().addStyleName(2, this.simulationStyle.removeStepColumn());
        for (SimulationStepModel step : path.getSteps().values()) {
            this.addStepWidget(step);
        }
    }

    private void addStepWidget(SimulationStepModel step) {
        int stepIndex = this.flexTable.getRowCount();
        Label distanceMillisLabel = new Label(SimulationTestUtils.formatMillis((long)step.getDistanceMillis()));
        this.flexTable.setWidget(stepIndex, 0, (Widget)distanceMillisLabel);
        StepWidget stepWidget = new StepWidget(step, this.simulationTestEventHandler);
        this.flexTable.setWidget(stepIndex, 1, (Widget)stepWidget);
        this.flexTable.setWidget(stepIndex, 2, (Widget)this.createRemoveStepButton(step));
        this.stepRowIndexMap.put(step, stepIndex);
        this.stepWidgetMap.put(step, stepWidget);
    }

    private PushButton createRemoveStepButton(SimulationStepModel step) {
        PushButton removeStepButton = new PushButton(new Image(this.simulationResources.removeStep()));
        removeStepButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return removeStepButton;
    }

    private void removeStepWidget(SimulationStepModel step) {
        int stepIndex = (Integer)this.stepRowIndexMap.remove(step);
        this.stepWidgetMap.remove(step);
        this.flexTable.removeRow(stepIndex);
        for (Map.Entry entry : this.stepRowIndexMap.entrySet()) {
            int otherStepIndex = (Integer)entry.getValue();
            if (otherStepIndex <= stepIndex) continue;
            entry.setValue(otherStepIndex - 1);
        }
    }

    @UiHandler(value={"addStepButton"})
    protected void addStep(ClickEvent event) {
        this.simulationTestEventHandler.addStep(this.path);
    }

    @UiHandler(value={"removePathButton"})
    protected void removePath(ClickEvent event) {
        this.simulationTestEventHandler.removePath(this.path);
    }

    public void addedStep(SimulationStepModel step) {
        this.addStepWidget(step);
    }

    public void removedStep(SimulationStepModel step) {
        this.removeStepWidget(step);
    }

    public void addedCommand(AbstractCommandModel command) {
        ((StepWidget)this.stepWidgetMap.get(command.getStep())).addedCommand(command);
    }

    public void movedUpCommand(AbstractCommandModel command) {
        ((StepWidget)this.stepWidgetMap.get(command.getStep())).movedUpCommand(command);
    }

    public void movedDownCommand(AbstractCommandModel command) {
        ((StepWidget)this.stepWidgetMap.get(command.getStep())).movedDownCommand(command);
    }

    public void removedCommand(AbstractCommandModel command) {
        ((StepWidget)this.stepWidgetMap.get(command.getStep())).removedCommand(command);
    }

    static /* synthetic */ SimulationTestEventHandler access$000(PathWidget x0) {
        return x0.simulationTestEventHandler;
    }
}

