/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.simulation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.guvnor.client.simulation.SimulationTestEventHandler;
import org.drools.guvnor.client.simulation.TimeLineWidget;
import org.drools.guvnor.client.simulation.resources.SimulationResources;
import org.drools.guvnor.client.simulation.resources.SimulationStyle;
import org.drools.guvnor.shared.simulation.SimulationModel;
import org.drools.guvnor.shared.simulation.SimulationPathModel;
import org.drools.guvnor.shared.simulation.SimulationStepModel;
import org.drools.guvnor.shared.simulation.SimulationTestUtils;

public class TimeLineWidget
extends Composite {
    private static final int TIME_STONE_THRESHOLD_IN_PIXELS = 80;
    private static final long[] TIME_STONE_INCREMENT_OPTIONS = new long[]{100L, 500L, 1000L, 5000L, 10000L, 30000L, 60000L, 300000L, 600000L, 3600000L, 21600000L, 43200000L, 86400000L, 432000000L};
    private static TimeLineWidgetBinder uiBinder = (TimeLineWidgetBinder)GWT.create(TimeLineWidgetBinder.class);
    private final SimulationTestEventHandler simulationTestEventHandler;
    @UiField
    protected SimulationResources simulationResources = SimulationResources.INSTANCE;
    protected SimulationStyle simulationStyle = SimulationResources.INSTANCE.style();
    @UiField
    protected PushButton addPathButton;
    @UiField
    protected PushButton zoomInButton;
    @UiField
    protected PushButton zoomOutButton;
    @UiField
    protected ScrollPanel timeLineScrollPanel;
    @UiField
    protected LayoutPanel timeLineContent;
    @UiField
    protected FlowPanel addStepsPanel;
    private SimulationModel simulation;
    private int contentHeight;
    private int contentWidth;
    private double millisecondsPerPixel;
    private Map<Long, VerticalPanel> timeStoneMap = null;
    private Map<SimulationStepModel, Image> stepMap = null;

    public TimeLineWidget(SimulationTestEventHandler simulationTestEventHandler) {
        this.simulationTestEventHandler = simulationTestEventHandler;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.contentHeight = this.simulationStyle.timeLineHeaderHeight() + this.simulationStyle.timeLineFooterHeight();
        this.timeLineScrollPanel.addScrollHandler((ScrollHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.simulationResources.timeStone().getHeight() != this.simulationStyle.timeLinePathHeight()) {
            throw new IllegalStateException("The timeStone image height (" + this.simulationResources.timeStone().getHeight() + ") must be equal to the PATH_HEIGHT (" + this.simulationStyle.timeLinePathHeight() + ").");
        }
    }

    public void setSimulation(SimulationModel simulation) {
        this.simulation = simulation;
        this.clearTimeLineContent();
        this.timeLineScrollPanel.setWidth(this.simulationStyle.timeLineScrollPanelWidth() + "px");
        this.adjustContentHeight();
        this.addStepsPanel.addStyleName(this.simulationStyle.addStepsPanel());
        long maximumDistanceMillis = simulation.getMaximumDistanceMillis();
        this.millisecondsPerPixel = (double)maximumDistanceMillis / (double)(this.simulationStyle.timeLineScrollPanelWidth() - this.simulationStyle.timeLineMarginWidth() * 2);
        this.adjustContentWidth(maximumDistanceMillis);
        this.updateTimeLineContent(0, this.simulationStyle.timeLineScrollPanelWidth());
        this.refreshAddStepsPanel();
    }

    private void clearTimeLineContent() {
        if (this.timeStoneMap != null) {
            for (VerticalPanel timeStonePanel : this.timeStoneMap.values()) {
                this.timeLineContent.remove((Widget)timeStonePanel);
            }
        }
        this.timeStoneMap = new LinkedHashMap();
        if (this.stepMap != null) {
            for (Image stepWidget : this.stepMap.values()) {
                this.timeLineContent.remove((Widget)stepWidget);
            }
        }
        this.stepMap = new LinkedHashMap();
    }

    private void refreshAddStepsPanel() {
        Iterator it = this.addStepsPanel.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Label addStepLabel = new Label("");
        addStepLabel.addStyleName(this.simulationStyle.addStepHeader());
        this.addStepsPanel.add((Widget)addStepLabel);
        for (SimulationPathModel path : this.simulation.getPaths().values()) {
            FlowPanel heightLimitingPanel = new FlowPanel();
            heightLimitingPanel.setHeight(this.simulationStyle.timeLinePathHeight() + "px");
            PushButton addStepButton = this.createAddStepButton(path);
            heightLimitingPanel.add((Widget)addStepButton);
            this.addStepsPanel.add((Widget)heightLimitingPanel);
        }
    }

    private PushButton createAddStepButton(SimulationPathModel path) {
        PushButton addStepButton = new PushButton(new Image(this.simulationResources.addStep()));
        addStepButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addStepButton;
    }

    public void addedPath(SimulationPathModel path) {
        this.adjustContentHeight();
        this.adjustContentWidth(this.simulation.getMaximumDistanceMillis());
        this.clearTimeLineContent();
        this.scrollToDistanceMillis(0L);
        this.refreshAddStepsPanel();
    }

    public void removedPath(SimulationPathModel path) {
        this.adjustContentHeight();
        this.adjustContentWidth(this.simulation.getMaximumDistanceMillis());
        this.clearTimeLineContent();
        this.scrollToDistanceMillis(0L);
        this.refreshAddStepsPanel();
    }

    public void addedStep(SimulationStepModel step) {
        this.adjustContentWidth(this.simulation.getMaximumDistanceMillis());
        this.scrollToDistanceMillis(step.getDistanceMillis().longValue());
    }

    public void removedStep(SimulationStepModel step) {
        Image stepWidget = (Image)this.stepMap.remove(step);
        if (stepWidget != null) {
            this.timeLineContent.remove((Widget)stepWidget);
        }
        this.adjustContentWidth(this.simulation.getMaximumDistanceMillis());
        this.scrollToDistanceMillis(step.getDistanceMillis().longValue());
    }

    public void scrollToDistanceMillis(long distanceMillis) {
        int x = this.calculateX(distanceMillis);
        int clientWidth = this.timeLineScrollPanel.getElement().getClientWidth();
        int scrollLeft = this.adjustScrollLeft(x - clientWidth / 2, clientWidth);
        this.updateTimeLineContent(scrollLeft, clientWidth);
    }

    private int adjustScrollLeft(int scrollLeft, int clientWidth) {
        scrollLeft = Math.max(0, scrollLeft);
        scrollLeft = Math.min(this.contentWidth - clientWidth, scrollLeft);
        this.timeLineScrollPanel.getElement().setScrollLeft(scrollLeft);
        return scrollLeft;
    }

    @UiHandler(value={"addPathButton"})
    protected void addPath(ClickEvent event) {
        this.simulationTestEventHandler.addPath();
    }

    @UiHandler(value={"zoomInButton"})
    protected void zoomIn(ClickEvent event) {
        this.zoomIn();
    }

    public void zoomIn() {
        int scrollLeft = this.timeLineScrollPanel.getElement().getScrollLeft();
        int clientWidth = this.timeLineScrollPanel.getElement().getClientWidth();
        long distanceMillis = this.calculateDistanceMillis(scrollLeft, clientWidth);
        long maximumDistanceMillis = this.simulation.getMaximumDistanceMillis();
        this.millisecondsPerPixel = Math.max(1.0, this.millisecondsPerPixel / 2.0);
        this.adjustContentWidth(maximumDistanceMillis);
        scrollLeft = this.adjustScrollLeft(this.calculateX(distanceMillis, clientWidth), clientWidth);
        this.timeLineScrollPanel.getElement().setScrollLeft(scrollLeft);
        this.updateTimeLineContent(scrollLeft, clientWidth);
    }

    @UiHandler(value={"zoomOutButton"})
    protected void zoomOut(ClickEvent event) {
        this.zoomOut();
    }

    public void zoomOut() {
        int scrollLeft = this.timeLineScrollPanel.getElement().getScrollLeft();
        int clientWidth = this.timeLineScrollPanel.getElement().getClientWidth();
        long distanceMillis = this.calculateDistanceMillis(scrollLeft, clientWidth);
        long maximumDistanceMillis = this.simulation.getMaximumDistanceMillis();
        double maximumMillisecondsPerPixel = (double)maximumDistanceMillis / (double)(clientWidth - this.simulationStyle.timeLineMarginWidth() * 2);
        this.millisecondsPerPixel = Math.min(maximumMillisecondsPerPixel, this.millisecondsPerPixel * 2.0);
        this.adjustContentWidth(maximumDistanceMillis);
        scrollLeft = this.adjustScrollLeft(this.calculateX(distanceMillis, clientWidth), clientWidth);
        this.timeLineScrollPanel.getElement().setScrollLeft(scrollLeft);
        this.updateTimeLineContent(scrollLeft, clientWidth);
    }

    private void adjustContentWidth(long maximumDistanceMillis) {
        this.contentWidth = (int)((double)maximumDistanceMillis / this.millisecondsPerPixel) + this.simulationStyle.timeLineMarginWidth() * 2;
        this.timeLineContent.setWidth(this.contentWidth + "px");
    }

    private void adjustContentHeight() {
        this.contentHeight = this.simulationStyle.timeLineHeaderHeight() + this.simulation.getPathsSize() * this.simulationStyle.timeLinePathHeight() + this.simulationStyle.timeLineFooterHeight();
        this.timeLineContent.setHeight(this.contentHeight + "px");
        this.addStepsPanel.setHeight(this.contentHeight + "px");
    }

    private void updateTimeLineContent() {
        int scrollLeft = this.timeLineScrollPanel.getElement().getScrollLeft();
        int clientWidth = this.timeLineScrollPanel.getElement().getClientWidth();
        this.updateTimeLineContent(scrollLeft, clientWidth);
    }

    private void updateTimeLineContent(int scrollLeft, int clientWidth) {
        this.updateTimeStones(scrollLeft, clientWidth);
        this.updateSteps(scrollLeft, clientWidth);
    }

    private void updateTimeStones(int scrollLeft, int clientWidth) {
        long maximumDistanceMillis = this.simulation.getMaximumDistanceMillis();
        int itemWidth = this.simulationResources.timeStone().getWidth();
        long timeStoneIncrement = this.calculateTimeStoneIncrement();
        Iterator it = this.timeStoneMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry timeStoneEntry = it.next();
            long timeStoneValue = (Long)timeStoneEntry.getKey();
            int x = this.calculateX(timeStoneValue, itemWidth);
            if (this.isWithinViewportBounds(scrollLeft, clientWidth, (double)x, itemWidth) && timeStoneValue % timeStoneIncrement == 0L) continue;
            this.timeLineContent.remove((Widget)timeStoneEntry.getValue());
            it.remove();
        }
        for (long timeStoneValue = 0L; timeStoneValue <= maximumDistanceMillis; timeStoneValue += timeStoneIncrement) {
            VerticalPanel timeStonePanel;
            int x = this.calculateX(timeStoneValue, itemWidth);
            if (!this.timeStoneMap.containsKey(timeStoneValue)) {
                if (!this.isWithinViewportBounds(scrollLeft, clientWidth, (double)x, itemWidth)) continue;
                timeStonePanel = this.createTimeStonePanel(timeStoneValue);
                this.timeLineContent.add((Widget)timeStonePanel);
                this.timeLineContent.setWidgetLeftWidth((Widget)timeStonePanel, (double)x, Style.Unit.PX, 80.0, Style.Unit.PX);
                this.timeLineContent.setWidgetTopHeight((Widget)timeStonePanel, 0.0, Style.Unit.PX, (double)this.contentHeight, Style.Unit.PX);
                this.timeStoneMap.put(timeStoneValue, timeStonePanel);
                continue;
            }
            timeStonePanel = (VerticalPanel)this.timeStoneMap.get(timeStoneValue);
            this.timeLineContent.setWidgetLeftWidth((Widget)timeStonePanel, (double)x, Style.Unit.PX, 80.0, Style.Unit.PX);
        }
    }

    private VerticalPanel createTimeStonePanel(long timeStoneValue) {
        VerticalPanel timeStonePanel = new VerticalPanel();
        timeStonePanel.addStyleName(this.simulationStyle.timeStonePanel());
        Label timeStoneLabel = new Label(SimulationTestUtils.formatMillis((long)timeStoneValue));
        timeStoneLabel.addStyleName(this.simulationStyle.timeStoneLabel());
        timeStonePanel.add((Widget)timeStoneLabel);
        int pathTop = this.simulationStyle.timeLineHeaderHeight();
        for (SimulationPathModel path : this.simulation.getPaths().values()) {
            Image timeStoneImage = new Image(this.simulationResources.timeStone());
            timeStonePanel.add((Widget)timeStoneImage);
            pathTop += this.simulationStyle.timeLinePathHeight();
        }
        return timeStonePanel;
    }

    private void updateSteps(int scrollLeft, int clientWidth) {
        int itemWidth = this.simulationResources.stepEmpty().getWidth();
        Iterator it = this.stepMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry stepEntry = it.next();
            long distanceMillis = ((SimulationStepModel)stepEntry.getKey()).getDistanceMillis();
            int x = this.calculateX(distanceMillis, itemWidth);
            if (this.isWithinViewportBounds(scrollLeft, clientWidth, (double)x, itemWidth)) continue;
            this.timeLineContent.remove((Widget)stepEntry.getValue());
            it.remove();
        }
        int pathTop = this.simulationStyle.timeLineHeaderHeight();
        for (SimulationPathModel path : this.simulation.getPaths().values()) {
            for (SimulationStepModel step : path.getSteps().values()) {
                Image stepWidget;
                int x = this.calculateX(step.getDistanceMillis().longValue(), itemWidth);
                if (!this.stepMap.containsKey(step)) {
                    if (!this.isWithinViewportBounds(scrollLeft, clientWidth, (double)x, itemWidth)) continue;
                    stepWidget = this.createStepWidget(path, step);
                    this.timeLineContent.add((Widget)stepWidget);
                    this.timeLineContent.setWidgetLeftWidth((Widget)stepWidget, (double)x, Style.Unit.PX, (double)stepWidget.getWidth(), Style.Unit.PX);
                    this.timeLineContent.setWidgetTopHeight((Widget)stepWidget, (double)(pathTop + (this.simulationStyle.timeLinePathHeight() - stepWidget.getHeight()) / 2), Style.Unit.PX, (double)stepWidget.getHeight(), Style.Unit.PX);
                    this.stepMap.put(step, stepWidget);
                    continue;
                }
                stepWidget = (Image)this.stepMap.get(step);
                this.timeLineContent.setWidgetLeftWidth((Widget)stepWidget, (double)x, Style.Unit.PX, (double)stepWidget.getWidth(), Style.Unit.PX);
            }
            pathTop += this.simulationStyle.timeLinePathHeight();
        }
    }

    private Image createStepWidget(SimulationPathModel path, SimulationStepModel step) {
        ImageResource imageResource = this.simulationResources.stepEmpty();
        Image image = new Image(imageResource);
        PopupPanel popupPanel = new PopupPanel(true);
        popupPanel.setWidget((Widget)new Label(path.getName() + " @ " + SimulationTestUtils.formatMillis((long)step.getDistanceMillis())));
        image.addMouseOverHandler((MouseOverHandler)new /* Unavailable Anonymous Inner Class!! */);
        image.addMouseOutHandler((MouseOutHandler)new /* Unavailable Anonymous Inner Class!! */);
        popupPanel.setAutoHideOnHistoryEventsEnabled(true);
        image.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return image;
    }

    private int calculateX(long distanceMillis, int itemWidth) {
        return this.calculateX(distanceMillis) - itemWidth / 2;
    }

    private int calculateX(long distanceMillis) {
        return this.simulationStyle.timeLineMarginWidth() + (int)((double)distanceMillis / this.millisecondsPerPixel);
    }

    private long calculateDistanceMillis(int x, int itemWidth) {
        return this.calculateDistanceMillis(x + itemWidth / 2);
    }

    private long calculateDistanceMillis(int x) {
        return (long)((double)(x - this.simulationStyle.timeLineMarginWidth()) * this.millisecondsPerPixel);
    }

    private boolean isWithinViewportBounds(int scrollLeft, int clientWidth, double x, int itemWidth) {
        return x + (double)itemWidth > (double)scrollLeft && x < (double)(scrollLeft + clientWidth);
    }

    private long calculateTimeStoneIncrement() {
        long timeStoneIncrement;
        int i = 0;
        while ((double)(timeStoneIncrement = TIME_STONE_INCREMENT_OPTIONS[i]) / this.millisecondsPerPixel < 80.0 && ++i < TIME_STONE_INCREMENT_OPTIONS.length) {
        }
        return timeStoneIncrement;
    }

    static /* synthetic */ void access$000(TimeLineWidget x0) {
        x0.updateTimeLineContent();
    }

    static /* synthetic */ SimulationTestEventHandler access$100(TimeLineWidget x0) {
        return x0.simulationTestEventHandler;
    }
}

