/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.client.widgets.drools.explorer.ArtifactDependenciesExplorer;
import org.drools.guvnor.client.widgets.drools.explorer.ArtifactDependenciesExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ArtifactDependenciesReadyCommand;

public class ArtifactDependenciesExplorerWidget
extends DirtyableComposite
implements ArtifactDependenciesExplorer {
    private static DroolsGuvnorImageResources images = (DroolsGuvnorImageResources)GWT.create(DroolsGuvnorImageResources.class);
    private final TreeItem root;
    private static ArtifactDependenciesExplorerWidgetBinder uiBinder = (ArtifactDependenciesExplorerWidgetBinder)GWT.create(ArtifactDependenciesExplorerWidgetBinder.class);
    @UiField
    protected Tree treeArtifacts;

    public ArtifactDependenciesExplorerWidget(String rootName, Collection<MavenArtifact> tree, Collection<MavenArtifact> excluded) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.root = this.treeArtifacts.addItem(rootName);
        this.setupTree(tree, excluded);
    }

    private void setupTree(Collection<MavenArtifact> tree, Collection<MavenArtifact> unchecked) {
        for (MavenArtifact mavenArtifact : tree) {
            this.addItem(this.root, mavenArtifact, unchecked);
        }
        this.root.setState(true);
    }

    private void addItem(TreeItem root, MavenArtifact artifact, Collection<MavenArtifact> unchecked) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.append(SafeHtmlUtils.fromTrustedString((String)AbstractImagePrototype.create((ImageResource)images.modelAsset()).getHTML()));
        sb.appendEscaped(" ").appendEscaped(artifact.toLabel());
        CheckBox checkBox = new CheckBox(sb.toSafeHtml());
        if (!unchecked.contains(artifact)) {
            checkBox.setValue(Boolean.valueOf(true));
        }
        TreeItem newTreeItem = root.addItem((Widget)checkBox);
        newTreeItem.setUserObject((Object)artifact);
        if (artifact.hasChild()) {
            for (MavenArtifact chilldren : artifact.getChild()) {
                this.addItem(newTreeItem, chilldren, unchecked);
            }
        }
        checkBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void processExcludedArtifacts(ArtifactDependenciesReadyCommand callback) {
        ArrayList result = new ArrayList();
        this.buildExcludedList(this.root, result);
        callback.onSuccess(result);
    }

    private void buildExcludedList(TreeItem item, List<MavenArtifact> result) {
        if (item.getWidget() != null && !((CheckBox)item.getWidget()).getValue().booleanValue()) {
            result.add((MavenArtifact)item.getUserObject());
        }
        if (item.getChildCount() > 0) {
            for (int i = 0; i < item.getChildCount(); ++i) {
                this.buildExcludedList(item.getChild(i), result);
            }
        }
    }
}

