/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.server.converters.decisiontable.builders.GuidedDecisionTableLHSBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.GuidedDecisionTableSourceBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.HasColumnHeadings;
import org.drools.guvnor.server.converters.decisiontable.builders.IndexedParametersValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.LiteralValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterUtilities;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterizedValueBuilder;
import org.drools.guvnor.server.converters.decisiontable.builders.SingleParameterValueBuilder;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;

public class GuidedDecisionTableLHSBuilder
implements HasColumnHeadings,
GuidedDecisionTableSourceBuilder {
    private final int headerRow;
    private final int headerCol;
    private String colDefPrefix;
    private String colDefSuffix;
    private boolean hasPattern;
    private String andop;
    private static Set<String> operators = new HashSet();
    private static final Pattern patParFrm;
    private static final Pattern patFrm;
    private static final Pattern patPar;
    private static final Pattern patEval;
    private final Map<Integer, String> columnHeaders = new HashMap();
    private final Map<Integer, ParameterizedValueBuilder> valueBuilders = new HashMap();
    private final ParameterUtilities parameterUtilities;
    private ConversionResult conversionResult;

    public GuidedDecisionTableLHSBuilder(int row, int column, String colDefinition, ParameterUtilities parameterUtilities, ConversionResult conversionResult) {
        this.headerRow = row;
        this.headerCol = column;
        this.parameterUtilities = parameterUtilities;
        this.conversionResult = conversionResult;
        this.preProcessColumnDefinition(colDefinition);
    }

    private void preProcessColumnDefinition(String colDefinition) {
        String colDef;
        String string = colDef = colDefinition == null ? "" : colDefinition;
        if ("".equals(colDef)) {
            this.colDefSuffix = "";
            this.colDefPrefix = "";
            this.hasPattern = false;
            this.andop = "";
            return;
        }
        this.hasPattern = true;
        Matcher matEval = patEval.matcher(colDef);
        if (matEval.find()) {
            this.colDefPrefix = colDef.substring(0, matEval.start()) + "eval(";
            this.colDefSuffix = ")";
            this.andop = " && ";
            return;
        }
        this.andop = ", ";
        Matcher matParFrm = patParFrm.matcher(colDef);
        if (matParFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matParFrm.start()) + '(';
            this.colDefSuffix = ") from" + colDef.substring(matParFrm.end());
            return;
        }
        Matcher matFrm = patFrm.matcher(colDef);
        if (matFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matFrm.start()) + "(";
            this.colDefSuffix = ") from " + colDef.substring(matFrm.end());
            return;
        }
        Matcher matPar = patPar.matcher(colDef);
        if (matPar.find()) {
            this.colDefPrefix = colDef.substring(0, matPar.start()) + '(';
            this.colDefSuffix = ")" + colDef.substring(matPar.end());
            return;
        }
        this.colDefPrefix = colDef + '(';
        this.colDefSuffix = ")";
    }

    public void populateDecisionTable(GuidedDecisionTable52 dtable) {
        if (!this.hasPattern) {
            this.addExplicitColumns(dtable);
        } else {
            this.addPatternColumn(dtable);
        }
    }

    private void addExplicitColumns(GuidedDecisionTable52 dtable) {
        TreeSet sortedIndexes = new TreeSet(this.valueBuilders.keySet());
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = (ParameterizedValueBuilder)this.valueBuilders.get(index);
            if (vb instanceof LiteralValueBuilder) {
                this.addLiteralColumn(dtable, (LiteralValueBuilder)vb, index.intValue());
                continue;
            }
            this.addBRLFragmentColumn(dtable, vb, index.intValue());
        }
    }

    private void addLiteralColumn(GuidedDecisionTable52 dtable, LiteralValueBuilder vb, int index) {
        BRLConditionColumn column = new BRLConditionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.text = vb.getTemplate();
        column.getDefinition().add(ffl);
        BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn("", "Boolean");
        column.getChildColumns().add(parameterColumn);
        column.setHeader((String)this.columnHeaders.get(index));
        dtable.getConditions().add(column);
        List columnData = vb.getColumnData();
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    private void addBRLFragmentColumn(GuidedDecisionTable52 dtable, ParameterizedValueBuilder vb, int index) {
        BRLConditionColumn column = new BRLConditionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.text = vb.getTemplate();
        column.getDefinition().add(ffl);
        for (String parameter : vb.getParameters()) {
            BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn(parameter, "Object");
            column.getChildColumns().add(parameterColumn);
        }
        column.setHeader((String)this.columnHeaders.get(index));
        dtable.getConditions().add(column);
        List columnData = vb.getColumnData();
        int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(0));
        for (int iRow = 0; iRow < columnData.size(); ++iRow) {
            List rowData = (List)dtable.getData().get(iRow);
            rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
        }
    }

    private void addPatternColumn(GuidedDecisionTable52 dtable) {
        TreeSet sortedIndexes = new TreeSet(this.valueBuilders.keySet());
        String columnHeader = (String)this.columnHeaders.get(sortedIndexes.first());
        if (sortedIndexes.size() > 1) {
            columnHeader = "Converted from cell [" + RuleSheetParserUtil.rc2name((int)(this.headerRow + 1), (int)this.headerCol) + "]";
        }
        BRLConditionColumn column = new BRLConditionColumn();
        dtable.getConditions().add(column);
        FreeFormLine ffl = new FreeFormLine();
        column.getDefinition().add(ffl);
        StringBuffer drl = new StringBuffer();
        drl.append(this.colDefPrefix);
        String sep = "";
        int dataColumnIndex = 0;
        for (Integer index : sortedIndexes) {
            ParameterizedValueBuilder vb = (ParameterizedValueBuilder)this.valueBuilders.get(index);
            drl.append(sep).append(vb.getTemplate());
            sep = this.andop;
            for (String parameter : vb.getParameters()) {
                BRLConditionVariableColumn parameterColumn = new BRLConditionVariableColumn(parameter, "Object");
                column.getChildColumns().add(parameterColumn);
            }
            List columnData = vb.getColumnData();
            int iColIndex = dtable.getExpandedColumns().indexOf(column.getChildColumns().get(dataColumnIndex));
            for (int iRow = 0; iRow < columnData.size(); ++iRow) {
                List rowData = (List)dtable.getData().get(iRow);
                rowData.addAll(iColIndex, (Collection)columnData.get(iRow));
            }
            dataColumnIndex += vb.getParameters().size();
        }
        drl.append(this.colDefSuffix);
        ffl.text = drl.toString();
        column.setHeader(columnHeader);
    }

    public void addTemplate(int row, int column, String content) {
        if (this.valueBuilders.containsKey(column)) {
            String message = "Internal error: Can't have a code snippet added twice to one spreadsheet column.";
            this.conversionResult.addMessage("Internal error: Can't have a code snippet added twice to one spreadsheet column.", ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        content = content.trim();
        try {
            this.valueBuilders.put(column, this.getValueBuilder(content));
        }
        catch (DecisionTableParseException pe) {
            this.conversionResult.addMessage(pe.getMessage(), ConversionResult.ConversionMessageType.WARNING);
        }
    }

    public void setColumnHeader(int column, String value) {
        this.columnHeaders.put(column, value.trim());
    }

    private ParameterizedValueBuilder getValueBuilder(String template) {
        SnippetBuilder.SnippetType type = SnippetBuilder.getType((String)(template = template.trim()));
        if (type == SnippetBuilder.SnippetType.SINGLE) {
            type = SnippetBuilder.SnippetType.PARAM;
            boolean hasExplicitOperator = false;
            for (String op : operators) {
                if (!template.endsWith(op)) continue;
                hasExplicitOperator = true;
                break;
            }
            if (!hasExplicitOperator) {
                template = template + " ==";
            }
            template = template + " \"";
            template = template + "$param" + "\"";
        }
        switch (1.$SwitchMap$org$drools$template$model$SnippetBuilder$SnippetType[type.ordinal()]) {
            case 1: {
                return new IndexedParametersValueBuilder(template, this.parameterUtilities);
            }
            case 2: {
                return new SingleParameterValueBuilder(template, this.parameterUtilities);
            }
            case 3: {
                return new LiteralValueBuilder(template);
            }
        }
        throw new DecisionTableParseException("SnippetBuilder.SnippetType '" + type.toString() + "' is not supported. The column will not be added.");
    }

    public void addCellValue(int row, int column, String value) {
        ParameterizedValueBuilder vb = (ParameterizedValueBuilder)this.valueBuilders.get(column);
        if (vb == null) {
            String message = "No code snippet for CONDITION, above cell " + RuleSheetParserUtil.rc2name((int)(this.headerRow + 2), (int)this.headerCol);
            this.conversionResult.addMessage(message, ConversionResult.ConversionMessageType.ERROR);
            return;
        }
        vb.addCellValue(row, column, value);
    }

    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.CONDITION;
    }

    public String getResult() {
        throw new UnsupportedOperationException("GuidedDecisionTableLHSBuilder does not return DRL.");
    }

    public void clearValues() {
        throw new UnsupportedOperationException();
    }

    public boolean hasValues() {
        throw new UnsupportedOperationException();
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
        operators.add("memberOf");
        operators.add("str[startsWith]");
        operators.add("str[endsWith]");
        operators.add("str[length]");
        patParFrm = Pattern.compile("\\(\\s*\\)\\s*from\\b");
        patFrm = Pattern.compile("\\s+from\\s+");
        patPar = Pattern.compile("\\(\\s*\\)");
        patEval = Pattern.compile("\\beval\\s*(?:\\(\\s*\\)\\s*)?$");
    }
}

