/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.server.TestScenarioServiceImplementation;
import org.drools.guvnor.server.files.AssetZipper;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.files.PackageDeploymentURIHelper;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class PackageDeploymentServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 510L;
    private static final String RFC822DATEFORMAT = "EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z";
    private static final Locale HEADER_LOCALE = Locale.US;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private TestScenarioServiceImplementation testScenarioServiceImplementation;
    @Inject
    private FileManagerService fileManagerService;

    protected long getLastModified(HttpServletRequest request) {
        PackageDeploymentURIHelper helper = null;
        try {
            helper = new PackageDeploymentURIHelper(request.getRequestURI());
            return this.fileManagerService.getLastModified(helper.getPackageName(), helper.getVersion());
        }
        catch (UnsupportedEncodingException e) {
            return super.getLastModified(request);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("HEAD")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(RFC822DATEFORMAT, HEADER_LOCALE);
            PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(request.getRequestURI());
            long mod = this.fileManagerService.getLastModified(helper.getPackageName(), helper.getVersion());
            response.addHeader("lastModified", "" + mod);
            response.addHeader("Last-Modified", dateFormat.format(new Date(mod)));
        } else {
            super.doHead(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String packageName = request.getParameter("packageName");
        FormData data = FileManagerService.getFormData((HttpServletRequest)request);
        try {
            this.fileManagerService.importClassicDRL(data.getFile().getInputStream(), packageName);
            response.getWriter().write("OK");
        }
        catch (IllegalArgumentException e) {
            response.getWriter().write(e.getMessage());
        }
        catch (RulesRepositoryException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, (RepositoryServlet.Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doRunScenarios(PackageDeploymentURIHelper helper, ByteArrayOutputStream out) throws IOException {
        ModuleItem pkg = helper.isLatest() ? this.rulesRepository.loadModule(helper.getPackageName()) : this.rulesRepository.loadModuleSnapshot(helper.getPackageName(), helper.getVersion());
        try {
            BulkTestRunResult result = this.testScenarioServiceImplementation.runScenariosInPackage(pkg);
            out.write(result.toString().getBytes());
        }
        catch (DetailedSerializationException e) {
            this.log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
        catch (SerializationException e) {
            this.log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
    }

    public InputStream zipModel(ModuleItem pkg) {
        LinkedList<AssetItem> jarAssets = new LinkedList<AssetItem>();
        AssetZipper assetZipper = null;
        Iterator it = pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (!asset.getFormat().contentEquals("jar")) continue;
            jarAssets.add(asset);
        }
        if (jarAssets.size() != 0) {
            assetZipper = new AssetZipper(jarAssets, pkg);
            return assetZipper.zipAssets();
        }
        return null;
    }

    static /* synthetic */ FileManagerService access$000(PackageDeploymentServlet x0) {
        return x0.fileManagerService;
    }

    static /* synthetic */ RulesRepository access$100(PackageDeploymentServlet x0) {
        return x0.rulesRepository;
    }

    static /* synthetic */ void access$200(PackageDeploymentServlet x0, PackageDeploymentURIHelper x1, ByteArrayOutputStream x2) throws IOException {
        x0.doRunScenarios(x1, x2);
    }
}

