/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.core.Assert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.WritableAssertionInfo;
import org.fest.assertions.description.Description;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.Conditions;
import org.fest.assertions.internal.Objects;
import org.fest.util.VisibleForTesting;

public abstract class AbstractAssert<S extends AbstractAssert<S, A>, A>
implements Assert<S, A> {
    @VisibleForTesting
    Objects objects = Objects.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();
    @VisibleForTesting
    final WritableAssertionInfo info;
    @VisibleForTesting
    protected final A actual;
    protected final S myself;

    protected AbstractAssert(A actual, Class<?> selfType) {
        this.myself = (AbstractAssert)selfType.cast(this);
        this.actual = actual;
        this.info = new WritableAssertionInfo();
    }

    protected WritableAssertionInfo getWritableAssertionInfo() {
        return this.info;
    }

    @Override
    public S as(String description) {
        return (S)this.describedAs(description);
    }

    @Override
    public S as(Description description) {
        return (S)this.describedAs(description);
    }

    @Override
    public S describedAs(String description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public S describedAs(Description description) {
        this.info.description(description);
        return this.myself;
    }

    @Override
    public S isEqualTo(A expected) {
        this.objects.assertEqual(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public S isNotEqualTo(A other) {
        this.objects.assertNotEqual(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public void isNull() {
        this.objects.assertNull(this.info, this.actual);
    }

    @Override
    public S isNotNull() {
        this.objects.assertNotNull(this.info, this.actual);
        return this.myself;
    }

    @Override
    public S isSameAs(A expected) {
        this.objects.assertSame(this.info, this.actual, expected);
        return this.myself;
    }

    @Override
    public S isNotSameAs(A other) {
        this.objects.assertNotSame(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S isIn(A ... values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isNotIn(A ... values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isIn(Iterable<? extends A> values) {
        this.objects.assertIsIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S isNotIn(Iterable<? extends A> values) {
        this.objects.assertIsNotIn((AssertionInfo)this.info, this.actual, values);
        return this.myself;
    }

    @Override
    public S is(Condition<? super A> condition) {
        this.conditions.assertIs(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S isNot(Condition<? super A> condition) {
        this.conditions.assertIsNot(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S has(Condition<? super A> condition) {
        this.conditions.assertHas(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S doesNotHave(Condition<? super A> condition) {
        this.conditions.assertDoesNotHave(this.info, this.actual, condition);
        return this.myself;
    }

    @Override
    public S isInstanceOf(Class<?> type) {
        this.objects.assertIsInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S isNotInstanceOf(Class<?> type) {
        this.objects.assertIsNotInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isNotInstanceOfAny(Class<?> ... types) {
        this.objects.assertIsNotInstanceOfAny(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S hasSameClassAs(Object other) {
        this.objects.assertHasSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S doesNotHaveSameClassAs(Object other) {
        this.objects.assertDoesNotHaveSameClassAs(this.info, this.actual, other);
        return this.myself;
    }

    @Override
    public S isExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isNotExactlyInstanceOf(Class<?> type) {
        this.objects.assertIsNotExactlyInstanceOf(this.info, this.actual, type);
        return this.myself;
    }

    @Override
    public S isOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    @Override
    public S isNotOfAnyClassIn(Class<?> ... types) {
        this.objects.assertIsNotOfAnyClassIn(this.info, this.actual, types);
        return this.myself;
    }

    public String descriptionText() {
        return this.info.descriptionText();
    }

    public S overridingErrorMessage(String newErrorMessage, Object ... args) {
        this.info.overridingErrorMessage(String.format(newErrorMessage, args));
        return this.myself;
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        this.objects = new Objects(new ComparatorBasedComparisonStrategy(customComparator));
        return this.myself;
    }

    @Override
    public S usingDefaultComparator() {
        this.objects = Objects.instance();
        return this.myself;
    }

    @Override
    public final boolean equals(Object obj) {
        throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
    }

    public final int hashCode() {
        return 1;
    }
}

