/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.List;
import org.fest.util.Collections;
import org.fest.util.StackTraces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Throwables {
    public static void appendCurrentThreadStackTraceToThrowable(Throwable t, String methodToStartFrom) {
        List<StackTraceElement[]> stackTrace = Collections.list(t.getStackTrace());
        stackTrace.addAll(Throwables.currentThreadStackTrace(methodToStartFrom));
        t.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    public static void removeFestRelatedElementsFromStackTrace(Throwable throwable) {
        List<StackTraceElement[]> filteredStackTrace = Collections.list(throwable.getStackTrace());
        StackTraceElement previousStackTraceElement = null;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (stackTraceElement.getClassName().contains("org.fest")) {
                filteredStackTrace.remove(stackTraceElement);
                if (Throwables.stackTraceElementClassNameIs(previousStackTraceElement, "java.lang.reflect.Constructor") && stackTraceElement.getClassName().contains("org.fest.assertions.error.ConstructorInvoker")) {
                    filteredStackTrace.remove(previousStackTraceElement);
                }
            }
            previousStackTraceElement = stackTraceElement;
        }
        throwable.setStackTrace(filteredStackTrace.toArray(new StackTraceElement[filteredStackTrace.size()]));
    }

    private static boolean stackTraceElementClassNameIs(StackTraceElement stackTraceElement, String className) {
        if (stackTraceElement == null) {
            return false;
        }
        return stackTraceElement.getClassName().equals(className);
    }

    private static List<StackTraceElement> currentThreadStackTrace(String methodToStartFrom) {
        List<StackTraceElement> filtered = Throwables.stackTraceInCurrentThread();
        ArrayList<StackTraceElement> toRemove = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : filtered) {
            if (methodToStartFrom.equals(e.getMethodName())) break;
            toRemove.add(e);
        }
        filtered.removeAll(toRemove);
        return filtered;
    }

    private static List<StackTraceElement> stackTraceInCurrentThread() {
        return Collections.list(StackTraces.instance().stackTraceInCurrentThread());
    }

    private Throwables() {
    }
}

