/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.awt.Dimension;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Dates;
import org.fest.util.Maps;
import org.fest.util.Strings;

public final class ToString {
    public static String toStringOf(Object o) {
        if (Arrays.isArray(o)) {
            return Arrays.format(o);
        }
        if (o instanceof Calendar) {
            return ToString.toStringOf((Calendar)o);
        }
        if (o instanceof Class) {
            return ToString.toStringOf((Class)o);
        }
        if (o instanceof Collection) {
            return ToString.toStringOf((Collection)o);
        }
        if (o instanceof Date) {
            return ToString.toStringOf((Date)o);
        }
        if (o instanceof Float) {
            return ToString.toStringOf((Float)o);
        }
        if (o instanceof Long) {
            return ToString.toStringOf((Long)o);
        }
        if (o instanceof Dimension) {
            return ToString.toStringOf(o);
        }
        if (o instanceof File) {
            return ToString.toStringOf((File)o);
        }
        if (o instanceof Map) {
            return ToString.toStringOf((Map)o);
        }
        if (o instanceof String) {
            return Strings.quote((String)o);
        }
        if (o instanceof Comparator) {
            return ToString.toStringOf((Comparator)o);
        }
        return o == null ? null : o.toString();
    }

    private static String toStringOf(Comparator<?> comparator) {
        String comparatorSimpleClassName = comparator.getClass().getSimpleName();
        return Strings.quote(!comparatorSimpleClassName.isEmpty() ? comparatorSimpleClassName : "Anonymous Comparator class");
    }

    private static String toStringOf(Calendar c) {
        return Dates.formatAsDatetime(c);
    }

    private static String toStringOf(Class<?> c) {
        return c.getCanonicalName();
    }

    private static String toStringOf(Collection<?> c) {
        return Collections.format(c);
    }

    private static String toStringOf(Date d) {
        return Dates.formatAsDatetime(d);
    }

    private static String toStringOf(Float f) {
        return String.format("%sf", f);
    }

    private static String toStringOf(Long l) {
        return String.format("%sL", l);
    }

    private static String toStringOf(File f) {
        return f.getAbsolutePath();
    }

    private static String toStringOf(Map<?, ?> m) {
        return Maps.format(m);
    }

    private ToString() {
    }
}

