/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;

public class LineRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 7216549683820618553L;
    private Location loStart;
    private Location loEnd;
    protected LineAttributes lia;

    public LineRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void setStart(Location _loStart) {
        this.loStart = _loStart;
    }

    public final Location getStart() {
        return this.loStart;
    }

    public final void setEnd(Location _loEnd) {
        this.loEnd = _loEnd;
    }

    public final Location getEnd() {
        return this.loEnd;
    }

    public final void setLineAttributes(LineAttributes _lia) {
        this.lia = _lia;
    }

    public final LineAttributes getLineAttributes() {
        return this.lia;
    }

    public final Bounds getBounds() {
        double dMinX = Math.min(this.loStart.getX(), this.loEnd.getX());
        double dMaxX = Math.max(this.loStart.getX(), this.loEnd.getX());
        double dMinY = Math.min(this.loStart.getY(), this.loEnd.getY());
        double dMaxY = Math.max(this.loStart.getY(), this.loEnd.getY());
        return BoundsImpl.create(dMinX, dMinY, dMaxX - dMinX, dMaxY - dMinY);
    }

    public PrimitiveRenderEvent copy() {
        LineRenderEvent lre = new LineRenderEvent(this.source);
        if (this.lia != null) {
            lre.setLineAttributes(LineAttributesImpl.copyInstance(this.lia));
        }
        if (this.loStart != null) {
            lre.setStart(LocationImpl.copyInstance(this.loStart));
        }
        if (this.loEnd != null) {
            lre.setEnd(LocationImpl.copyInstance(this.loEnd));
        }
        return lre;
    }

    public void fill(IDeviceRenderer idr) throws ChartException {
        this.draw(idr);
    }

    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawLine(this);
    }

    public void reset() {
        this.loEnd = null;
        this.loStart = null;
        this.lia = null;
    }
}

