/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.data.engine.api.IConditionalExpression;

public abstract class Expression {
    public static final int CONSTANT = 0;
    public static final int SCRIPT = 1;
    public static final int CONDITIONAL = 2;
    public static final String SCRIPT_JAVASCRIPT = "javascript";
    protected String scriptText;

    public abstract int getType();

    public String getScriptText() {
        return this.scriptText;
    }

    public String toString() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public static Expression newConstant(int valueType, String expression) {
        return new Constant(valueType, expression);
    }

    public static Constant newConstant(String expression) {
        return new Constant(expression);
    }

    public static Script newScript(String expression) {
        return new Script(SCRIPT_JAVASCRIPT, "<inline>", 1, expression);
    }

    public static Script newScript(String language, String expression) {
        return new Script(language, "<inline>", 1, expression);
    }

    public static Conditional newConditional(IConditionalExpression condExpr) {
        return new Conditional(condExpr);
    }

    public static Script newScript(String language, String fileName, int lineNumber, String expression) {
        return new Script(language, fileName, lineNumber, expression);
    }

    public static class Conditional
    extends Expression {
        IConditionalExpression expr;

        public Conditional(IConditionalExpression expr) {
            this.expr = expr;
        }

        public int getType() {
            return 2;
        }

        public IConditionalExpression getConditionalExpression() {
            return this.expr;
        }

        public String toString() {
            if (this.expr != null) {
                return this.expr.toString();
            }
            return "";
        }
    }

    public static class Constant
    extends Expression {
        static final Object NOT_EVALUATED = new String("not evaluated");
        Object value;
        int valueType;

        public Constant(int valueType, String expression) {
            this.valueType = valueType;
            this.scriptText = expression;
            this.value = NOT_EVALUATED;
        }

        public Constant(String expression) {
            this(-1, expression);
        }

        public int getType() {
            return 0;
        }

        public int getValueType() {
            return this.valueType;
        }

        public Object getValue() {
            if (this.value == NOT_EVALUATED) {
                try {
                    this.value = DataTypeUtil.convert((Object)this.scriptText, (int)this.valueType);
                }
                catch (BirtException birtException) {
                    this.value = null;
                }
            }
            return this.value;
        }
    }

    public static class Script
    extends Expression {
        transient ICompiledScript compiledScript;
        String language;
        String fileName;
        int lineNumber;

        public Script(String language, String fileName, int lineNumber, String scriptText) {
            this.language = language;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
            this.scriptText = scriptText;
        }

        public int getType() {
            return 1;
        }

        public ICompiledScript getScriptExpression() {
            return this.compiledScript;
        }

        public void setCompiledScript(ICompiledScript compiledScript) {
            this.compiledScript = compiledScript;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

