/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelValidator
extends EObjectValidator {
    public static final ModelValidator INSTANCE = new ModelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.birt.chart.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final double COVERAGE_TYPE__MIN__VALUE = 0.0;
    public static final double COVERAGE_TYPE__MAX__VALUE = 1.0;

    protected EPackage getEPackage() {
        return ModelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateChart((Chart)value, diagnostics, context);
            }
            case 1: {
                return this.validateChartWithAxes((ChartWithAxes)value, diagnostics, context);
            }
            case 2: {
                return this.validateChartWithoutAxes((ChartWithoutAxes)value, diagnostics, context);
            }
            case 3: {
                return this.validateDialChart((DialChart)value, diagnostics, context);
            }
            case 4: {
                return this.validateCoverageType((Double)value, diagnostics, context);
            }
            case 5: {
                return this.validateCoverageTypeObject((Double)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateChart(Chart chart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(chart, diagnostics, context);
    }

    public boolean validateChartWithAxes(ChartWithAxes chartWithAxes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(chartWithAxes, diagnostics, context);
    }

    public boolean validateChartWithoutAxes(ChartWithoutAxes chartWithoutAxes, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(chartWithoutAxes, diagnostics, context);
    }

    public boolean validateDialChart(DialChart dialChart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dialChart, diagnostics, context);
    }

    public boolean validateCoverageType(double coverageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCoverageType_Min(coverageType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateCoverageType_Max(coverageType, diagnostics, context);
        }
        return result;
    }

    public boolean validateCoverageType_Min(double coverageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = coverageType >= 0.0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(ModelPackage.Literals.COVERAGE_TYPE, coverageType, 0.0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateCoverageType_Max(double coverageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = coverageType <= 1.0;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(ModelPackage.Literals.COVERAGE_TYPE, coverageType, 1.0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateCoverageTypeObject(Double coverageTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateCoverageType_Min(coverageTypeObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateCoverageType_Max(coverageTypeObject, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

