/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal;

import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.script.api.IChartWithAxes;
import org.eclipse.birt.chart.script.api.component.IAxis;
import org.eclipse.birt.chart.script.api.component.ICategory;
import org.eclipse.birt.chart.script.api.component.IValueSeries;
import org.eclipse.birt.chart.script.internal.ChartImpl;
import org.eclipse.birt.chart.script.internal.component.AxisImpl;
import org.eclipse.birt.chart.script.internal.component.CategoryImpl;
import org.eclipse.birt.chart.script.internal.component.ValueSeriesImpl;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.emf.common.util.EList;

public class ChartWithAxesImpl
extends ChartImpl
implements IChartWithAxes {
    public ChartWithAxesImpl(ExtendedItemHandle eih, ChartWithAxes cm) {
        super(eih, cm);
    }

    public IAxis getCategoryAxis() {
        return new AxisImpl((Axis)this.getChartWithAxes().getAxes().get(0));
    }

    public IAxis[] getValueAxes() {
        Axis bAxis = (Axis)this.getChartWithAxes().getAxes().get(0);
        EList<Axis> oAxes = bAxis.getAssociatedAxes();
        IAxis[] valueAxes = new IAxis[oAxes.size()];
        int i = 0;
        while (i < valueAxes.length) {
            valueAxes[i] = new AxisImpl((Axis)oAxes.get(i));
            ++i;
        }
        return valueAxes;
    }

    public IValueSeries[][] getValueSeries() {
        Axis bAxis = (Axis)this.getChartWithAxes().getAxes().get(0);
        EList<Axis> oAxes = bAxis.getAssociatedAxes();
        IValueSeries[][] valueSeries = new IValueSeries[oAxes.size()][];
        int i = 0;
        while (i < oAxes.size()) {
            Axis oAxis = (Axis)oAxes.get(i);
            EList<SeriesDefinition> oSeries = oAxis.getSeriesDefinitions();
            valueSeries[i] = new IValueSeries[oSeries.size()];
            int j = 0;
            while (j < oSeries.size()) {
                SeriesDefinition sd = (SeriesDefinition)oSeries.get(j);
                valueSeries[i][j] = ValueSeriesImpl.createValueSeries(sd, this.cm);
                ++j;
            }
            ++i;
        }
        return valueSeries;
    }

    public boolean isHorizontal() {
        return this.getChartWithAxes().isTransposed();
    }

    public void setHorizontal(boolean horizontal) {
        this.getChartWithAxes().setTransposed(horizontal);
    }

    public ICategory getCategory() {
        Axis bAxis = (Axis)this.getChartWithAxes().getAxes().get(0);
        SeriesDefinition bSd = (SeriesDefinition)bAxis.getSeriesDefinitions().get(0);
        return new CategoryImpl(bSd, this.cm);
    }

    private ChartWithAxes getChartWithAxes() {
        return (ChartWithAxes)this.cm;
    }

    public void setDimension(String dimensionName) {
        super.setDimension(dimensionName);
        if (ChartDimension.THREE_DIMENSIONAL_LITERAL.getName().equals(dimensionName)) {
            this.create3DModel();
        }
    }

    private void create3DModel() {
        this.getChartWithAxes().setRotation(Rotation3DImpl.create(new Angle3D[]{Angle3DImpl.create(-20.0, 45.0, 0.0)}));
        this.getChartWithAxes().getPrimaryBaseAxes()[0].getAncillaryAxes().clear();
        Axis zAxisAncillary = org.eclipse.birt.chart.model.component.impl.AxisImpl.create(3);
        zAxisAncillary.setTitlePosition(Position.BELOW_LITERAL);
        zAxisAncillary.getTitle().getCaption().setValue("Z Axis");
        zAxisAncillary.getTitle().setVisible(true);
        zAxisAncillary.setPrimaryAxis(true);
        zAxisAncillary.setLabelPosition(Position.BELOW_LITERAL);
        zAxisAncillary.setOrientation(Orientation.HORIZONTAL_LITERAL);
        zAxisAncillary.getOrigin().setType(IntersectionType.MIN_LITERAL);
        zAxisAncillary.getOrigin().setValue(NumberDataElementImpl.create(0.0));
        zAxisAncillary.getTitle().setVisible(false);
        zAxisAncillary.setType(AxisType.TEXT_LITERAL);
        this.getChartWithAxes().getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
        this.getChartWithAxes().getPrimaryOrthogonalAxis(this.getChartWithAxes().getPrimaryBaseAxes()[0]).getTitle().getCaption().getFont().setRotation(0.0);
        SeriesDefinition sdZ = SeriesDefinitionImpl.create();
        sdZ.getSeriesPalette().shift(0);
        sdZ.getSeries().add((Object)SeriesImpl.create());
        zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        BaseSampleData sdAncillary = DataFactory.eINSTANCE.createBaseSampleData();
        sdAncillary.setDataSetRepresentation("Series 1");
        sd.getAncillarySampleData().add((Object)sdAncillary);
    }
}

