/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

class GroupInstanceFilter {
    private ResultSetPopulator populator;
    private FilterPassController filterPass = new FilterPassController();
    private GroupProcessorManager groupProcessor;
    private String tempDir;

    GroupInstanceFilter(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
        this.tempDir = this.populator.getSession().getTempDir();
    }

    public void doGroupFiltering(ScriptContext cx) throws DataException {
        ArrayList groupLevels = new ArrayList();
        ArrayList expressionList = new ArrayList();
        this.populateGroupFilteringExpressions(expressionList, groupLevels);
        if (expressionList.size() > 0) {
            this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 3);
            List[] groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
            this.populateFiltersInGroupBoundaryInfoSets(cx, groupBoundaryInfos);
            groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().filterGroupBoundaryInfos(groupBoundaryInfos);
            OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupBoundaryInfos);
            this.populator.reSetSmartCacheUsingOrderingInfo(odInfo);
        }
    }

    private void populateGroupFilteringExpressions(List expressionList, List groupLevels) {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupFilters = this.populator.getQuery().getGrouping()[i].getFilters();
            String name = this.populator.getQuery().getGrouping()[i].getName();
            if (groupFilters != null) {
                int j = 0;
                while (j < groupFilters.size()) {
                    if (((IFilterDefinition)groupFilters.get(j)).updateAggregation()) {
                        IBaseExpression expr = ((IFilterDefinition)groupFilters.get(j)).getExpression();
                        expr.setGroupName(name);
                        expressionList.add(expr);
                        groupLevels.add(i + 1);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void populateFiltersInGroupBoundaryInfoSets(ScriptContext cx, List[] groupBoundaryInfos) throws DataException {
        int i = 1;
        while (i <= this.populator.getQuery().getGrouping().length) {
            List filters = this.populator.getQuery().getGrouping()[i - 1].getFilters();
            if (filters != null && filters.size() != 0) {
                this.populator.getResultIterator().first(0);
                if (FilterUtil.hasMutipassFilters(filters)) {
                    this.populateGroupBoundaryInfoFilterValues(cx, groupBoundaryInfos, i, filters);
                } else {
                    this.populateGroupBoundaryInfoFilters(cx, groupBoundaryInfos[i - 1], filters, i, true);
                }
                groupBoundaryInfos = this.groupProcessor.getGroupCalculationUtil().filterGroupBoundaryInfos(groupBoundaryInfos);
                int j = 0;
                while (j < filters.size()) {
                    IFilterDefinition fd = (IFilterDefinition)filters.get(j);
                    if (FilterUtil.isFilterNeedMultiPass(fd)) {
                        fd.getExpression().setHandle(null);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void populateGroupBoundaryInfoFilterValues(ScriptContext cx, List[] groupBoundaryInfos, int i, List groupedFilters) throws DataException {
        if (i > 1) {
            int passedGroups = 0;
            int k = 0;
            while (k < groupBoundaryInfos[i - 2].size()) {
                CachedList currentGroupArray = new CachedList(this.tempDir, DataEngineSession.getCurrentClassLoader(), GroupBoundaryInfo.getCreator());
                int n = 0;
                while (n < groupBoundaryInfos[i - 1].size()) {
                    if (((GroupBoundaryInfo)groupBoundaryInfos[i - 2].get(k)).isInBoundary((GroupBoundaryInfo)groupBoundaryInfos[i - 1].get(n))) {
                        currentGroupArray.add(groupBoundaryInfos[i - 1].get(n));
                    }
                    ++n;
                }
                this.makeAGroupFilteringMultiPass(cx, i, groupedFilters, currentGroupArray, passedGroups);
                passedGroups += currentGroupArray.size();
                ++k;
            }
        } else {
            this.makeAGroupFilteringMultiPass(cx, i, groupedFilters, groupBoundaryInfos[i - 1], 0);
        }
    }

    private void makeAGroupFilteringMultiPass(ScriptContext cx, int groupLevel, List filters, List currentGroupArray, int startingGroupInstanceIndex) throws DataException {
        this.advanceResultIteratorCursor(groupLevel, startingGroupInstanceIndex);
        this.filterPass.setPassLevel(1);
        this.filterPass.setRowCount(currentGroupArray.size());
        this.populateGroupBoundaryInfoFilters(cx, currentGroupArray, filters, groupLevel, false);
        this.advanceResultIteratorCursor(groupLevel, startingGroupInstanceIndex);
        this.filterPass.setPassLevel(2);
        this.populateGroupBoundaryInfoFilters(cx, currentGroupArray, filters, groupLevel, true);
        this.filterPass.setPassLevel(0);
        this.filterPass.setRowCount(-1);
        this.filterPass.setSecondPassRowCount(0);
    }

    private void advanceResultIteratorCursor(int groupLevel, int startingGroupInstanceIndex) throws DataException {
        this.populator.getResultIterator().first(0);
        int i = 0;
        while (i < startingGroupInstanceIndex) {
            this.populator.getResultIterator().last(groupLevel);
            this.populator.getResultIterator().next();
            ++i;
        }
    }

    private void populateGroupBoundaryInfoFilters(ScriptContext cx, List currentGroupArray, List filters, int groupLevel, boolean setUpValue) throws DataException {
        int m = 0;
        while (m < currentGroupArray.size()) {
            GroupBoundaryInfo currentGBI = (GroupBoundaryInfo)currentGroupArray.get(m);
            this.populator.getResultIterator().last(groupLevel);
            boolean accept = this.evaluateFilters(cx, filters);
            if (setUpValue) {
                currentGBI.setAccepted(currentGBI.isAccpted() && accept);
            }
            this.populator.getResultIterator().next();
            ++m;
        }
    }

    private boolean evaluateFilters(ScriptContext cx, List groupFilters) throws DataException {
        int j = 0;
        while (j < groupFilters.size()) {
            Object result = this.evaluteFilterExpression(cx, (IFilterDefinition)groupFilters.get(j));
            try {
                if (!DataTypeUtil.toBoolean(result).booleanValue()) {
                    return false;
                }
            }
            catch (BirtException e) {
                DataException e1 = new DataException("data.engine.DataConversionError", e);
                throw e1;
            }
            ++j;
        }
        return true;
    }

    private Object evaluteFilterExpression(ScriptContext cx, IFilterDefinition filter) throws DataException {
        IBaseExpression expr = filter.getExpression();
        FilterUtil.prepareFilterExpression(this.tempDir, expr, this.filterPass, this.populator.getEventHandler().getExecutorHelper());
        Object result = ScriptEvalUtil.evalExpr(expr, cx.newContext(this.groupProcessor.getExpressionProcessor().getScope()), ScriptExpression.defaultID, 0);
        if (result == null) {
            Object info = null;
            info = expr instanceof IScriptExpression ? ((IScriptExpression)expr).getText() : expr;
            throw new DataException("data.engine.BadFilterExpr", info);
        }
        return result;
    }
}

