/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ColumnBindingMetaData
implements IResultMetaData {
    List<Binding> bindingList = new ArrayList<Binding>();
    Map aliasMap;

    public ColumnBindingMetaData(IBaseQueryDefinition queryDefn, IResultClass rsClass) throws DataException {
        this.bindingList.addAll(queryDefn.getBindings().values());
        if (((QueryDefinition)queryDefn).needAutoBinding() && rsClass != null) {
            ResultMetaData metaData = new ResultMetaData(rsClass);
            this.aliasMap = new HashMap();
            int columnCount = metaData.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                int colIndex = i + 1;
                try {
                    String colName = metaData.getColumnName(colIndex);
                    if (!this.isTemp(colName)) {
                        String alias = metaData.getColumnAlias(colIndex);
                        if (alias != null) {
                            this.aliasMap.put(colIndex, alias);
                        }
                        ScriptExpression baseExpr = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression(colName), metaData.getColumnType(colIndex));
                        Binding binding = new Binding(colName, baseExpr);
                        binding.setDisplayName(metaData.getColumnLabel(colIndex));
                        this.bindingList.add(binding);
                    }
                }
                catch (BirtException birtException) {}
                ++i;
            }
        }
    }

    private boolean isTemp(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E") || "_$$_dte_inner_row_id_$$_".equals(name);
    }

    public String getColumnAlias(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        if (this.aliasMap == null) {
            return null;
        }
        return this.aliasMap.get(index) == null ? null : this.aliasMap.get(index).toString();
    }

    public int getColumnCount() {
        return this.bindingList.size();
    }

    public String getColumnLabel(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getDisplayName();
    }

    public String getColumnName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getBindingName();
    }

    public String getColumnNativeTypeName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        return null;
    }

    public int getColumnType(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return binding.getDataType();
    }

    public String getColumnTypeName(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        IBinding binding = this.bindingList.get(index - 1);
        return DataType.getName(binding.getDataType());
    }

    public boolean isComputedColumn(int index) throws BirtException {
        if (index <= 0 | index > this.bindingList.size()) {
            throw new DataException("data.engine.InvalidFieldIndex");
        }
        return false;
    }
}

