/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.IRDAggrUtil;
import org.eclipse.birt.data.engine.impl.document.IRDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.ProgressiveViewingRDAggrUtil;
import org.eclipse.birt.data.engine.impl.document.RDAggrUtil;
import org.eclipse.birt.data.engine.impl.document.RDLoadUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataReader2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;

public class ExprResultSet
implements IExprResultSet {
    protected RAInputStream rowExprsRAIs;
    protected RAInputStream rowLenRAIs;
    protected RAInputStream rowInfoRAIs;
    protected int rowCount;
    protected int version;
    private boolean isBasedOnSecondRD;
    private int rowIdStartingIndex;
    protected IRDGroupUtil rdGroupUtil;
    protected IExprDataReader exprResultReader;
    protected StreamManager streamManager;
    protected DataSetResultSet dataSetResultSet;
    protected String tempDir;
    private IRDAggrUtil aggrUtil = null;
    private IBaseQueryDefinition qd;
    private List<RAInputStream> aggrIndexStreams;
    private List<RAInputStream> aggrStreams;

    public ExprResultSet(String tempDir, StreamManager streamManager, int version, boolean isBasedOnSecondRD, DataSetResultSet dataSetResultSet, int rowIdStartingIndex, IBaseQueryDefinition qd) throws DataException {
        this.tempDir = tempDir;
        this.streamManager = streamManager;
        this.version = version;
        this.isBasedOnSecondRD = isBasedOnSecondRD;
        this.dataSetResultSet = dataSetResultSet;
        this.rowIdStartingIndex = rowIdStartingIndex;
        this.qd = qd;
        this.prepare();
        this.rdGroupUtil.setCacheProvider(new CacheProviderImpl(this));
    }

    public DataSetResultSet getDataSetResultSet() {
        return this.dataSetResultSet;
    }

    protected void prepare() throws DataException {
        this.rdGroupUtil = RDLoadUtil.loadGroupUtil(this.tempDir, this.streamManager, 0, 2);
        if (this.version >= 110) {
            this.aggrStreams = this.streamManager.getInStreams(104, 0, 2);
            if (!this.aggrStreams.isEmpty() || this.streamManager.hasInStream(106, 0, 2)) {
                this.aggrIndexStreams = this.streamManager.getInStreams(103, 0, 2);
                RAInputStream combinedAggrIndex = null;
                RAInputStream combinedAggrValue = null;
                if (this.streamManager.hasInStream(105, 0, 2)) {
                    combinedAggrIndex = this.streamManager.getInStream(105, 0, 2);
                }
                if (this.streamManager.hasInStream(106, 0, 2)) {
                    combinedAggrValue = this.streamManager.getInStream(106, 0, 2);
                }
                this.aggrUtil = new ProgressiveViewingRDAggrUtil(combinedAggrIndex, combinedAggrValue, this.aggrIndexStreams, this.aggrStreams);
            } else if (this.streamManager.hasInStream(103, 0, 2)) {
                this.aggrUtil = new RDAggrUtil(this.streamManager, this.qd);
            }
        }
        if (!this.isBasedOnSecondRD) {
            this.rowExprsRAIs = this.streamManager.getInStream(31, 0, 2);
            if (this.version > 0) {
                this.rowLenRAIs = this.streamManager.getInStream(33, 0, 2);
            }
            this.exprResultReader = new ExprDataReader1(this.rowExprsRAIs, this.rowLenRAIs, this.version, (DataSetResultSet)(this.qd instanceof IQueryDefinition && ((IQueryDefinition)this.qd).isSummaryQuery() ? null : this.dataSetResultSet));
            this.rowCount = this.exprResultReader.getCount();
        } else {
            this.rowExprsRAIs = this.streamManager.getInStream(31, 0, 0);
            this.rowLenRAIs = this.streamManager.getInStream(33, 0, 0);
            this.rowInfoRAIs = this.streamManager.getInStream(51, 0, 2);
            this.exprResultReader = new ExprDataReader2(this.tempDir, this.rowExprsRAIs, this.rowLenRAIs, this.rowInfoRAIs, this.version, (DataSetResultSet)(this.qd instanceof IQueryDefinition && ((IQueryDefinition)this.qd).isSummaryQuery() ? null : this.dataSetResultSet));
            this.rowCount = this.exprResultReader.getCount();
        }
    }

    public boolean next() throws DataException {
        boolean hasNext = this.exprResultReader.next();
        this.rdGroupUtil.next(hasNext);
        return hasNext;
    }

    public Object getValue(String name) throws DataException {
        Map exprValueMap = this.exprResultReader.getRowValue();
        if (exprValueMap == null) {
            throw new DataException("data.engine.ResultSetNotStart");
        }
        if (!exprValueMap.containsKey(name)) {
            if (this.aggrUtil == null || !this.aggrUtil.contains(name)) {
                throw new DataException("data.engine.InValidExpr");
            }
            return this.aggrUtil.getValue(name, this.aggrUtil.isRunningAggr(name) ? this.getCurrentIndex() : this.rdGroupUtil.getCurrentGroupIndex(this.aggrUtil.getGroupLevel(name)));
        }
        return exprValueMap.get(name);
    }

    public void moveTo(int rowIndex) throws DataException {
        this.exprResultReader.moveTo(rowIndex);
        this.rdGroupUtil.move();
    }

    public int getCurrentId() {
        return this.rowIdStartingIndex + this.exprResultReader.getRowId();
    }

    public int getCurrentIndex() {
        return this.exprResultReader.getRowIndex();
    }

    public int getStartingGroupLevel() throws DataException {
        return this.rdGroupUtil.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.rdGroupUtil.getEndingGroupLevel();
    }

    public void skipToEnd(int groupLevel) throws DataException {
        this.rdGroupUtil.last(groupLevel);
    }

    public int[] getGroupStartAndEndIndex(int groupIndex) throws DataException {
        return this.rdGroupUtil.getGroupStartAndEndIndex(groupIndex);
    }

    public void close() throws DataException {
        try {
            int i;
            if (this.exprResultReader != null) {
                this.exprResultReader.close();
                this.exprResultReader = null;
            }
            if (this.rowExprsRAIs != null) {
                this.rowExprsRAIs.close();
                this.rowExprsRAIs = null;
            }
            if (this.rowLenRAIs != null) {
                this.rowLenRAIs.close();
                this.rowLenRAIs = null;
            }
            if (this.rowInfoRAIs != null) {
                this.rowInfoRAIs.close();
                this.rowInfoRAIs = null;
            }
            if (this.dataSetResultSet != null) {
                this.dataSetResultSet.close();
                this.dataSetResultSet = null;
            }
            if (this.aggrUtil != null) {
                this.aggrUtil.close();
                this.aggrUtil = null;
            }
            if (this.rdGroupUtil != null) {
                this.rdGroupUtil.close();
                this.rdGroupUtil = null;
            }
            if (this.aggrIndexStreams != null) {
                i = 0;
                while (i < this.aggrIndexStreams.size()) {
                    this.aggrIndexStreams.get(i).close();
                    ++i;
                }
            }
            if (this.aggrStreams != null) {
                i = 0;
                while (i < this.aggrStreams.size()) {
                    this.aggrStreams.get(i).close();
                    ++i;
                }
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isEmpty() {
        return this.rowCount == 0;
    }

    public List[] getGroupInfos() throws DataException {
        return this.rdGroupUtil.getGroups();
    }

    private static class CacheProviderImpl
    implements CacheProvider {
        private ExprResultSet exprResultSet;

        public CacheProviderImpl(ExprResultSet exprResultSet) {
            this.exprResultSet = exprResultSet;
        }

        public int getCount() {
            return this.exprResultSet.rowCount;
        }

        public int getCurrentIndex() {
            return this.exprResultSet.getCurrentIndex();
        }

        public void moveTo(int destIndex) throws DataException {
            int currIndex = this.exprResultSet.getCurrentIndex();
            assert (destIndex >= currIndex);
            int forwardSteps = destIndex - currIndex;
            int i = 0;
            while (i < forwardSteps) {
                this.exprResultSet.next();
                ++i;
            }
        }

        public boolean next() throws DataException {
            return this.exprResultSet.next();
        }
    }
}

