/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;

public class DteMetaInfoIOUtil {
    protected static final String VERSION_1 = "__version__1";
    protected static final String VERSION_2 = "__version__2";

    public static void storeMetaInfo(DataOutputStream dos, String pRsetId, String rawId, String queryId, String rsetId, String rowId) throws IOException {
        IOUtil.writeString(dos, pRsetId);
        IOUtil.writeString(dos, rawId);
        IOUtil.writeString(dos, queryId);
        IOUtil.writeString(dos, rsetId);
        IOUtil.writeString(dos, rowId);
    }

    public static void startMetaInfo(DataOutputStream dos) throws IOException {
        IOUtil.writeString(dos, VERSION_2);
    }

    public static ArrayList loadAllDteMetaInfo(IDocArchiveReader archive) throws IOException {
        RAInputStream in;
        ArrayList result = new ArrayList();
        if (archive.exists("/Data/hierarchy")) {
            in = archive.getStream("/Data/hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream(in));
            }
            finally {
                in.close();
            }
        }
        if (archive.exists("/Data/snap_hierarchy")) {
            in = archive.getStream("/Data/snap_hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream(in));
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static ArrayList loadDteMetaInfo(IDocArchiveReader archive) throws IOException {
        ArrayList result = new ArrayList();
        if (archive.exists("/Data/snap_hierarchy")) {
            RAInputStream in = archive.getStream("/Data/snap_hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream(in));
            }
            finally {
                in.close();
            }
        }
        if (archive.exists("/Data/hierarchy")) {
            RAInputStream in = archive.getStream("/Data/hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream(in));
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static void loadDteMetaInfo(ArrayList result, DataInputStream dis) throws IOException {
        try {
            String rawId;
            String pRsetId;
            String version = IOUtil.readString(dis);
            boolean version1 = VERSION_1.equals(version);
            boolean version2 = VERSION_2.equals(version);
            String rowId = "-1";
            if (version1 || version2) {
                pRsetId = IOUtil.readString(dis);
                rawId = IOUtil.readString(dis);
            } else {
                pRsetId = version;
                rawId = String.valueOf(IOUtil.readLong(dis));
            }
            String queryId = IOUtil.readString(dis);
            String rsetId = IOUtil.readString(dis);
            if (version2) {
                rowId = IOUtil.readString(dis);
            }
            result.add(new String[]{pRsetId, rawId, queryId, rsetId, rowId});
            while (true) {
                pRsetId = IOUtil.readString(dis);
                rawId = version1 || version2 ? IOUtil.readString(dis) : String.valueOf(IOUtil.readLong(dis));
                queryId = IOUtil.readString(dis);
                rsetId = IOUtil.readString(dis);
                if (version2) {
                    rowId = IOUtil.readString(dis);
                }
                result.add(new String[]{pRsetId, rawId, queryId, rsetId, rowId});
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }
}

