/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt.device;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.birt.report.engine.emitter.ppt.PPTWriter;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class PPTPage
extends AbstractPage {
    private PPTWriter writer;
    private boolean isDisposed;
    private PPTUtil.HyperlinkDef link;

    public PPTPage(int pageWidth, int pageHeight, Color backgroundColor, PPTWriter writer) {
        super(pageWidth, pageHeight);
        writer.newPage(this.pageWidth, this.pageHeight, backgroundColor);
        this.writer = writer;
        this.isDisposed = false;
    }

    public void restoreState() {
    }

    public void saveState() {
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.writer.endPage();
            this.isDisposed = true;
        }
    }

    protected void clip(float startX, float startY, float width, float height) {
        this.writer.clip(startX, startY, width, height);
    }

    protected void clipEnd() {
        this.writer.clipEnd();
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        this.writer.drawBackgroundColor(color, x, y, width, height);
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, float imageWidth, float imageHeight, int repeat, String imageUrl, byte[] imageData, float absPosX, float absPosY) throws IOException {
        this.writer.drawBackgroundImage(imageUrl, imageData, x, y, width, height, imageWidth, imageHeight, absPosX, absPosY, repeat);
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        this.writer.drawImage(imageId, imageData, extension, imageX, imageY, height, width, helpText, this.link);
    }

    protected void drawImage(String uri, String extension, float imageX, float imageY, float height, float width, String helpText, Map params) throws Exception {
        int data;
        if (uri == null) {
            return;
        }
        InputStream imageStream = new URL(uri).openStream();
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        while ((data = imageStream.read()) != -1) {
            byteArrayOut.write(data);
        }
        this.drawImage(uri, byteArrayOut.toByteArray(), extension, imageX, imageY, height, width, helpText, params);
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, int lineStyle) {
        this.writer.drawLine(startX, startY, endX, endY, width, color, lineStyle);
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle textStyle) {
        FontInfo fontInfo = textStyle.getFontInfo();
        float descend = fontInfo.getBaseFont().getFontDescriptor(3, fontInfo.getFontSize());
        this.writer.drawText(text, textX, textY, width, height + descend * 0.6f, fontInfo, textStyle.getColor(), textStyle.isRtl(), this.link);
    }

    public void setLink(PPTUtil.HyperlinkDef link) {
        this.link = link;
    }
}

