/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;

public class CellLayout
extends BlockStackingLayout {
    protected TableLayout tableLayout = this.getTableLayoutManager();
    protected int columnWidth = 0;
    private ICellContent cellContent;

    public CellLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.cellContent = (ICellContent)content;
        int startColumn = this.cellContent.getColumn();
        int endColumn = startColumn + this.cellContent.getColSpan();
        this.columnWidth = this.tableLayout.getCellWidth(startColumn, endColumn);
        boolean isLastColumn = endColumn == this.tableLayout.getColumnCount();
        this.isInBlockStacking = this.tableLayout.isInBlockStacking && isLastColumn;
        this.isInline = true;
    }

    protected void createRoot() {
        CellArea cell = AreaFactory.createCellArea(this.cellContent);
        cell.setRowSpan(this.cellContent.getRowSpan());
        this.currentContext.root = cell;
        int startColumn = this.cellContent.getColumn();
        int endColumn = startColumn + this.cellContent.getColSpan();
        this.columnWidth = this.tableLayout.getCellWidth(startColumn, endColumn);
        this.tableLayout.resolveBorderConflict((CellArea)this.currentContext.root, true);
        this.removeMargin(this.currentContext.root.getStyle());
        this.currentContext.root.setWidth(this.columnWidth);
    }

    protected void initialize() {
        this.currentContext = new ContainerLayout.ContainerContext(this);
        this.contextList.add(this.currentContext);
        this.createRoot();
        this.validateBoxProperty(this.currentContext.root.getStyle(), this.columnWidth, this.context.getMaxHeight());
        this.offsetX = this.currentContext.root.getContentX();
        this.offsetY = this.currentContext.root.getContentY();
        this.currentContext.maxAvaWidth = this.currentContext.root.getContentWidth();
        this.currentContext.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.currentContext.maxAvaHeight = this.currentContext.root.getContentHeight();
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
        currentContext.root.setHeight(currentContext.currentBP + this.offsetY + this.getDimensionValue(currentContext.root.getStyle().getProperty(9)));
        this.parent.addToRoot((AbstractArea)currentContext.root, index);
    }

    protected void align(ContainerArea container) {
    }

    protected void closeLayout(int size, boolean finished) {
        int i = 0;
        while (i < size) {
            this.closeLayout((ContainerLayout.ContainerContext)this.contextList.removeFirst(), i, finished && i == size - 1);
            ++i;
        }
        if (this.contextList.size() > 0) {
            this.currentContext = (ContainerLayout.ContainerContext)this.contextList.getFirst();
        }
    }
}

