/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf;

import com.ibm.icu.util.ULocale;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.odf.MasterPageManager;
import org.eclipse.birt.report.engine.odf.SpanInfo;
import org.eclipse.birt.report.engine.odf.TableInfo;
import org.eclipse.birt.report.engine.odf.pkg.ImageManager;
import org.eclipse.birt.report.engine.odf.pkg.Package;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.style.StyleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractOdfEmitterContext {
    protected int dpi = 96;
    protected String tempFileDir;
    protected ULocale locale;
    protected Package pkg;
    protected ImageManager imageManager;
    protected StyleManager styleManager;
    protected StyleManager globalStyleManager;
    protected LinkedList<TableInfo> tables = new LinkedList();
    protected Stack<Boolean> cellind = new Stack();
    protected MasterPageManager masterPageManager;
    private boolean lastTable = false;

    protected AbstractOdfEmitterContext() {
        this.styleManager = new StyleManager(null);
        this.globalStyleManager = new StyleManager("Global_");
        this.masterPageManager = new MasterPageManager();
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void setLocale(ULocale locale) {
        this.locale = locale;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setTempFileDir(String tempFileDir) {
        this.tempFileDir = tempFileDir;
    }

    public String getTempFileDir() {
        return this.tempFileDir;
    }

    public void startCell() {
        this.cellind.push(true);
    }

    public void endCell() {
        this.cellind.pop();
    }

    public boolean needEmptyP() {
        return this.cellind.peek();
    }

    public void addContainer(boolean isContainer) {
        if (!this.cellind.isEmpty()) {
            this.cellind.pop();
            this.cellind.push(isContainer);
        }
    }

    public void setLastIsTable(boolean isTable) {
        this.lastTable = isTable;
    }

    public boolean isLastTable() {
        return this.lastTable;
    }

    public StyleManager getGlobalStyleManager() {
        return this.globalStyleManager;
    }

    public StyleManager getStyleManager() {
        return this.styleManager;
    }

    public void setReportDpi(int dpi) {
        this.dpi = dpi;
    }

    public int getReportDpi() {
        return this.dpi;
    }

    public String addStyle(String prefix, StyleEntry style) {
        return this.getStyleManager().addStyle(prefix, style);
    }

    public String addStyle(StyleEntry style) {
        return this.getStyleManager().addStyle(style);
    }

    public String addGlobalStyle(StyleEntry style) {
        return this.getGlobalStyleManager().addStyle(style);
    }

    public String addGlobalStyle(String prefix, StyleEntry style) {
        return this.getGlobalStyleManager().addStyle(prefix, style);
    }

    public double[] getCurrentTableColmns() {
        return this.tables.getLast().getColumnWidths();
    }

    public void addTable(double[] cols, IStyle style) {
        this.tables.addLast(new TableInfo(cols, style));
    }

    public IStyle getTableStyle() {
        return this.tables.getLast().getTableStyle();
    }

    public void newRow() {
        this.tables.getLast().newRow();
    }

    public void addSpan(int colmunId, int columnSpan, int rowSpan, StyleEntry style) {
        this.tables.getLast().addSpan(colmunId, columnSpan, rowSpan, style);
    }

    public void removeTable() {
        this.tables.removeLast();
    }

    public List<SpanInfo> getSpans(int col) {
        return this.tables.getLast().getSpans(col);
    }

    public MasterPageManager getMasterPageManager() {
        return this.masterPageManager;
    }

    public ImageManager getImageManager() {
        if (this.imageManager == null && this.pkg != null) {
            this.imageManager = new ImageManager(this.pkg);
        }
        return this.imageManager;
    }
}

