/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousOption;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousOption;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParametersChecker;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParametersUpdater;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSourceAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsChecker;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetsUpdater;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdvancedDataSetAdapter
extends DataSetAdapter {
    AdvancedDataSetAdapter() {
    }

    void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, List<OdaDataSetParameter> parameterList, List<OdaResultSetColumn> resultSetList, boolean isSourceChanged) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        this.updateDataSetHandle(setDesign, setHandle, isSourceChanged, parameterList, resultSetList);
    }

    void updateDataSetHandle(OdaDataSetHandle setHandle, OdaDesignSession completedSession, List<OdaDataSetParameter> parameterList, List<OdaResultSetColumn> resultSetList) throws SemanticException {
        if (completedSession == null || setHandle == null) {
            return;
        }
        DataSetDesign responseDesign = completedSession.getResponseDataSetDesign();
        this.updateDataSetHandle(responseDesign, setHandle, false, parameterList, resultSetList);
    }

    IAmbiguousOption getAmbiguousOption(DataSetDesign setDesign, OdaDataSetHandle setHandle) {
        AmbiguousOption option = new AmbiguousOption();
        if (setDesign == null || setHandle == null) {
            return option;
        }
        DataSetParametersChecker paramsChecker = new DataSetParametersChecker(setDesign, setHandle);
        option.setAmbiguousParameters(paramsChecker.process());
        ResultSetsChecker resultsetsChecker = new ResultSetsChecker(setDesign, setHandle);
        option.setAmbiguousResultSets(resultsetsChecker.process());
        return option;
    }

    private void updateDataSetHandle(DataSetDesign setDesign, OdaDataSetHandle setHandle, boolean isSourceChanged, List<OdaDataSetParameter> parameterList, List<OdaResultSetColumn> resultSetList) throws SemanticException {
        if (setDesign == null || setHandle == null) {
            return;
        }
        DesignUtil.validateObject((EObject)setDesign);
        CommandStack stack = setHandle.getModuleHandle().getCommandStack();
        stack.startTrans(null);
        try {
            Property prop;
            int i;
            EList propList;
            setHandle.getElement().setProperty("extensionID", (Object)setDesign.getOdaExtensionDataSetId());
            setHandle.setName(setDesign.getName());
            setHandle.setDisplayName(setDesign.getDisplayName());
            Properties props = setDesign.getPublicProperties();
            if (props != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            if ((props = setDesign.getPrivateProperties()) != null) {
                propList = props.getProperties();
                i = 0;
                while (i < propList.size()) {
                    prop = (Property)propList.get(i);
                    setHandle.setPrivateDriverProperty(prop.getName(), prop.getValue());
                    ++i;
                }
            }
            ResultSetsUpdater resultUpdater = new ResultSetsUpdater(setDesign, setHandle, resultSetList);
            resultUpdater.processResultSets(setDesign.getResultSets());
            setHandle.setResultSetName(setDesign.getPrimaryResultSetName());
            setHandle.setQueryText(setDesign.getQueryText());
            DataSetParametersUpdater updater = new DataSetParametersUpdater(setDesign, setHandle, parameterList);
            updater.processDataSetParameters(setDesign.getParameters());
            DataSourceDesign sourceDesign = setDesign.getDataSourceDesign();
            if (sourceDesign != null) {
                OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)setHandle.getDataSource();
                DataSourceAdapter dataSourceAdapter = new DataSourceAdapter();
                if (isSourceChanged && sourceHandle != null && !sourceHandle.getModuleHandle().isReadOnly()) {
                    setHandle.setDataSource(sourceDesign.getName());
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
                if (!(isSourceChanged || sourceHandle == null || sourceHandle.getModuleHandle().isReadOnly() || dataSourceAdapter.isEqualDataSourceDesign(dataSourceAdapter.createDataSourceDesign(sourceHandle), sourceDesign))) {
                    dataSourceAdapter.updateDataSourceHandle(sourceDesign, sourceHandle);
                }
            } else {
                setHandle.setDataSource(null);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

