/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.elements.structures.StyleRule;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class HighlightRule
extends StyleRule {
    public static final String BORDER_TOP_STYLE_MEMBER = "borderTopStyle";
    public static final String BORDER_TOP_WIDTH_MEMBER = "borderTopWidth";
    public static final String BORDER_TOP_COLOR_MEMBER = "borderTopColor";
    public static final String BORDER_LEFT_STYLE_MEMBER = "borderLeftStyle";
    public static final String BORDER_LEFT_WIDTH_MEMBER = "borderLeftWidth";
    public static final String BORDER_LEFT_COLOR_MEMBER = "borderLeftColor";
    public static final String BORDER_BOTTOM_STYLE_MEMBER = "borderBottomStyle";
    public static final String BORDER_BOTTOM_WIDTH_MEMBER = "borderBottomWidth";
    public static final String BORDER_BOTTOM_COLOR_MEMBER = "borderBottomColor";
    public static final String BORDER_RIGHT_STYLE_MEMBER = "borderRightStyle";
    public static final String BORDER_RIGHT_WIDTH_MEMBER = "borderRightWidth";
    public static final String BORDER_RIGHT_COLOR_MEMBER = "borderRightColor";
    public static final String BACKGROUND_COLOR_MEMBER = "backgroundColor";
    public static final String DATE_TIME_FORMAT_MEMBER = "dateTimeFormat";
    public static final String NUMBER_FORMAT_MEMBER = "numberFormat";
    public static final String NUMBER_ALIGN_MEMBER = "numberAlign";
    public static final String STRING_FORMAT_MEMBER = "stringFormat";
    public static final String FONT_FAMILY_MEMBER = "fontFamily";
    public static final String FONT_SIZE_MEMBER = "fontSize";
    public static final String FONT_STYLE_MEMBER = "fontStyle";
    public static final String FONT_WEIGHT_MEMBER = "fontWeight";
    public static final String FONT_VARIANT_MEMBER = "fontVariant";
    public static final String COLOR_MEMBER = "color";
    public static final String TEXT_UNDERLINE_MEMBER = "textUnderline";
    public static final String TEXT_OVERLINE_MEMBER = "textOverline";
    public static final String TEXT_LINE_THROUGH_MEMBER = "textLineThrough";
    public static final String TEXT_ALIGN_MEMBER = "textAlign";
    public static final String TEXT_TRANSFORM_MEMBER = "textTransform";
    public static final String TEXT_INDENT_MEMBER = "textIndent";
    public static final String TEXT_DIRECTION_MEMBER = "bidiTextDirection";
    public static final String PADDING_TOP_MEMBER = "paddingTop";
    public static final String PADDING_LEFT_MEMBER = "paddingLeft";
    public static final String PADDING_BOTTOM_MEMBER = "paddingBottom";
    public static final String PADDING_RIGHT_MEMBER = "paddingRight";
    public static final String STRUCTURE_NAME = "HighlightRule";
    public static final String STYLE_MEMBER = "style";
    private ElementRefValue style = null;

    public HighlightRule() {
    }

    public HighlightRule(String op, String v1, String v2, String testExpre) {
        super(op, v1, v2, testExpre);
    }

    public String getStructName() {
        return STRUCTURE_NAME;
    }

    public IStructureDefn getDefn() {
        return MetaDataDictionary.getInstance().getStructure(STRUCTURE_NAME);
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new HighlightRuleHandle(valueHandle, index);
    }

    protected Object getIntrinsicProperty(String propName) {
        if (STYLE_MEMBER.equals(propName)) {
            return this.style;
        }
        return super.getIntrinsicProperty(propName);
    }

    private StyleElement getStyle(Module module) {
        this.getLocalProperty(module, (PropertyDefn)this.getMemberDefn(STYLE_MEMBER));
        if (this.style == null) {
            return null;
        }
        return (StyleElement)this.style.getElement();
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (STYLE_MEMBER.equals(propName)) {
            this.style = value instanceof String ? new ElementRefValue(StringUtil.extractNamespace((String)value), StringUtil.extractName((String)value)) : (value instanceof StyleElement ? new ElementRefValue(null, (Style)value) : (ElementRefValue)value);
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public Object getProperty(Module module, PropertyDefn propDefn) {
        ElementPropertyDefn newPropDefn;
        Object value = this.getLocalProperty(module, propDefn);
        if (value != null) {
            return value;
        }
        StyleElement styleElement = this.getStyle(module);
        if (styleElement != null && (newPropDefn = styleElement.getPropertyDefn(propDefn.getName())) != null && newPropDefn.isStyleProperty()) {
            value = styleElement.getLocalProperty(module, newPropDefn);
        }
        if (value != null) {
            return value;
        }
        return propDefn.getDefault();
    }

    public void setStyle(StyleHandle styleElement) {
        DesignElement element = styleElement == null ? null : styleElement.getElement();
        this.setProperty(STYLE_MEMBER, (Object)element);
    }

    public StyleHandle getStyle() {
        if (this.style == null || !this.style.isResolved()) {
            return null;
        }
        Style styleElement = (Style)this.style.getElement();
        Module root = styleElement.getRoot();
        return (StyleHandle)styleElement.getHandle(root);
    }
}

